/************************************************************************************************/
/* Stata User File for H38 Data                                                                 */
/*                                                                                              */
/* This file contains information and a sample Stata program to create a permanent              */
/* Stata dataset for users who want to use Stata in processing the MEPS data provided           */
/* in this PUF release.  Stata (StataCorp) has the capability to produce                        */
/* appropriate standard errors for estimates from a survey with a complex sample                */
/* design such as the Medical Expenditure Panel Survey (MEPS).                                  */
/* The input file for creating a permanent Stata dataset is the ASCII data file                 */
/* (H38.DAT) supplied in this PUF release, which in turn can be extracted from the              */
/* .EXE file. After entering the Stata interactive environment access the Stata DO-File         */
/* editor by clicking on the appropriate icon in the command line at the top of the             */
/* screen.  Copy and paste the following Stata commands into the editor and save as a           */
/* DO file.  A DO file is a Stata program which may then be executed using the DO command.      */
/* For example, if the DO file is named H38.DO and is located in the directory                  */
/* C:\MEPS\PROG, then the file may be executed by typing the following command into             */
/* the Stata command line:                                                                      */
/*                         do C:\MEPS\PROG\H38.DO                                               */
/* The program below will output the Stata dataset H38.DTA                                      */
/************************************************************************************************/


#delimit ;
cd $datadir/MEPS/dat/fullyearconsolidated;
clear;

* INPUT ALL VARIABLES;
infix
  long   DUID 1-5
  int    PID 6-8
  str    DUPERSID 9-16
  byte   PANEL99 17-17
  str    FAMID31 18-19
  str    FAMID42 20-21
  str    FAMID53 22-23
  str    FAMID99 24-25
  str    FAMIDYR 26-27
  str    CPSFAMID 28-29
  str    HIEUIDX 30-41
  byte   FCSZ1231 42-43
  byte   FCRP1231 44-45
  str    RULETR31 46-47
  str    RULETR42 48-49
  str    RULETR53 50-51
  str    RULETR99 52-53
  byte   RUSIZE31 54-55
  byte   RUSIZE42 56-57
  byte   RUSIZE53 58-59
  byte   RUSIZE99 60-61
  byte   RUCLAS31 62-63
  byte   RUCLAS42 64-65
  byte   RUCLAS53 66-67
  byte   RUCLAS99 68-68
  byte   FAMSZE31 69-70
  byte   FAMSZE42 71-72
  byte   FAMSZE53 73-74
  byte   FAMSZE99 75-76
  byte   FMRS1231 77-78
  byte   FAMS1231 79-80
  byte   FAMSZEYR 81-82
  byte   FAMRFPYR 83-84
  byte   FYFAMTYP 85-85
  byte   INRU1231 86-86
  byte   REGION31 87-88
  byte   REGION42 89-90
  byte   REGION53 91-92
  byte   REGION99 93-94
  byte   MSA53 95-96
  byte   MSA99 97-98
  int    REFPRS31 99-101
  int    REFPRS42 102-104
  int    REFPRS53 105-107
  int    REFPRS99 108-110
  byte   RESP31 111-111
  byte   RESP42 112-112
  byte   RESP53 113-113
  byte   RESP99 114-114
  byte   PROXY31 115-116
  byte   PROXY42 117-118
  byte   PROXY53 119-120
  byte   PROXY99 121-121
  byte   INTVLANG 122-123
  byte   BEGRFD31 124-125
  byte   BEGRFM31 126-127
  int    BEGRFY31 128-131
  byte   ENDRFD31 132-133
  byte   ENDRFM31 134-135
  int    ENDRFY31 136-139
  byte   BEGRFD42 140-141
  byte   BEGRFM42 142-143
  int    BEGRFY42 144-147
  byte   ENDRFD42 148-149
  byte   ENDRFM42 150-151
  int    ENDRFY42 152-155
  byte   BEGRFD53 156-157
  byte   BEGRFM53 158-159
  int    BEGRFY53 160-163
  byte   ENDRFD53 164-165
  byte   ENDRFM53 166-167
  int    ENDRFY53 168-171
  byte   ENDRFD99 172-173
  byte   ENDRFM99 174-175
  int    ENDRFY99 176-179
  byte   KEYNESS 180-180
  byte   INSCOP31 181-181
  byte   INSCOP42 182-182
  byte   INSCOP53 183-183
  byte   INSCOP99 184-184
  byte   INSC1231 185-185
  byte   INSCOPE 186-186
  byte   ELGRND31 187-187
  byte   ELGRND42 188-188
  byte   ELGRND53 189-189
  byte   ELGRND99 190-190
  byte   ELIGIBLE 191-191
  byte   PSTATS31 192-193
  byte   PSTATS42 194-195
  byte   PSTATS53 196-197
  str    RURSLT31 198-199
  str    RURSLT42 200-201
  str    RURSLT53 202-203
  byte   R2FLAG 204-205
  byte   AGE31X 206-207
  byte   AGE42X 208-209
  byte   AGE53X 210-211
  byte   AGE99X 212-213
  byte   DOBMM 214-215
  int    DOBYY 216-219
  byte   SEX 220-220
  byte   RACEX 221-221
  byte   RACETHNX 222-222
  byte   HISPANX 223-223
  byte   HISPCAT 224-225
  byte   MARRY31X 226-227
  byte   MARRY42X 228-229
  byte   MARRY53X 230-231
  byte   MARRY99X 232-233
  int    SPOUID31 234-236
  int    SPOUID42 237-239
  int    SPOUID53 240-242
  int    SPOUID99 243-245
  byte   SPOUIN31 246-247
  byte   SPOUIN42 248-249
  byte   SPOUIN53 250-251
  byte   SPOUIN99 252-253
  byte   EDUCYEAR 254-255
  byte   HIDEGYR 256-257
  byte   FTSTU31X 258-259
  byte   FTSTU42X 260-261
  byte   FTSTU53X 262-263
  byte   FTSTU99X 264-265
  byte   ACTDTY31 266-267
  byte   ACTDTY42 268-269
  byte   ACTDTY53 270-271
  byte   DIDSERVE 272-273
  byte   VETPVIET 274-275
  byte   VETVIET 276-277
  byte   VETKOR 278-279
  byte   VETWW 280-281
  byte   VETOTH 282-283
  byte   RFREL31X 284-285
  byte   RFREL42X 286-287
  byte   RFREL53X 288-289
  byte   RFREL99X 290-291
  int    MOPID31X 292-294
  int    MOPID42X 295-297
  int    MOPID53X 298-300
  int    DAPID31X 301-303
  int    DAPID42X 304-306
  int    DAPID53X 307-309
  byte   SSIDIS99 310-311
  byte   AFDC99 312-313
  byte   FILEDR99 314-315
  byte   WILFIL99 316-317
  byte   FLSTAT99 318-319
  byte   FILER99 320-321
  byte   JTINRU99 322-323
  int    JNTPID99 324-326
  byte   CLMDEP99 327-328
  byte   DEPDNT99 329-330
  byte   DPINRU99 331-332
  byte   DPOTSD99 333-334
  byte   TAXFRM99 335-336
  byte   DEDUCT99 337-338
  byte   ITMEXP99 339-340
  double MEXAMT99 341-348
  double NTMDED99 349-356
  double TOTDED99 357-365
  byte   CLMHIP99 366-367
  byte   ELDISC99 368-369
  byte   EICRDT99 370-371
  int    UNEMTX99 372-374
  int    INTRTX99 375-377
  int    SSECTX99 378-380
  int    IRATAX99 381-383
  byte   FOODST99 384-385
  byte   FOODMN99 386-387
  double FOODCT99 388-394
  double FOODVL99 395-400
  long   TTLP99X 401-406
  byte   POVCAT99 407-407
  long   WAGEP99X 408-413
  byte   WAGIMP99 414-414
  long   BUSNP99X 415-420
  byte   BUSIMP99 421-421
  long   FARMP99X 422-427
  byte   FARIMP99 428-428
  long   UNEMP99X 429-433
  byte   UNEIMP99 434-434
  long   WCMPP99X 435-439
  byte   WCPIMP99 440-440
  long   INTRP99X 441-445
  byte   INTIMP99 446-446
  long   DIVDP99X 447-451
  byte   DIVIMP99 452-452
  long   SALEP99X 453-458
  byte   SALIMP99 459-459
  long   PENSP99X 460-464
  byte   PENIMP99 465-465
  long   SSECP99X 466-470
  byte   SSCIMP99 471-471
  long   TRSTP99X 472-477
  byte   TRTIMP99 478-478
  long   VETSP99X 479-483
  byte   VETIMP99 484-484
  long   IRASP99X 485-489
  byte   IRAIMP99 490-490
  long   REFDP99X 491-495
  byte   REFIMP99 496-496
  long   ALIMP99X 497-501
  byte   ALIIMP99 502-502
  long   CHLDP99X 503-508
  byte   CHLIMP99 509-509
  long   CASHP99X 510-514
  byte   CSHIMP99 515-515
  long   SSIP99X 516-520
  byte   SSIIMP99 521-521
  long   PUBP99X 522-526
  byte   PUBIMP99 527-527
  long   OTHRP99X 528-532
  byte   OTHIMP99 533-533
  byte   EMPST31 534-535
  byte   EMPST42 536-537
  byte   EMPST53 538-539
  byte   RNDFLG31 540-541
  byte   MORJOB31 542-543
  byte   MORJOB42 544-545
  byte   MORJOB53 546-547
  byte   EVRWRK 548-549
  double HRWG31X 550-555
  double HRWG42X 556-561
  double HRWG53X 562-567
  byte   HRWGIM31 568-568
  byte   HRWGIM42 569-569
  byte   HRWGIM53 570-570
  byte   HRHOW31 571-572
  byte   HRHOW42 573-574
  byte   HRHOW53 575-576
  int    HOUR31 577-579
  int    HOUR42 580-582
  int    HOUR53 583-585
  byte   SELFCM31 586-587
  byte   SELFCM42 588-589
  byte   SELFCM53 590-591
  byte   DISVW31X 592-593
  byte   DISVW42X 594-595
  byte   DISVW53X 596-597
  byte   CHOIC31 598-599
  byte   CHOIC42 600-601
  byte   CHOIC53 602-603
  byte   CIND31 604-605
  byte   CIND42 606-607
  byte   CIND53 608-609
  int    NUMEMP31 610-612
  int    NUMEMP42 613-615
  int    NUMEMP53 616-618
  byte   MORE31 619-620
  byte   MORE42 621-622
  byte   MORE53 623-624
  byte   UNION31 625-626
  byte   UNION42 627-628
  byte   UNION53 629-630
  byte   NWK31 631-632
  byte   NWK42 633-634
  byte   NWK53 635-636
  byte   CHGJ3142 637-638
  byte   CHGJ4253 639-640
  byte   YCHJ3142 641-642
  byte   YCHJ4253 643-644
  byte   STJBMM31 645-646
  byte   STJBDD31 647-648
  int    STJBYY31 649-652
  byte   STJBMM42 653-654
  byte   STJBDD42 655-656
  int    STJBYY42 657-660
  byte   STJBMM53 661-662
  byte   STJBDD53 663-664
  int    STJBYY53 665-668
  byte   EVRETIRE 669-670
  byte   COCCP31 671-672
  byte   COCCP42 673-674
  byte   COCCP53 675-676
  byte   BGNWK31 677-678
  byte   BGNWK42 679-680
  byte   BGNWK53 681-682
  byte   ENDWK31 683-684
  byte   ENDWK42 685-686
  byte   ENDWK53 687-688
  byte   PAYVAC31 689-690
  byte   PAYVAC42 691-692
  byte   PAYVAC53 693-694
  byte   SICPAY31 695-696
  byte   SICPAY42 697-698
  byte   SICPAY53 699-700
  byte   PAYDR31 701-702
  byte   PAYDR42 703-704
  byte   PAYDR53 705-706
  byte   RETPLN31 707-708
  byte   RETPLN42 709-710
  byte   RETPLN53 711-712
  byte   SHFTWK31 713-714
  byte   SHFTWK42 715-716
  byte   SHFTWK53 717-718
  byte   BSNTY31 719-720
  byte   BSNTY42 721-722
  byte   BSNTY53 723-724
  byte   JOBORG31 725-726
  byte   JOBORG42 727-728
  byte   JOBORG53 729-730
  byte   HELD31X 731-732
  byte   HELD42X 733-734
  byte   HELD53X 735-736
  byte   OFFER31X 737-738
  byte   OFFER42X 739-740
  byte   OFFER53X 741-742
  byte   CHJA99X 743-744
  byte   CHFE99X 745-746
  byte   CHMA99X 747-748
  byte   CHAP99X 749-750
  byte   CHMY99X 751-752
  byte   CHJU99X 753-754
  byte   CHJL99X 755-756
  byte   CHAU99X 757-758
  byte   CHSE99X 759-760
  byte   CHOC99X 761-762
  byte   CHNO99X 763-764
  byte   CHDE99X 765-766
  byte   MCRJA99 767-768
  byte   MCRFE99 769-770
  byte   MCRMA99 771-772
  byte   MCRAP99 773-774
  byte   MCRMY99 775-776
  byte   MCRJU99 777-778
  byte   MCRJL99 779-780
  byte   MCRAU99 781-782
  byte   MCRSE99 783-784
  byte   MCROC99 785-786
  byte   MCRNO99 787-788
  byte   MCRDE99 789-790
  byte   MCRJA99X 791-792
  byte   MCRFE99X 793-794
  byte   MCRMA99X 795-796
  byte   MCRAP99X 797-798
  byte   MCRMY99X 799-800
  byte   MCRJU99X 801-802
  byte   MCRJL99X 803-804
  byte   MCRAU99X 805-806
  byte   MCRSE99X 807-808
  byte   MCROC99X 809-810
  byte   MCRNO99X 811-812
  byte   MCRDE99X 813-814
  byte   MCDJA99 815-816
  byte   MCDFE99 817-818
  byte   MCDMA99 819-820
  byte   MCDAP99 821-822
  byte   MCDMY99 823-824
  byte   MCDJU99 825-826
  byte   MCDJL99 827-828
  byte   MCDAU99 829-830
  byte   MCDSE99 831-832
  byte   MCDOC99 833-834
  byte   MCDNO99 835-836
  byte   MCDDE99 837-838
  byte   MCDJA99X 839-840
  byte   MCDFE99X 841-842
  byte   MCDMA99X 843-844
  byte   MCDAP99X 845-846
  byte   MCDMY99X 847-848
  byte   MCDJU99X 849-850
  byte   MCDJL99X 851-852
  byte   MCDAU99X 853-854
  byte   MCDSE99X 855-856
  byte   MCDOC99X 857-858
  byte   MCDNO99X 859-860
  byte   MCDDE99X 861-862
  byte   OPAJA99 863-864
  byte   OPAFE99 865-866
  byte   OPAMA99 867-868
  byte   OPAAP99 869-870
  byte   OPAMY99 871-872
  byte   OPAJU99 873-874
  byte   OPAJL99 875-876
  byte   OPAAU99 877-878
  byte   OPASE99 879-880
  byte   OPAOC99 881-882
  byte   OPANO99 883-884
  byte   OPADE99 885-886
  byte   OPBJA99 887-888
  byte   OPBFE99 889-890
  byte   OPBMA99 891-892
  byte   OPBAP99 893-894
  byte   OPBMY99 895-896
  byte   OPBJU99 897-898
  byte   OPBJL99 899-900
  byte   OPBAU99 901-902
  byte   OPBSE99 903-904
  byte   OPBOC99 905-906
  byte   OPBNO99 907-908
  byte   OPBDE99 909-910
  byte   STAJA99 911-912
  byte   STAFE99 913-914
  byte   STAMA99 915-916
  byte   STAAP99 917-918
  byte   STAMY99 919-920
  byte   STAJU99 921-922
  byte   STAJL99 923-924
  byte   STAAU99 925-926
  byte   STASE99 927-928
  byte   STAOC99 929-930
  byte   STANO99 931-932
  byte   STADE99 933-934
  byte   PUBJA99X 935-936
  byte   PUBFE99X 937-938
  byte   PUBMA99X 939-940
  byte   PUBAP99X 941-942
  byte   PUBMY99X 943-944
  byte   PUBJU99X 945-946
  byte   PUBJL99X 947-948
  byte   PUBAU99X 949-950
  byte   PUBSE99X 951-952
  byte   PUBOC99X 953-954
  byte   PUBNO99X 955-956
  byte   PUBDE99X 957-958
  byte   PEGJA99 959-960
  byte   PEGFE99 961-962
  byte   PEGMA99 963-964
  byte   PEGAP99 965-966
  byte   PEGMY99 967-968
  byte   PEGJU99 969-970
  byte   PEGJL99 971-972
  byte   PEGAU99 973-974
  byte   PEGSE99 975-976
  byte   PEGOC99 977-978
  byte   PEGNO99 979-980
  byte   PEGDE99 981-982
  byte   PDKJA99 983-984
  byte   PDKFE99 985-986
  byte   PDKMA99 987-988
  byte   PDKAP99 989-990
  byte   PDKMY99 991-992
  byte   PDKJU99 993-994
  byte   PDKJL99 995-996
  byte   PDKAU99 997-998
  byte   PDKSE99 999-1000
  byte   PDKOC99 1001-1002
  byte   PDKNO99 1003-1004
  byte   PDKDE99 1005-1006
  byte   PNGJA99 1007-1008
  byte   PNGFE99 1009-1010
  byte   PNGMA99 1011-1012
  byte   PNGAP99 1013-1014
  byte   PNGMY99 1015-1016
  byte   PNGJU99 1017-1018
  byte   PNGJL99 1019-1020
  byte   PNGAU99 1021-1022
  byte   PNGSE99 1023-1024
  byte   PNGOC99 1025-1026
  byte   PNGNO99 1027-1028
  byte   PNGDE99 1029-1030
  byte   POGJA99 1031-1032
  byte   POGFE99 1033-1034
  byte   POGMA99 1035-1036
  byte   POGAP99 1037-1038
  byte   POGMY99 1039-1040
  byte   POGJU99 1041-1042
  byte   POGJL99 1043-1044
  byte   POGAU99 1045-1046
  byte   POGSE99 1047-1048
  byte   POGOC99 1049-1050
  byte   POGNO99 1051-1052
  byte   POGDE99 1053-1054
  byte   PRSJA99 1055-1056
  byte   PRSFE99 1057-1058
  byte   PRSMA99 1059-1060
  byte   PRSAP99 1061-1062
  byte   PRSMY99 1063-1064
  byte   PRSJU99 1065-1066
  byte   PRSJL99 1067-1068
  byte   PRSAU99 1069-1070
  byte   PRSSE99 1071-1072
  byte   PRSOC99 1073-1074
  byte   PRSNO99 1075-1076
  byte   PRSDE99 1077-1078
  byte   POUJA99 1079-1080
  byte   POUFE99 1081-1082
  byte   POUMA99 1083-1084
  byte   POUAP99 1085-1086
  byte   POUMY99 1087-1088
  byte   POUJU99 1089-1090
  byte   POUJL99 1091-1092
  byte   POUAU99 1093-1094
  byte   POUSE99 1095-1096
  byte   POUOC99 1097-1098
  byte   POUNO99 1099-1100
  byte   POUDE99 1101-1102
  byte   PRIJA99 1103-1104
  byte   PRIFE99 1105-1106
  byte   PRIMA99 1107-1108
  byte   PRIAP99 1109-1110
  byte   PRIMY99 1111-1112
  byte   PRIJU99 1113-1114
  byte   PRIJL99 1115-1116
  byte   PRIAU99 1117-1118
  byte   PRISE99 1119-1120
  byte   PRIOC99 1121-1122
  byte   PRINO99 1123-1124
  byte   PRIDE99 1125-1126
  byte   HPEJA99 1127-1128
  byte   HPEFE99 1129-1130
  byte   HPEMA99 1131-1132
  byte   HPEAP99 1133-1134
  byte   HPEMY99 1135-1136
  byte   HPEJU99 1137-1138
  byte   HPEJL99 1139-1140
  byte   HPEAU99 1141-1142
  byte   HPESE99 1143-1144
  byte   HPEOC99 1145-1146
  byte   HPENO99 1147-1148
  byte   HPEDE99 1149-1150
  byte   HPDJA99 1151-1152
  byte   HPDFE99 1153-1154
  byte   HPDMA99 1155-1156
  byte   HPDAP99 1157-1158
  byte   HPDMY99 1159-1160
  byte   HPDJU99 1161-1162
  byte   HPDJL99 1163-1164
  byte   HPDAU99 1165-1166
  byte   HPDSE99 1167-1168
  byte   HPDOC99 1169-1170
  byte   HPDNO99 1171-1172
  byte   HPDDE99 1173-1174
  byte   HPNJA99 1175-1176
  byte   HPNFE99 1177-1178
  byte   HPNMA99 1179-1180
  byte   HPNAP99 1181-1182
  byte   HPNMY99 1183-1184
  byte   HPNJU99 1185-1186
  byte   HPNJL99 1187-1188
  byte   HPNAU99 1189-1190
  byte   HPNSE99 1191-1192
  byte   HPNOC99 1193-1194
  byte   HPNNO99 1195-1196
  byte   HPNDE99 1197-1198
  byte   HPOJA99 1199-1200
  byte   HPOFE99 1201-1202
  byte   HPOMA99 1203-1204
  byte   HPOAP99 1205-1206
  byte   HPOMY99 1207-1208
  byte   HPOJU99 1209-1210
  byte   HPOJL99 1211-1212
  byte   HPOAU99 1213-1214
  byte   HPOSE99 1215-1216
  byte   HPOOC99 1217-1218
  byte   HPONO99 1219-1220
  byte   HPODE99 1221-1222
  byte   HPSJA99 1223-1224
  byte   HPSFE99 1225-1226
  byte   HPSMA99 1227-1228
  byte   HPSAP99 1229-1230
  byte   HPSMY99 1231-1232
  byte   HPSJU99 1233-1234
  byte   HPSJL99 1235-1236
  byte   HPSAU99 1237-1238
  byte   HPSSE99 1239-1240
  byte   HPSOC99 1241-1242
  byte   HPSNO99 1243-1244
  byte   HPSDE99 1245-1246
  byte   HPRJA99 1247-1248
  byte   HPRFE99 1249-1250
  byte   HPRMA99 1251-1252
  byte   HPRAP99 1253-1254
  byte   HPRMY99 1255-1256
  byte   HPRJU99 1257-1258
  byte   HPRJL99 1259-1260
  byte   HPRAU99 1261-1262
  byte   HPRSE99 1263-1264
  byte   HPROC99 1265-1266
  byte   HPRNO99 1267-1268
  byte   HPRDE99 1269-1270
  byte   INSJA99X 1271-1272
  byte   INSFE99X 1273-1274
  byte   INSMA99X 1275-1276
  byte   INSAP99X 1277-1278
  byte   INSMY99X 1279-1280
  byte   INSJU99X 1281-1282
  byte   INSJL99X 1283-1284
  byte   INSAU99X 1285-1286
  byte   INSSE99X 1287-1288
  byte   INSOC99X 1289-1290
  byte   INSNO99X 1291-1292
  byte   INSDE99X 1293-1294
  byte   PRVEV99 1295-1295
  byte   CHPEV99 1296-1296
  byte   MCREV99 1297-1297
  byte   MCDEV99 1298-1298
  byte   OPAEV99 1299-1299
  byte   OPBEV99 1300-1300
  byte   UNINS99 1301-1301
  byte   INSCOV99 1302-1302
  byte   DENTIN31 1303-1304
  byte   DENTIN42 1305-1306
  byte   DENTIN53 1307-1308
  byte   PMEDIN31 1309-1310
  byte   PMEDIN42 1311-1312
  byte   PMEDIN53 1313-1314
  int    DDNWRK31 1315-1317
  int    DDNWRK42 1318-1320
  int    DDNWRK53 1321-1323
  int    WKINBD31 1324-1326
  int    WKINBD42 1327-1329
  int    WKINBD53 1330-1332
  int    DDNSCL31 1333-1335
  byte   DDNSCL42 1336-1337
  int    DDNSCL53 1338-1340
  byte   SCLNBD31 1341-1342
  byte   SCLNBD42 1343-1344
  byte   SCLNBD53 1345-1346
  int    DDBDYS31 1347-1349
  int    DDBDYS42 1350-1352
  int    DDBDYS53 1353-1355
  byte   OTHDYS31 1356-1357
  byte   OTHDYS42 1358-1359
  byte   OTHDYS53 1360-1361
  byte   OTHNDD31 1362-1363
  int    OTHNDD42 1364-1366
  int    OTHNDD53 1367-1369
  byte   ACCELI42 1370-1371
  byte   HAVEUS42 1372-1373
  byte   YNOUSC42 1374-1375
  byte   NOREAS42 1376-1377
  byte   SELDSI42 1378-1379
  byte   NEWARE42 1380-1381
  byte   DKWHRU42 1382-1383
  byte   USCNOT42 1384-1385
  byte   PERSLA42 1386-1387
  byte   DIFFPL42 1388-1389
  byte   INSRPL42 1390-1391
  byte   MYSELF42 1392-1393
  byte   CARECO42 1394-1395
  byte   OTHINS42 1396-1397
  byte   OTHREA42 1398-1399
  byte   TYPEPL42 1400-1401
  byte   PROVTY42 1402-1403
  byte   YGOTOU42 1404-1405
  byte   NOREA942 1406-1407
  byte   LIKESU42 1408-1409
  byte   DKELSE42 1410-1411
  byte   AFFORD42 1412-1413
  byte   OFFICE42 1414-1415
  byte   AVAILT42 1416-1417
  byte   CONVEN42 1418-1419
  byte   BSTPLA42 1420-1421
  byte   INSREA42 1422-1423
  byte   OTHRE942 1424-1425
  byte   GETTOU42 1426-1427
  byte   TYPEPE42 1428-1429
  byte   LOCATI42 1430-1431
  byte   MINORP42 1432-1433
  byte   PREVEN42 1434-1435
  byte   REFFRL42 1436-1437
  byte   OFFHOU42 1438-1439
  byte   APPTWL42 1440-1441
  byte   APPDIF42 1442-1443
  byte   WAITTI42 1444-1445
  byte   PHONED42 1446-1447
  byte   PRLIST42 1448-1449
  byte   TREATM42 1450-1451
  byte   CONFID42 1452-1453
  byte   PROVST42 1454-1455
  byte   USCQUA42 1456-1457
  byte   CHNGUS42 1458-1459
  byte   YCHNGU42 1460-1461
  byte   ANYUSC42 1462-1463
  byte   YNOMOR42 1464-1465
  byte   NOCARE42 1466-1467
  byte   HCNEED42 1468-1469
  byte   OBTAIN42 1470-1471
  byte   MAINPR42 1472-1473
  byte   NOOTHP42 1474-1475
  byte   NOAFFO42 1476-1477
  byte   INSNOP42 1478-1479
  byte   PREEXC42 1480-1481
  byte   INSRQR42 1482-1483
  byte   REFUSI42 1484-1485
  byte   DISTAN42 1486-1487
  byte   PUBTRA42 1488-1489
  byte   EXPENS42 1490-1491
  byte   HEARPR42 1492-1493
  byte   LANGBA42 1494-1495
  byte   INTOBL42 1496-1497
  byte   INSIDE42 1498-1499
  byte   EQUIPM42 1500-1501
  byte   OFFWOR42 1502-1503
  byte   DKWHER42 1504-1505
  byte   REFUSE42 1506-1507
  byte   CHLDCA42 1508-1509
  byte   NOTIME42 1510-1511
  byte   OTHRPR42 1512-1513
  byte   RTHLTH31 1514-1515
  byte   RTHLTH42 1516-1517
  byte   RTHLTH53 1518-1519
  byte   RTPROX31 1520-1521
  byte   RTPROX42 1522-1523
  byte   RTPROX53 1524-1525
  byte   MNHLTH31 1526-1527
  byte   MNHLTH42 1528-1529
  byte   MNHLTH53 1530-1531
  byte   MNPROX31 1532-1533
  byte   MNPROX42 1534-1535
  byte   MNPROX53 1536-1537
  byte   IADLHP31 1538-1539
  byte   IADLHP42 1540-1541
  byte   IADLHP53 1542-1543
  byte   ADLHLP31 1544-1545
  byte   ADLHLP42 1546-1547
  byte   ADLHLP53 1548-1549
  byte   AIDHLP31 1550-1551
  byte   AIDHLP53 1552-1553
  byte   WLKLIM31 1554-1555
  byte   WLKLIM53 1556-1557
  byte   LFTDIF31 1558-1559
  byte   LFTDIF53 1560-1561
  byte   STPDIF31 1562-1563
  byte   STPDIF53 1564-1565
  byte   WLKDIF31 1566-1567
  byte   WLKDIF53 1568-1569
  byte   MILDIF31 1570-1571
  byte   MILDIF53 1572-1573
  byte   STNDIF31 1574-1575
  byte   STNDIF53 1576-1577
  byte   BENDIF31 1578-1579
  byte   BENDIF53 1580-1581
  byte   RCHDIF31 1582-1583
  byte   RCHDIF53 1584-1585
  byte   FNGRDF31 1586-1587
  byte   FNGRDF53 1588-1589
  byte   ACTLIM31 1590-1591
  byte   ACTLIM53 1592-1593
  byte   WRKLIM31 1594-1595
  byte   WRKLIM53 1596-1597
  byte   HSELIM31 1598-1599
  byte   HSELIM53 1600-1601
  byte   SCHLIM31 1602-1603
  byte   SCHLIM53 1604-1605
  byte   UNABLE31 1606-1607
  byte   UNABLE53 1608-1609
  byte   SOCLIM31 1610-1611
  byte   SOCLIM53 1612-1613
  byte   COGLIM31 1614-1615
  byte   COGLIM53 1616-1617
  byte   WRGLAS42 1618-1619
  byte   SEEDIF42 1620-1621
  byte   BLIND42 1622-1623
  byte   READNW42 1624-1625
  byte   RECPEP42 1626-1627
  byte   VISION42 1628-1629
  byte   HEARAD42 1630-1631
  byte   HEARDI42 1632-1633
  byte   DEAF42 1634-1635
  byte   HEARMO42 1636-1637
  byte   HEARSM42 1638-1639
  byte   HEARNG42 1640-1641
  byte   ANYLIM99 1642-1643
  byte   LIMACT42 1644-1645
  byte   PLYLIM42 1646-1647
  byte   CANTPL42 1648-1649
  byte   SPCPRO42 1650-1651
  byte   DPTSHT42 1652-1653
  byte   NUMDPT42 1654-1655
  byte   POLSHT42 1656-1657
  byte   NUMPOL42 1658-1659
  byte   MMRSHT42 1660-1661
  byte   HEPSHT42 1662-1663
  byte   MOMPRO42 1664-1665
  byte   DADPRO42 1666-1667
  byte   UNHAP42 1668-1669
  byte   SCHLBH42 1670-1671
  byte   HAVFUN42 1672-1673
  byte   ADUPRO42 1674-1675
  byte   NERVAF42 1676-1677
  byte   SIBPRO42 1678-1679
  byte   KIDPRO42 1680-1681
  byte   SPRPRO42 1682-1683
  byte   SCHPRO42 1684-1685
  byte   HOMEBH42 1686-1687
  byte   TRBLE42 1688-1689
  byte   SPCSCH42 1690-1691
  byte   SPECED42 1692-1693
  byte   SPCHTH42 1694-1695
  byte   PSYCNS42 1696-1697
  byte   OCUPTH42 1698-1699
  byte   VOCSVC42 1700-1701
  byte   TUTOR42 1702-1703
  byte   READIN42 1704-1705
  byte   PHYTHR42 1706-1707
  byte   LIFSKL42 1708-1709
  byte   FAMCNS42 1710-1711
  byte   RECTHR42 1712-1713
  byte   OTHSVC42 1714-1715
  byte   CANTSC42 1716-1717
  byte   LMOACT42 1718-1719
  byte   HLTHY42 1720-1721
  byte   NTHLTH42 1722-1723
  byte   GETSIC42 1724-1725
  byte   HGTFT42 1726-1727
  byte   HGTIN42 1728-1729
  int    WGTLB42 1730-1732
  byte   WGTOZ42 1733-1734
  byte   CHLIM42 1735-1736
  byte   WHRCAR99 1737-1738
  byte   WHOCAR99 1739-1740
  byte   DAYCAR99 1741-1742
  long   TOTTCH99 1743-1748
  long   TOTEXP99 1749-1754
  long   TOTSLF99 1755-1759
  long   TOTMCR99 1760-1765
  long   TOTMCD99 1766-1771
  long   TOTPRV99 1772-1777
  long   TOTVA99 1778-1783
  int    TOTCHM99 1784-1787
  long   TOTOFD99 1788-1792
  long   TOTSTL99 1793-1797
  long   TOTWCP99 1798-1802
  long   TOTOPR99 1803-1808
  long   TOTOPU99 1809-1813
  long   TOTOSR99 1814-1818
  int    OBTOTV99 1819-1821
  long   OBVTCH99 1822-1827
  long   OBVEXP99 1828-1832
  long   OBVSLF99 1833-1837
  long   OBVMCR99 1838-1842
  int    OBVMCD99 1843-1846
  long   OBVPRV99 1847-1851
  int    OBVVA99 1852-1855
  int    OBVCHM99 1856-1859
  int    OBVOFD99 1860-1863
  long   OBVSTL99 1864-1868
  long   OBVWCP99 1869-1873
  int    OBVOPR99 1874-1877
  int    OBVOPU99 1878-1881
  int    OBVOSR99 1882-1885
  int    OBDRV99 1886-1888
  long   OBDTCH99 1889-1893
  long   OBDEXP99 1894-1898
  long   OBDSLF99 1899-1903
  long   OBDMCR99 1904-1908
  int    OBDMCD99 1909-1912
  long   OBDPRV99 1913-1917
  int    OBDVA99 1918-1921
  int    OBDCHM99 1922-1925
  int    OBDOFD99 1926-1929
  int    OBDSTL99 1930-1933
  long   OBDWCP99 1934-1938
  int    OBDOPR99 1939-1942
  int    OBDOPU99 1943-1946
  int    OBDOSR99 1947-1950
  int    OBOTHV99 1951-1953
  long   OBOTCH99 1954-1959
  long   OBOEXP99 1960-1964
  int    OBOSLF99 1965-1968
  long   OBOMCR99 1969-1973
  int    OBOMCD99 1974-1977
  long   OBOPRV99 1978-1982
  int    OBOVA99 1983-1986
  int    OBOCHM99 1987-1990
  int    OBOOFD99 1991-1994
  long   OBOSTL99 1995-1999
  int    OBOWCP99 2000-2003
  int    OBOOPR99 2004-2007
  int    OBOOPU99 2008-2011
  int    OBOOSR99 2012-2015
  byte   OBCHIR99 2016-2017
  int    OBCTCH99 2018-2021
  int    OBCEXP99 2022-2025
  int    OBCSLF99 2026-2029
  int    OBCMCR99 2030-2032
  int    OBCMCD99 2033-2035
  int    OBCPRV99 2036-2039
  int    OBCVA99 2040-2042
  byte   OBCCHM99 2043-2044
  byte   OBCOFD99 2045-2045
  int    OBCSTL99 2046-2049
  int    OBCWCP99 2050-2053
  int    OBCOPR99 2054-2057
  byte   OBCOPU99 2058-2059
  int    OBCOSR99 2060-2063
  int    OBNURS99 2064-2066
  long   OBNTCH99 2067-2071
  long   OBNEXP99 2072-2076
  int    OBNSLF99 2077-2080
  int    OBNMCR99 2081-2084
  int    OBNMCD99 2085-2088
  int    OBNPRV99 2089-2092
  int    OBNVA99 2093-2096
  int    OBNCHM99 2097-2100
  int    OBNOFD99 2101-2104
  long   OBNSTL99 2105-2109
  int    OBNWCP99 2110-2112
  int    OBNOPR99 2113-2115
  int    OBNOPU99 2116-2118
  int    OBNOSR99 2119-2121
  byte   OBOPTO99 2122-2123
  int    OBETCH99 2124-2127
  int    OBEEXP99 2128-2131
  int    OBESLF99 2132-2134
  int    OBEMCR99 2135-2137
  int    OBEMCD99 2138-2140
  int    OBEPRV99 2141-2144
  int    OBEVA99 2145-2147
  byte   OBECHM99 2148-2149
  byte   OBEOFD99 2150-2151
  byte   OBESTL99 2152-2153
  byte   OBEWCP99 2154-2154
  int    OBEOPR99 2155-2157
  byte   OBEOPU99 2158-2158
  int    OBEOSR99 2159-2161
  byte   OBASST99 2162-2163
  long   OBATCH99 2164-2169
  int    OBAEXP99 2170-2173
  int    OBASLF99 2174-2176
  int    OBAMCR99 2177-2179
  int    OBAMCD99 2180-2182
  int    OBAPRV99 2183-2186
  int    OBAVA99 2187-2189
  int    OBACHM99 2190-2192
  int    OBAOFD99 2193-2195
  int    OBASTL99 2196-2198
  int    OBAWCP99 2199-2201
  int    OBAOPR99 2202-2204
  byte   OBAOPU99 2205-2206
  int    OBAOSR99 2207-2209
  int    OBTHER99 2210-2212
  long   OBTTCH99 2213-2217
  int    OBTEXP99 2218-2221
  int    OBTSLF99 2222-2225
  int    OBTMCR99 2226-2229
  int    OBTMCD99 2230-2233
  int    OBTPRV99 2234-2237
  int    OBTVA99 2238-2241
  int    OBTCHM99 2242-2244
  int    OBTOFD99 2245-2247
  int    OBTSTL99 2248-2251
  int    OBTWCP99 2252-2255
  int    OBTOPR99 2256-2258
  int    OBTOPU99 2259-2261
  int    OBTOSR99 2262-2265
  int    OPTOTV99 2266-2268
  long   OPFTCH99 2269-2274
  long   OPFEXP99 2275-2279
  int    OPFSLF99 2280-2283
  long   OPFMCR99 2284-2288
  long   OPFMCD99 2289-2293
  long   OPFPRV99 2294-2298
  long   OPFVA99 2299-2303
  int    OPFCHM99 2304-2307
  long   OPFOFD99 2308-2312
  int    OPFSTL99 2313-2316
  long   OPFWCP99 2317-2321
  int    OPFOPR99 2322-2325
  int    OPFOPU99 2326-2329
  int    OPFOSR99 2330-2333
  long   OPDEXP99 2334-2338
  long   OPDTCH99 2339-2343
  int    OPDSLF99 2344-2347
  int    OPDMCR99 2348-2351
  int    OPDMCD99 2352-2355
  long   OPDPRV99 2356-2360
  int    OPDVA99 2361-2364
  int    OPDCHM99 2365-2368
  byte   OPDOFD99 2369-2369
  byte   OPDSTL99 2370-2370
  int    OPDWCP99 2371-2374
  int    OPDOPR99 2375-2378
  int    OPDOPU99 2379-2381
  int    OPDOSR99 2382-2384
  int    OPDRV99 2385-2387
  long   OPVTCH99 2388-2392
  long   OPVEXP99 2393-2397
  int    OPVSLF99 2398-2401
  long   OPVMCR99 2402-2406
  long   OPVMCD99 2407-2411
  long   OPVPRV99 2412-2416
  long   OPVVA99 2417-2421
  int    OPVCHM99 2422-2425
  long   OPVOFD99 2426-2430
  int    OPVSTL99 2431-2434
  long   OPVWCP99 2435-2439
  int    OPVOPR99 2440-2443
  int    OPVOPU99 2444-2447
  int    OPVOSR99 2448-2451
  long   OPSEXP99 2452-2456
  long   OPSTCH99 2457-2461
  int    OPSSLF99 2462-2465
  int    OPSMCR99 2466-2469
  int    OPSMCD99 2470-2473
  long   OPSPRV99 2474-2478
  int    OPSVA99 2479-2482
  int    OPSCHM99 2483-2485
  byte   OPSOFD99 2486-2486
  byte   OPSSTL99 2487-2487
  int    OPSWCP99 2488-2491
  int    OPSOPR99 2492-2495
  int    OPSOPU99 2496-2498
  byte   OPSOSR99 2499-2499
  int    OPOTHV99 2500-2502
  long   OPOTCH99 2503-2507
  long   OPOEXP99 2508-2512
  int    OPOSLF99 2513-2516
  long   OPOMCR99 2517-2521
  long   OPOMCD99 2522-2526
  long   OPOPRV99 2527-2531
  long   OPOVA99 2532-2536
  int    OPOCHM99 2537-2540
  long   OPOOFD99 2541-2545
  int    OPOSTL99 2546-2549
  int    OPOWCP99 2550-2553
  int    OPOOPR99 2554-2557
  int    OPOOPU99 2558-2560
  int    OPOOSR99 2561-2564
  int    OPPEXP99 2565-2568
  long   OPPTCH99 2569-2573
  int    OPPSLF99 2574-2576
  int    OPPMCR99 2577-2580
  int    OPPMCD99 2581-2583
  int    OPPPRV99 2584-2587
  int    OPPVA99 2588-2590
  int    OPPCHM99 2591-2594
  byte   OPPOFD99 2595-2595
  byte   OPPSTL99 2596-2596
  int    OPPWCP99 2597-2600
  int    OPPOPR99 2601-2604
  int    OPPOPU99 2605-2607
  int    OPPOSR99 2608-2610
  byte   AMCHIR99 2611-2612
  int    AMCTCH99 2613-2616
  int    AMCEXP99 2617-2620
  int    AMCSLF99 2621-2624
  int    AMCMCR99 2625-2627
  int    AMCMCD99 2628-2630
  int    AMCPRV99 2631-2634
  int    AMCVA99 2635-2638
  byte   AMCCHM99 2639-2640
  byte   AMCOFD99 2641-2641
  int    AMCSTL99 2642-2645
  int    AMCWCP99 2646-2649
  int    AMCOPR99 2650-2653
  byte   AMCOPU99 2654-2655
  int    AMCOSR99 2656-2659
  int    AMNURS99 2660-2662
  long   AMNTCH99 2663-2668
  long   AMNEXP99 2669-2673
  int    AMNSLF99 2674-2677
  long   AMNMCR99 2678-2682
  long   AMNMCD99 2683-2687
  int    AMNPRV99 2688-2691
  long   AMNVA99 2692-2696
  int    AMNCHM99 2697-2700
  long   AMNOFD99 2701-2705
  long   AMNSTL99 2706-2710
  int    AMNWCP99 2711-2713
  int    AMNOPR99 2714-2717
  int    AMNOPU99 2718-2720
  int    AMNOSR99 2721-2723
  byte   AMOPTO99 2724-2725
  long   AMETCH99 2726-2730
  int    AMEEXP99 2731-2734
  int    AMESLF99 2735-2737
  int    AMEMCR99 2738-2741
  int    AMEMCD99 2742-2744
  int    AMEPRV99 2745-2748
  int    AMEVA99 2749-2751
  byte   AMECHM99 2752-2753
  byte   AMEOFD99 2754-2755
  byte   AMESTL99 2756-2757
  byte   AMEWCP99 2758-2758
  int    AMEOPR99 2759-2761
  byte   AMEOPU99 2762-2762
  int    AMEOSR99 2763-2765
  byte   AMASST99 2766-2767
  long   AMATCH99 2768-2773
  int    AMAEXP99 2774-2777
  int    AMASLF99 2778-2780
  int    AMAMCR99 2781-2783
  int    AMAMCD99 2784-2786
  int    AMAPRV99 2787-2790
  int    AMAVA99 2791-2793
  int    AMACHM99 2794-2796
  int    AMAOFD99 2797-2799
  int    AMASTL99 2800-2802
  int    AMAWCP99 2803-2805
  int    AMAOPR99 2806-2808
  byte   AMAOPU99 2809-2810
  int    AMAOSR99 2811-2813
  int    AMTHER99 2814-2816
  long   AMTTCH99 2817-2821
  long   AMTEXP99 2822-2826
  int    AMTSLF99 2827-2830
  int    AMTMCR99 2831-2834
  int    AMTMCD99 2835-2838
  long   AMTPRV99 2839-2843
  int    AMTVA99 2844-2847
  int    AMTCHM99 2848-2851
  int    AMTOFD99 2852-2855
  int    AMTSTL99 2856-2859
  int    AMTWCP99 2860-2863
  int    AMTOPR99 2864-2867
  int    AMTOPU99 2868-2870
  int    AMTOSR99 2871-2874
  byte   AMTOTC99 2875-2876
  byte   AMDRC99 2877-2878
  byte   ERTOT99 2879-2880
  long   ERFTCH99 2881-2885
  long   ERFEXP99 2886-2890
  int    ERFSLF99 2891-2894
  int    ERFMCR99 2895-2898
  int    ERFMCD99 2899-2902
  long   ERFPRV99 2903-2907
  int    ERFVA99 2908-2911
  int    ERFCHM99 2912-2914
  int    ERFOFD99 2915-2918
  int    ERFSTL99 2919-2922
  int    ERFWCP99 2923-2926
  int    ERFOPR99 2927-2929
  int    ERFOPU99 2930-2932
  int    ERFOSR99 2933-2936
  long   ERDEXP99 2937-2941
  long   ERDTCH99 2942-2946
  int    ERDSLF99 2947-2950
  int    ERDMCR99 2951-2954
  int    ERDMCD99 2955-2958
  long   ERDPRV99 2959-2963
  int    ERDVA99 2964-2967
  int    ERDCHM99 2968-2970
  byte   ERDOFD99 2971-2971
  int    ERDSTL99 2972-2974
  int    ERDWCP99 2975-2978
  int    ERDOPR99 2979-2982
  int    ERDOPU99 2983-2985
  int    ERDOSR99 2986-2988
  byte   IPZERO99 2989-2989
  long   ZIFTCH99 2990-2994
  long   ZIFEXP99 2995-2999
  int    ZIFSLF99 3000-3003
  int    ZIFMCR99 3004-3007
  int    ZIFMCD99 3008-3011
  int    ZIFPRV99 3012-3015
  byte   ZIFVA99 3016-3016
  byte   ZIFCHM99 3017-3017
  int    ZIFOFD99 3018-3020
  byte   ZIFSTL99 3021-3021
  long   ZIFWCP99 3022-3026
  int    ZIFOPR99 3027-3029
  byte   ZIFOPU99 3030-3030
  byte   ZIFOSR99 3031-3031
  int    ZIDEXP99 3032-3035
  long   ZIDTCH99 3036-3040
  int    ZIDSLF99 3041-3043
  int    ZIDMCR99 3044-3046
  int    ZIDMCD99 3047-3049
  int    ZIDPRV99 3050-3053
  byte   ZIDVA99 3054-3054
  int    ZIDCHM99 3055-3057
  byte   ZIDOFD99 3058-3058
  int    ZIDSTL99 3059-3061
  int    ZIDWCP99 3062-3065
  int    ZIDOPR99 3066-3068
  byte   ZIDOPU99 3069-3069
  byte   ZIDOSR99 3070-3070
  byte   IPDIS99 3071-3072
  long   IPFEXP99 3073-3078
  long   IPFTCH99 3079-3084
  long   IPFSLF99 3085-3089
  long   IPFMCR99 3090-3095
  long   IPFMCD99 3096-3101
  long   IPFPRV99 3102-3107
  long   IPFVA99 3108-3113
  int    IPFCHM99 3114-3117
  long   IPFOFD99 3118-3122
  int    IPFSTL99 3123-3126
  long   IPFWCP99 3127-3131
  long   IPFOPR99 3132-3136
  long   IPFOPU99 3137-3141
  long   IPFOSR99 3142-3146
  long   IPDEXP99 3147-3151
  long   IPDTCH99 3152-3157
  int    IPDSLF99 3158-3161
  long   IPDMCR99 3162-3166
  long   IPDMCD99 3167-3171
  long   IPDPRV99 3172-3176
  int    IPDVA99 3177-3180
  int    IPDCHM99 3181-3184
  byte   IPDOFD99 3185-3185
  int    IPDSTL99 3186-3189
  int    IPDWCP99 3190-3193
  long   IPDOPR99 3194-3198
  int    IPDOPU99 3199-3202
  int    IPDOSR99 3203-3205
  int    IPNGTD99 3206-3208
  byte   DVTOT99 3209-3210
  long   DVTTCH99 3211-3215
  long   DVTEXP99 3216-3220
  long   DVTSLF99 3221-3225
  int    DVTMCR99 3226-3229
  int    DVTMCD99 3230-3233
  long   DVTPRV99 3234-3238
  int    DVTVA99 3239-3242
  int    DVTCHM99 3243-3246
  int    DVTOFD99 3247-3250
  int    DVTSTL99 3251-3254
  int    DVTWCP99 3255-3258
  int    DVTOPR99 3259-3262
  int    DVTOPU99 3263-3265
  int    DVTOSR99 3266-3269
  byte   DVGEN99 3270-3271
  long   DVGTCH99 3272-3276
  long   DVGEXP99 3277-3281
  long   DVGSLF99 3282-3286
  int    DVGMCR99 3287-3290
  int    DVGMCD99 3291-3294
  long   DVGPRV99 3295-3299
  int    DVGVA99 3300-3303
  int    DVGCHM99 3304-3307
  int    DVGOFD99 3308-3311
  int    DVGSTL99 3312-3315
  int    DVGWCP99 3316-3319
  int    DVGOPR99 3320-3323
  int    DVGOPU99 3324-3326
  int    DVGOSR99 3327-3330
  byte   DVORTH99 3331-3332
  long   DVOTCH99 3333-3337
  long   DVOEXP99 3338-3342
  long   DVOSLF99 3343-3347
  int    DVOMCR99 3348-3350
  int    DVOMCD99 3351-3354
  long   DVOPRV99 3355-3359
  int    DVOVA99 3360-3362
  int    DVOCHM99 3363-3365
  int    DVOOFD99 3366-3368
  int    DVOSTL99 3369-3372
  byte   DVOWCP99 3373-3373
  int    DVOOPR99 3374-3377
  byte   DVOOPU99 3378-3378
  int    DVOOSR99 3379-3382
  int    HHTOTD99 3383-3385
  int    HHAGD99 3386-3388
  long   HHATCH99 3389-3394
  long   HHAEXP99 3395-3400
  int    HHASLF99 3401-3404
  long   HHAMCR99 3405-3409
  long   HHAMCD99 3410-3415
  long   HHAPRV99 3416-3420
  int    HHAVA99 3421-3423
  int    HHACHM99 3424-3426
  int    HHAOFD99 3427-3430
  long   HHASTL99 3431-3435
  byte   HHAWCP99 3436-3436
  int    HHAOPR99 3437-3440
  int    HHAOPU99 3441-3444
  int    HHAOSR99 3445-3448
  int    HHINDD99 3449-3451
  long   HHNTCH99 3452-3456
  long   HHNEXP99 3457-3461
  long   HHNSLF99 3462-3466
  int    HHNMCR99 3467-3470
  long   HHNMCD99 3471-3475
  int    HHNPRV99 3476-3479
  int    HHNVA99 3480-3483
  byte   HHNCHM99 3484-3484
  byte   HHNOFD99 3485-3485
  int    HHNSTL99 3486-3489
  byte   HHNWCP99 3490-3490
  byte   HHNOPR99 3491-3492
  byte   HHNOPU99 3493-3494
  int    HHNOSR99 3495-3497
  int    HHINFD99 3498-3500
  int    VISEXP99 3501-3504
  int    VISTCH99 3505-3508
  int    VISSLF99 3509-3512
  int    VISMCR99 3513-3515
  int    VISMCD99 3516-3518
  int    VISPRV99 3519-3521
  int    VISVA99 3522-3524
  int    VISCHM99 3525-3527
  int    VISOFD99 3528-3530
  int    VISSTL99 3531-3533
  int    VISWCP99 3534-3536
  int    VISOPR99 3537-3539
  int    VISOPU99 3540-3542
  int    VISOSR99 3543-3545
  long   OTHTCH99 3546-3550
  long   OTHEXP99 3551-3555
  long   OTHSLF99 3556-3560
  long   OTHMCR99 3561-3565
  long   OTHMCD99 3566-3570
  long   OTHPRV99 3571-3575
  int    OTHVA99 3576-3579
  int    OTHCHM99 3580-3582
  int    OTHOFD99 3583-3585
  byte   OTHSTL99 3586-3586
  int    OTHWCP99 3587-3590
  int    OTHOPR99 3591-3594
  byte   OTHOPU99 3595-3596
  int    OTHOSR99 3597-3599
  int    RXTOT99 3600-3602
  long   RXEXP99 3603-3607
  long   RXSLF99 3608-3612
  int    RXMCR99 3613-3616
  long   RXMCD99 3617-3621
  long   RXPRV99 3622-3626
  int    RXVA99 3627-3630
  int    RXCHM99 3631-3634
  int    RXOFD99 3635-3637
  int    RXSTL99 3638-3641
  int    RXWCP99 3642-3645
  int    RXOPR99 3646-3649
  int    RXOPU99 3650-3653
  int    RXOSR99 3654-3656
  double PERWT99F 3657-3668
  double FAMWT99F 3669-3680
  double FAMWT99C 3681-3692
  int    VARSTR99 3693-3695
  byte   VARPSU99 3696-3697
using H38.dat;

*DEFINE VARIABLE LABELS;
label variable DUID "DWELLING UNIT ID";
label variable PID "PERSON NUMBER";
label variable DUPERSID "PERSON ID (DUID + PID)";
label variable PANEL99 "PANEL NUMBER";
label variable FAMID31 "FAMILY ID (STUDENT MERGED IN) - R3/1";
label variable FAMID42 "FAMILY ID (STUDENT MERGED IN) - R4/2";
label variable FAMID53 "FAMILY ID (STUDENT MERGED IN) - R5/3";
label variable FAMID99 "FAMILY ID (STUDENT MERGED IN)-12/31/99";
label variable FAMIDYR "ANNUAL FAMILY IDENTIFIER";
label variable CPSFAMID "CPS-LIKE FAMILY IDENTIFIER";
label variable HIEUIDX "HIEU IDENTIFIER";
label variable FCSZ1231 "FAM SIZ RESPONDING 12/31 CPS FAMILY-99";
label variable FCRP1231 "REF PERSON OF 12/31 CPS FAMILY-99";
label variable RULETR31 "RU LETTER - R3/1";
label variable RULETR42 "RU LETTER - R4/2";
label variable RULETR53 "RU LETTER - R5/3";
label variable RULETR99 "RU LETTER AS OF 12/31/99";
label variable RUSIZE31 "RU SIZE - R3/1";
label variable RUSIZE42 "RU SIZE - R4/2";
label variable RUSIZE53 "RU SIZE - R5/3";
label variable RUSIZE99 "RU SIZE AS OF 12/31/99";
label variable RUCLAS31 "RU FIELDED AS:STANDARD/NEW/STUDENT-R3/1";
label variable RUCLAS42 "RU FIELDED AS:STANDARD/NEW/STUDENT-R4/2";
label variable RUCLAS53 "RU FIELDED AS:STANDARD/NEW/STUDENT-R5/3";
label variable RUCLAS99 "RU FIELDED AS:STANDARD/NEW/STUD-12/31/99";
label variable FAMSZE31 "RU SIZE INCLUDING STUDENTS - R3/1";
label variable FAMSZE42 "RU SIZE INCLUDING STUDENTS - R4/2";
label variable FAMSZE53 "RU SIZE INCLUDING STUDENTS - R5/3";
label variable FAMSZE99 "RU SIZE INCLUDING STUDENT AS OF 12/31/99";
label variable FMRS1231 "MEMBER OF RESPONDING 12/31 FAMILY";
label variable FAMS1231 "FAMILY SIZE OF RESPONDING 12/31 FAMILY";
label variable FAMSZEYR "SIZE OF RESPONDING ANNUALIZED FAMILY";
label variable FAMRFPYR "REFERENCE PERSON OF ANNUALIZED FAMILY";
label variable FYFAMTYP "CPS - FULL YEAR FAMILY TYPE";
label variable INRU1231 "PERSON WAS IN RU ON 12/31/99";
label variable REGION31 "CENSUS REGION - R3/1";
label variable REGION42 "CENSUS REGION - R4/2";
label variable REGION53 "CENSUS REGION - R5/3";
label variable REGION99 "CENSUS REGION AS OF 12/31/99";
label variable MSA53 "MSA STATUS-R5/3";
label variable MSA99 "MSA STATUS AS OF 12/31/99";
label variable REFPRS31 "REFERENCE PERSON AT - R3/1";
label variable REFPRS42 "REFERENCE PERSON AT - R4/2";
label variable REFPRS53 "REFERENCE PERSON AT - R5/3";
label variable REFPRS99 "REFERENCE PERSON AS OF 12/31/99";
label variable RESP31 "1ST RESPONDENT INDICATOR FOR R3/1";
label variable RESP42 "1ST RESPONDENT INDICATOR FOR R4/2";
label variable RESP53 "1ST RESPONDENT INDICATOR FOR R5/3";
label variable RESP99 "1ST RESPONDENT INDICATOR AS OF 12/31/99";
label variable PROXY31 "WAS RESPONDENT A PROXY IN R3/1";
label variable PROXY42 "WAS RESPONDENT A PROXY IN R4/2";
label variable PROXY53 "WAS RESPONDENT A PROXY IN R5/3";
label variable PROXY99 "WAS RESPONDENT A PROXY AS OF 12/31/99";
label variable INTVLANG "LANGUAGE INTERVIEW WAS COMPLETED";
label variable BEGRFD31 "R3/1 REFERENCE PERIOD BEGIN DATE: DAY";
label variable BEGRFM31 "R3/1 REFERENCE PERIOD BEGIN DATE: MONTH";
label variable BEGRFY31 "R3/1 REFERENCE PERIOD BEGIN DATE: YEAR";
label variable ENDRFD31 "R3/1 REFERENCE PERIOD END DATE: DAY";
label variable ENDRFM31 "R3/1 REFERENCE PERIOD END DATE: MONTH";
label variable ENDRFY31 "R3/1 REFERENCE PERIOD END DATE: YEAR";
label variable BEGRFD42 "R4/2 REFERENCE PERIOD BEGIN DATE: DAY";
label variable BEGRFM42 "R4/2 REFERENCE PERIOD BEGIN DATE: MONTH";
label variable BEGRFY42 "R4/2 REFERENCE PERIOD BEGIN DATE: YEAR";
label variable ENDRFD42 "R4/2 REFERENCE PERIOD END DATE: DAY";
label variable ENDRFM42 "R4/2 REFERENCE PERIOD END DATE: MONTH";
label variable ENDRFY42 "R4/2 REFERENCE PERIOD END DATE: YEAR";
label variable BEGRFD53 "R5/3 REFERENCE PERIOD BEGIN DATE: DAY";
label variable BEGRFM53 "R5/3 REFERENCE PERIOD BEGIN DATE: MONTH";
label variable BEGRFY53 "R5/3 REFERENCE PERIOD BEGIN DATE: YEAR";
label variable ENDRFD53 "R5/3 REFERENCE PERIOD END DATE: DAY";
label variable ENDRFM53 "R5/3 REFERENCE PERIOD END DATE: MONTH";
label variable ENDRFY53 "R5/3 REFERENCE PERIOD END DATE: YEAR";
label variable ENDRFD99 "1999 REFERENCE PERIOD END DATE: DAY";
label variable ENDRFM99 "1999 REFERENCE PERIOD END DATE: MONTH";
label variable ENDRFY99 "1999 REFERENCE PERIOD END DATE: YEAR";
label variable KEYNESS "PERSON KEY STATUS";
label variable INSCOP31 "INSCOPE - R3/1";
label variable INSCOP42 "INSCOPE - R4/2";
label variable INSCOP53 "INSCOPE - R5/3";
label variable INSCOP99 "INSCOPE - R5/3 START THROUGH 12/31/99";
label variable INSC1231 "INSCOPE STATUS ON 12/31/99";
label variable INSCOPE "WAS PERSON EVER INSCOPE IN 1999";
label variable ELGRND31 "ELIGIBILITY - R3/1";
label variable ELGRND42 "ELIGIBILITY - R4/2";
label variable ELGRND53 "ELIGIBILITY - R5/3";
label variable ELGRND99 "ELIGIBILITY STATUS AS OF 12/31/99";
label variable ELIGIBLE "WAS PERSON EVER ELIGIBLE IN 1999";
label variable PSTATS31 "PERSON DISPOSITION STATUS - R3/1";
label variable PSTATS42 "PERSON DISPOSITION STATUS - R4/2";
label variable PSTATS53 "PERSON DISPOSITION STATUS - R5/3";
label variable RURSLT31 "RU RESULT - R3/1";
label variable RURSLT42 "RU RESULT - R4/2";
label variable RURSLT53 "RU RESULT - R5/3";
label variable R2FLAG "FLAG:PERSON IS IN P3R2 RU W/INTV IN 1999";
label variable AGE31X "AGE - R3/1 (EDITED/IMPUTED)";
label variable AGE42X "AGE - R4/2 (EDITED/IMPUTED)";
label variable AGE53X "AGE - R5/3 (EDITED/IMPUTED)";
label variable AGE99X "AGE AS OF 12/31/99 (EDITED/IMPUTED)";
label variable DOBMM "DATE OF BIRTH: MONTH";
label variable DOBYY "DATE OF BIRTH: YEAR";
label variable SEX "SEX";
label variable RACEX "RACE (EDITED/IMPUTED)";
label variable RACETHNX "RACE/ETHNICITY (EDITED/IMPUTED)";
label variable HISPANX "HISPANIC ETHNICITY (EDITED/IMPUTED)";
label variable HISPCAT "SPECIFIC HISPANIC ETHNICITY GROUP";
label variable MARRY31X "MARITAL STATUS - R3/1 (EDITED/IMPUTED)";
label variable MARRY42X "MARITAL STATUS - R4/2 (EDITED/IMPUTED)";
label variable MARRY53X "MARITAL STATUS - R5/3 (EDITED/IMPUTED)";
label variable MARRY99X "MARITAL STATUS-12/31/99 (EDITED/IMPUTED)";
label variable SPOUID31 "SPOUSE ID - R3/1";
label variable SPOUID42 "SPOUSE ID - R4/2";
label variable SPOUID53 "SPOUSE ID - R5/3";
label variable SPOUID99 "SPOUSE ID - 12/31/99";
label variable SPOUIN31 "MARITAL STATUS W/SPOUSE PRESENT R3/1";
label variable SPOUIN42 "MARITAL STATUS W/SPOUSE PRESENT R4/2";
label variable SPOUIN53 "MARITAL STATUS W/SPOUSE PRESENT R5/3";
label variable SPOUIN99 "MARITAL STATUS W/SPOUSE PRESENT-12/31/99";
label variable EDUCYEAR "COMPLETED YEARS OF EDUCATION";
label variable HIDEGYR "HIGHEST DEGREE EARNED";
label variable FTSTU31X "STUDENT STATUS IF AGES 17-23 R3/1";
label variable FTSTU42X "STUDENT STATUS IF AGES 17-23 R4/2";
label variable FTSTU53X "STUDENT STATUS IF AGES 17-23 R5/3";
label variable FTSTU99X "STUDENT STATUS IF AGES 17-23 - 12/31/99";
label variable ACTDTY31 "MILITARY FULL-TIME ACTIVE DUTY - R3/1";
label variable ACTDTY42 "MILITARY FULL-TIME ACTIVE DUTY - R4/2";
label variable ACTDTY53 "MILITARY FULL-TIME ACTIVE DUTY - R5/3";
label variable DIDSERVE "EVER SERVED IN ARMED FORCES";
label variable VETPVIET "SERVED IN POST-VIETNAM ERA";
label variable VETVIET "SERVED IN VIETNAM WAR ERA";
label variable VETKOR "SERVED IN KOREAN WAR ERA";
label variable VETWW "SERVED IN WWI OR WW2 ERA";
label variable VETOTH "SERVED IN OTHER PERIOD";
label variable RFREL31X "RELATION TO REF PERS R3/1 (EDIT/IMP)";
label variable RFREL42X "RELATION TO REF PERS R4/2 (EDIT/IMP)";
label variable RFREL53X "RELATION TO REF PERS R5/3 (EDIT/IMP)";
label variable RFREL99X "RELATION TO REF PERS 12/31/99 (EDIT/IMP)";
label variable MOPID31X "PID OF PERSON S MOM - RD 3/1";
label variable MOPID42X "PID OF PERSON S MOM - RD 4/2";
label variable MOPID53X "PID OF PERSON S MOM - RD 5/3";
label variable DAPID31X "PID OF PERSON S DAD - RD 3/1";
label variable DAPID42X "PID OF PERSON S DAD - RD 4/2";
label variable DAPID53X "PID OF PERSON S DAD - RD 5/3";
label variable SSIDIS99 "SSI RECEIPT DUE TO DISABILITY";
label variable AFDC99 "DID PERSON S CHECK INCLUDE TANF";
label variable FILEDR99 "HAS PERSON FILED A FED INCOME TAX RETURN";
label variable WILFIL99 "WILL PERSON FILE FED INCOME TAX RETURN";
label variable FLSTAT99 "PERSON S FILING STATUS";
label variable FILER99 "PRIMARY OR SECONDARY FILER";
label variable JTINRU99 "JOINT FILER S MEMBERSHIP IN RU";
label variable JNTPID99 "PID OF SECONDARY FILER";
label variable CLMDEP99 "DID/WILL PERS CLAIM DEPENDENTS ON RETURN";
label variable DEPDNT99 "PERSON IS FLAGGED A DEPENDENT";
label variable DPINRU99 "DEPENDENTS IN/OUT OF RU";
label variable DPOTSD99 "HOW MANY DEPENDENTS LIVE OUTSIDE RU";
label variable TAXFRM99 "TAX FORM PERSON WILL FILE";
label variable DEDUCT99 "ITEMIZE OR STANDARD DEDUCTION";
label variable ITMEXP99 "WILL PERSON ITEMIZE MEDICAL EXPENSE";
label variable MEXAMT99 "TOTAL AMOUNT FOR MEDICAL EXPENSES";
label variable NTMDED99 "PERSON S NET MEDICAL EXPENSE DEDUCTION";
label variable TOTDED99 "TOTAL OF ALL ITEMIZED DEDUCTIONS";
label variable CLMHIP99 "DID/WILL PERS DEDUCT HEALTH INSUR. PREM.";
label variable ELDISC99 "DID/WILL PERS RECEIVE ELDERLY/DISAB CRED";
label variable EICRDT99 "DID/WILL PERS RECEIVE EARNED INC CREDIT";
label variable UNEMTX99 "TAXABLE PERCENTAGE OF UNEMPLOYMENT";
label variable INTRTX99 "TAXABLE PERCENTAGE OF INTEREST";
label variable SSECTX99 "TAXABLE PERCENTAGE OF SOCIAL SECURITY";
label variable IRATAX99 "TAXABLE PERCENTAGE OF IRA INCOME";
label variable FOODST99 "DID ANYONE PURCHASE FOOD STAMPS";
label variable FOODMN99 "NUMBER OF MONTHS FOOD STAMPS PURCHASED";
label variable FOODCT99 "MONTHLY AMT FAMILY PAID FOR FOOD STAMPS";
label variable FOODVL99 "MONTHLY VALUE OF FOOD STAMPS";
label variable TTLP99X "PERSON S TOTAL INCOME";
label variable POVCAT99 "FAMILY INCOME AS PERCENT OF POVERTY LINE";
label variable WAGEP99X "PERSON S WAGE INCOME";
label variable WAGIMP99 "WAGE IMPUTATION FLAG";
label variable BUSNP99X "PERSON S BUSINESS INCOME";
label variable BUSIMP99 "BUSINESS INCOME IMPUTATION FLAG";
label variable FARMP99X "PERSON S FARM INCOME";
label variable FARIMP99 "FARM INCOME IMPUTATION FLAG";
label variable UNEMP99X "PERSON S UNEMPLOYMENT COMP INCOME";
label variable UNEIMP99 "UNEMPLOYMENT IMPUTATION FLAG";
label variable WCMPP99X "PERSON S WORKERS  COMPENSATION";
label variable WCPIMP99 "WORKER S COMP IMPUTATION FLAG";
label variable INTRP99X "PERSON S INTEREST INCOME";
label variable INTIMP99 "INTEREST INCOME IMPUTATION FLAG";
label variable DIVDP99X "PERSON S DIVIDEND INCOME";
label variable DIVIMP99 "DIVIDEND INCOME IMPUTATION FLAG";
label variable SALEP99X "PERSON S SALES INCOME";
label variable SALIMP99 "SALES INCOME IMPUTATION FLAG";
label variable PENSP99X "PERSON S PENSION INCOME";
label variable PENIMP99 "PENSION INCOME IMPUTATION FLAG";
label variable SSECP99X "PERSON S SOCIAL SECURITY INCOME";
label variable SSCIMP99 "SOCIAL SECURITY INCOME IMPUTATION FLAG";
label variable TRSTP99X "PERSON S TRUST/RENT INCOME";
label variable TRTIMP99 "TRUST INCOME IMPUTATION FLAG";
label variable VETSP99X "PERSON S VETERAN S INCOME";
label variable VETIMP99 "VETERAN S INCOME IMPUTATION FLAG";
label variable IRASP99X "PERSON S IRA INCOME";
label variable IRAIMP99 "IRA INCOME IMPUTATION FLAG";
label variable REFDP99X "PERSON S REFUND INCOME";
label variable REFIMP99 "REFUND INCOME IMPUTATION FLAG";
label variable ALIMP99X "PERSON S ALIMONY INCOME";
label variable ALIIMP99 "ALIMONY INCOME IMPUTATION FLAG";
label variable CHLDP99X "PERSON S CHILD SUPPORT";
label variable CHLIMP99 "CHILD SUPPORT IMPUTATION FLAG";
label variable CASHP99X "PERSON S OTHER REGULAR CASH CONTRIBUTION";
label variable CSHIMP99 "CASH CONTRIBUTION IMPUTATION FLAG";
label variable SSIP99X "PERSON S SSI";
label variable SSIIMP99 "SSI IMPUTATION FLAG";
label variable PUBP99X "PERSON S PUBLIC ASSISTANCE";
label variable PUBIMP99 "PUBLIC ASSISTANCE IMPUTATION FLAG";
label variable OTHRP99X "PERSON S OTHER INCOME";
label variable OTHIMP99 "OTHER INCOME IMPUTAION FLAG";
label variable EMPST31 "EMPLOYMENT STATUS RD 3/1";
label variable EMPST42 "EMPLOYMENT STATUS RD 4/2";
label variable EMPST53 "EMPLOYMENT STATUS RD 5/3";
label variable RNDFLG31 "DATA COLLECTION ROUND FOR RD 3/1 CMJ";
label variable MORJOB31 "HAS MORE THAN ONE JOB RD 3/1 INT DATE";
label variable MORJOB42 "HAS MORE THAN ONE JOB RD 4/2 INT DATE";
label variable MORJOB53 "HAS MORE THAN ONE JOB RD 5/3 INT DATE";
label variable EVRWRK "EVER WRKD FOR PAY IN LIFE AS OF 12/31/99";
label variable HRWG31X "HOURLY WAGE RD 3/1 CMJ";
label variable HRWG42X "HOURLY WAGE RD 4/2 CMJ";
label variable HRWG53X "HOURLY WAGE RD 5/3 CMJ";
label variable HRWGIM31 "HRWG31X IMPUTATION FLAG";
label variable HRWGIM42 "HRWG42X IMPUTATION FLAG";
label variable HRWGIM53 "HRWG53X IMPUTATION FLAG";
label variable HRHOW31 "HOW HOURLY WAGE WAS CALCULATED RD 3/1";
label variable HRHOW42 "HOW HOURLY WAGE WAS CALCULATED RD 4/2";
label variable HRHOW53 "HOW HOURLY WAGE WAS CALCULATED RD 5/3";
label variable HOUR31 "HOURS PER WEEK AT RD 3/1 CMJ";
label variable HOUR42 "HOURS PER WEEK AT RD 4/2 CMJ";
label variable HOUR53 "HOURS PER WEEK AT RD 5/3 CMJ";
label variable SELFCM31 "SELF-EMPLOYED AT RD 3/1 CMJ";
label variable SELFCM42 "SELF-EMPLOYED AT RD 4/2 CMJ";
label variable SELFCM53 "SELF-EMPLOYED AT RD 5/3 CMJ";
label variable DISVW31X "DISAVOWED HEALTH INS AT RD 3/1 CMJ";
label variable DISVW42X "DISAVOWED HEALTH INS AT RD 4/2 CMJ";
label variable DISVW53X "DISAVOWED HEALTH INS AT RD 5/3 CMJ";
label variable CHOIC31 "CHOICE OF HEALTH PLANS AT RD 3/1 CMJ";
label variable CHOIC42 "CHOICE OF HEALTH PLANS AT RD 4/2 CMJ";
label variable CHOIC53 "CHOICE OF HEALTH PLANS AT RD 5/3 CMJ";
label variable CIND31 "CONDENSED INDUSTRY CODE RD 3/1 CMJ";
label variable CIND42 "CONDENSED INDUSTRY CODE RD 4/2 CMJ";
label variable CIND53 "CONDENSED INDUSTRY CODE RD 5/3 CMJ";
label variable NUMEMP31 "NUMBER OF EMPLOYEES AT RD 3/1 CMJ";
label variable NUMEMP42 "NUMBER OF EMPLOYEES AT RD 4/2 CMJ";
label variable NUMEMP53 "NUMBER OF EMPLOYEES AT RD 5/3 CMJ";
label variable MORE31 "RD 3/1 CMJ FIRM HAS MORE THAN 1 LOCAT";
label variable MORE42 "RD 4/2 CMJ FIRM HAS MORE THAN 1 LOCAT";
label variable MORE53 "RD 5/3 CMJ FIRM HAS MORE THAN 1 LOCAT";
label variable UNION31 "UNION STATUS AT RD 3/1 CMJ";
label variable UNION42 "UNION STATUS AT RD 4/2 CMJ";
label variable UNION53 "UNION STATUS AT RD 5/3 CMJ";
label variable NWK31 "REASON NOT WORKING DURING RD 3/1";
label variable NWK42 "REASON NOT WORKING DURING RD 4/2";
label variable NWK53 "REASON NOT WORKING DURING RD 5/3";
label variable CHGJ3142 "CHANGED JOB BETWEEN RD 3/1 AND RD 4/2";
label variable CHGJ4253 "CHANGED JOB BETWEEN RD 4/2 AND RD 5/3";
label variable YCHJ3142 "WHY CHNGD JOB BETWEEN RD 3/1 AND RD 4/2";
label variable YCHJ4253 "WHY CHNGD JOB BETWEEN RD 4/2 AND RD 5/3";
label variable STJBMM31 "MONTH STARTED RD 3/1 CMJ";
label variable STJBDD31 "DAY STARTED RD 3/1 CMJ";
label variable STJBYY31 "YEAR STARTED RD 3/1 CMJ";
label variable STJBMM42 "MONTH STARTED RD 4/2 CMJ";
label variable STJBDD42 "DAY STARTED RD 4/2 CMJ";
label variable STJBYY42 "YEAR STARTED RD 4/2 CMJ";
label variable STJBMM53 "MONTH STARTED RD 5/3 CMJ";
label variable STJBDD53 "DAY STARTED RD 5/3 CMJ";
label variable STJBYY53 "YEAR STARTED RD 5/3 CMJ";
label variable EVRETIRE "PERSON HAS EVER RETIRED";
label variable COCCP31 "CONDENSED OCCUPATION CODE RD 3/1 CMJ";
label variable COCCP42 "CONDENSED OCCUPATION CODE RD 4/2 CMJ";
label variable COCCP53 "CONDENSED OCCUPATION CODE RD 5/3 CMJ";
label variable BGNWK31 "USUAL START TIME OF RD 3/1 CMJ";
label variable BGNWK42 "USUAL START TIME OF RD 4/2 CMJ";
label variable BGNWK53 "USUAL START TIME OF RD 5/3 CMJ";
label variable ENDWK31 "USUAL END TIME OF RD 3/1 CMJ";
label variable ENDWK42 "USUAL END TIME OF RD 4/2 CMJ";
label variable ENDWK53 "USUAL END TIME OF RD 5/3 CMJ";
label variable PAYVAC31 "PAID VACATION AT RD 3/1 CMJ";
label variable PAYVAC42 "PAID VACATION AT RD 4/2 CMJ";
label variable PAYVAC53 "PAID VACATION AT RD 5/3 CMJ";
label variable SICPAY31 "PAID SICK LEAVE AT RD 3/1 CMJ";
label variable SICPAY42 "PAID SICK LEAVE AT RD 4/2 CMJ";
label variable SICPAY53 "PAID SICK LEAVE AT RD 5/3 CMJ";
label variable PAYDR31 "PAID LEAVE TO VISIT DR RD 3/1 CMJ";
label variable PAYDR42 "PAID LEAVE TO VISIT DR RD 4/2 CMJ";
label variable PAYDR53 "PAID LEAVE TO VISIT DR RD 5/3 CMJ";
label variable RETPLN31 "PENSION PLAN AT RD 3/1 CMJ";
label variable RETPLN42 "PENSION PLAN AT RD 4/2 CMJ";
label variable RETPLN53 "PENSION PLAN AT RD 5/3 CMJ";
label variable SHFTWK31 "IRREGULAR WORK SHIFT RD 3/1 CMJ";
label variable SHFTWK42 "IRREGULAR WORK SHIFT RD 4/2 CMJ";
label variable SHFTWK53 "IRREGULAR WORK SHIFT RD 5/3 CMJ";
label variable BSNTY31 "SOLE PROP, PARTNER, CORP, RD 3/1 CMJ";
label variable BSNTY42 "SOLE PROP, PARTNER, CORP, RD 4/2 CMJ";
label variable BSNTY53 "SOLE PROP, PARTNER, CORP, RD 5/3 CMJ";
label variable JOBORG31 "PRIV (PROFIT,NONPROFIT) GOV RD 3/1 CMJ";
label variable JOBORG42 "PRIV (PROFIT,NONPROFIT) GOV RD 4/2 CMJ";
label variable JOBORG53 "PRIV (PROFIT,NONPROFIT) GOV RD 5/3 CMJ";
label variable HELD31X "HEALTH INSURANCE HELD FROM RD 3/1 CMJ";
label variable HELD42X "HEALTH INSURANCE HELD FROM RD 4/2 CMJ";
label variable HELD53X "HEALTH INSURANCE HELD FROM RD 5/3 CMJ";
label variable OFFER31X "HEALTH INSURANCE OFFERED BY RD 3/1 CMJ";
label variable OFFER42X "HEALTH INSURANCE OFFERED BY RD 4/2 CMJ";
label variable OFFER53X "HEALTH INSURANCE OFFERED BY RD 5/3 CMJ";
label variable CHJA99X "COV BY CHAMPUS/CHMPVA/TRICARE JAN99 (ED)";
label variable CHFE99X "COV BY CHAMPUS/CHMPVA/TRICARE FEB99 (ED)";
label variable CHMA99X "COV BY CHAMPUS/CHMPVA/TRICARE MAR99 (ED)";
label variable CHAP99X "COV BY CHAMPUS/CHMPVA/TRICARE APR99 (ED)";
label variable CHMY99X "COV BY CHAMPUS/CHMPVA/TRICARE MAY99 (ED)";
label variable CHJU99X "COV BY CHAMPUS/CHMPVA/TRICARE JUN99 (ED)";
label variable CHJL99X "COV BY CHAMPUS/CHMPVA/TRICARE JUL99 (ED)";
label variable CHAU99X "COV BY CHAMPUS/CHMPVA/TRICARE AUG99 (ED)";
label variable CHSE99X "COV BY CHAMPUS/CHMPVA/TRICARE SEP99 (ED)";
label variable CHOC99X "COV BY CHAMPUS/CHMPVA/TRICARE OCT99 (ED)";
label variable CHNO99X "COV BY CHAMPUS/CHMPVA/TRICARE NOV99 (ED)";
label variable CHDE99X "COV BY CHAMPUS/CHMPVA/TRICARE DEC99 (ED)";
label variable MCRJA99 "COVERED BY MEDICARE IN JAN99";
label variable MCRFE99 "COVERED BY MEDICARE IN FEB99";
label variable MCRMA99 "COVERED BY MEDICARE IN MAR99";
label variable MCRAP99 "COVERED BY MEDICARE IN APR99";
label variable MCRMY99 "COVERED BY MEDICARE IN MAY99";
label variable MCRJU99 "COVERED BY MEDICARE IN JUN99";
label variable MCRJL99 "COVERED BY MEDICARE IN JUL99";
label variable MCRAU99 "COVERED BY MEDICARE IN AUG99";
label variable MCRSE99 "COVERED BY MEDICARE IN SEP99";
label variable MCROC99 "COVERED BY MEDICARE IN OCT99";
label variable MCRNO99 "COVERED BY MEDICARE IN NOV99";
label variable MCRDE99 "COVERED BY MEDICARE IN DEC99";
label variable MCRJA99X "COVERED BY MEDICARE IN JAN99 (ED)";
label variable MCRFE99X "COVERED BY MEDICARE IN FEB99 (ED)";
label variable MCRMA99X "COVERED BY MEDICARE IN MAR99 (ED)";
label variable MCRAP99X "COVERED BY MEDICARE IN APR99 (ED)";
label variable MCRMY99X "COVERED BY MEDICARE IN MAY99 (ED)";
label variable MCRJU99X "COVERED BY MEDICARE IN JUN99 (ED)";
label variable MCRJL99X "COVERED BY MEDICARE IN JUL99 (ED)";
label variable MCRAU99X "COVERED BY MEDICARE IN AUG99 (ED)";
label variable MCRSE99X "COVERED BY MEDICARE IN SEP99 (ED)";
label variable MCROC99X "COVERED BY MEDICARE IN OCT99 (ED)";
label variable MCRNO99X "COVERED BY MEDICARE IN NOV99 (ED)";
label variable MCRDE99X "COVERED BY MEDICARE IN DEC99 (ED)";
label variable MCDJA99 "COVERED BY MEDICAID IN JAN99";
label variable MCDFE99 "COVERED BY MEDICAID IN FEB99";
label variable MCDMA99 "COVERED BY MEDICAID IN MAR99";
label variable MCDAP99 "COVERED BY MEDICAID IN APR99";
label variable MCDMY99 "COVERED BY MEDICAID IN MAY99";
label variable MCDJU99 "COVERED BY MEDICAID IN JUN99";
label variable MCDJL99 "COVERED BY MEDICAID IN JUL99";
label variable MCDAU99 "COVERED BY MEDICAID IN AUG99";
label variable MCDSE99 "COVERED BY MEDICAID IN SEP99";
label variable MCDOC99 "COVERED BY MEDICAID IN OCT99";
label variable MCDNO99 "COVERED BY MEDICAID IN NOV99";
label variable MCDDE99 "COVERED BY MEDICAID IN DEC99";
label variable MCDJA99X "COVERED BY MEDICAID IN JAN99 (ED)";
label variable MCDFE99X "COVERED BY MEDICAID IN FEB99 (ED)";
label variable MCDMA99X "COVERED BY MEDICAID IN MAR99 (ED)";
label variable MCDAP99X "COVERED BY MEDICAID IN APR99 (ED)";
label variable MCDMY99X "COVERED BY MEDICAID IN MAY99 (ED)";
label variable MCDJU99X "COVERED BY MEDICAID IN JUN99 (ED)";
label variable MCDJL99X "COVERED BY MEDICAID IN JUL99 (ED)";
label variable MCDAU99X "COVERED BY MEDICAID IN AUG99 (ED)";
label variable MCDSE99X "COVERED BY MEDICAID IN SEP99 (ED)";
label variable MCDOC99X "COVERED BY MEDICAID IN OCT99 (ED)";
label variable MCDNO99X "COVERED BY MEDICAID IN NOV99 (ED)";
label variable MCDDE99X "COVERED BY MEDICAID IN DEC99 (ED)";
label variable OPAJA99 "COV BY OTHER PUBLIC A INS IN JAN99";
label variable OPAFE99 "COV BY OTHER PUBLIC A INS IN FEB99";
label variable OPAMA99 "COV BY OTHER PUBLIC A INS IN MAR99";
label variable OPAAP99 "COV BY OTHER PUBLIC A INS IN APR99";
label variable OPAMY99 "COV BY OTHER PUBLIC A INS IN MAY99";
label variable OPAJU99 "COV BY OTHER PUBLIC A INS IN JUN99";
label variable OPAJL99 "COV BY OTHER PUBLIC A INS IN JUL99";
label variable OPAAU99 "COV BY OTHER PUBLIC A INS IN AUG99";
label variable OPASE99 "COV BY OTHER PUBLIC A INS IN SEP99";
label variable OPAOC99 "COV BY OTHER PUBLIC A INS IN OCT99";
label variable OPANO99 "COV BY OTHER PUBLIC A INS IN NOV99";
label variable OPADE99 "COV BY OTHER PUBLIC A INS IN DEC99";
label variable OPBJA99 "COV BY OTHER PUBLIC B INS IN JAN99";
label variable OPBFE99 "COV BY OTHER PUBLIC B INS IN FEB99";
label variable OPBMA99 "COV BY OTHER PUBLIC B INS IN MAR99";
label variable OPBAP99 "COV BY OTHER PUBLIC B INS IN APR99";
label variable OPBMY99 "COV BY OTHER PUBLIC B INS IN MAY99";
label variable OPBJU99 "COV BY OTHER PUBLIC B INS IN JUN99";
label variable OPBJL99 "COV BY OTHER PUBLIC B INS IN JUL99";
label variable OPBAU99 "COV BY OTHER PUBLIC B INS IN AUG99";
label variable OPBSE99 "COV BY OTHER PUBLIC B INS IN SEP99";
label variable OPBOC99 "COV BY OTHER PUBLIC B INS IN OCT99";
label variable OPBNO99 "COV BY OTHER PUBLIC B INS IN NOV99";
label variable OPBDE99 "COV BY OTHER PUBLIC B INS IN DEC99";
label variable STAJA99 "COVERED BY OTHER STATE PROG IN JAN99";
label variable STAFE99 "COVERED BY OTHER STATE PROG IN FEB99";
label variable STAMA99 "COVERED BY OTHER STATE PROG IN MAR99";
label variable STAAP99 "COVERED BY OTHER STATE PROG IN APR99";
label variable STAMY99 "COVERED BY OTHER STATE PROG IN MAY99";
label variable STAJU99 "COVERED BY OTHER STATE PROG IN JUN99";
label variable STAJL99 "COVERED BY OTHER STATE PROG IN JUL99";
label variable STAAU99 "COVERED BY OTHER STATE PROG IN AUG99";
label variable STASE99 "COVERED BY OTHER STATE PROG IN SEP99";
label variable STAOC99 "COVERED BY OTHER STATE PROG IN OCT99";
label variable STANO99 "COVERED BY OTHER STATE PROG IN NOV99";
label variable STADE99 "COVERED BY OTHER STATE PROG IN DEC99";
label variable PUBJA99X "COVR BY ANY PUBLIC INS IN JAN99 (ED)";
label variable PUBFE99X "COVR BY ANY PUBLIC INS IN FEB99 (ED)";
label variable PUBMA99X "COVR BY ANY PUBLIC INS IN MAR99 (ED)";
label variable PUBAP99X "COVR BY ANY PUBLIC INS IN APR99 (ED)";
label variable PUBMY99X "COVR BY ANY PUBLIC INS IN MAY99 (ED)";
label variable PUBJU99X "COVR BY ANY PUBLIC INS IN JUN99 (ED)";
label variable PUBJL99X "COVR BY ANY PUBLIC INS IN JUL99 (ED)";
label variable PUBAU99X "COVR BY ANY PUBLIC INS IN AUG99 (ED)";
label variable PUBSE99X "COVR BY ANY PUBLIC INS IN SEP99 (ED)";
label variable PUBOC99X "COVR BY ANY PUBLIC INS IN OCT99 (ED)";
label variable PUBNO99X "COVR BY ANY PUBLIC INS IN NOV99 (ED)";
label variable PUBDE99X "COVR BY ANY PUBLIC INS IN DEC99 (ED)";
label variable PEGJA99 "COVERED BY EMPL UNION INS IN JAN99";
label variable PEGFE99 "COVERED BY EMPL UNION INS IN FEB99";
label variable PEGMA99 "COVERED BY EMPL UNION INS IN MAR99";
label variable PEGAP99 "COVERED BY EMPL UNION INS IN APR99";
label variable PEGMY99 "COVERED BY EMPL UNION INS IN MAY99";
label variable PEGJU99 "COVERED BY EMPL UNION INS IN JUN99";
label variable PEGJL99 "COVERED BY EMPL UNION INS IN JUL99";
label variable PEGAU99 "COVERED BY EMPL UNION INS IN AUG99";
label variable PEGSE99 "COVERED BY EMPL UNION INS IN SEP99";
label variable PEGOC99 "COVERED BY EMPL UNION INS IN OCT99";
label variable PEGNO99 "COVERED BY EMPL UNION INS IN NOV99";
label variable PEGDE99 "COVERED BY EMPL UNION INS IN DEC99";
label variable PDKJA99 "COVR BY PRIV INS (SOURCE UNKNWN) JAN99";
label variable PDKFE99 "COVR BY PRIV INS (SOURCE UNKNWN) FEB99";
label variable PDKMA99 "COVR BY PRIV INS (SOURCE UNKNWN) MAR99";
label variable PDKAP99 "COVR BY PRIV INS (SOURCE UNKNWN) APR99";
label variable PDKMY99 "COVR BY PRIV INS (SOURCE UNKNWN) MAY99";
label variable PDKJU99 "COVR BY PRIV INS (SOURCE UNKNWN) JUN99";
label variable PDKJL99 "COVR BY PRIV INS (SOURCE UNKNWN) JUL99";
label variable PDKAU99 "COVR BY PRIV INS (SOURCE UNKNWN) AUG99";
label variable PDKSE99 "COVR BY PRIV INS (SOURCE UNKNWN) SEP99";
label variable PDKOC99 "COVR BY PRIV INS (SOURCE UNKNWN) OCT99";
label variable PDKNO99 "COVR BY PRIV INS (SOURCE UNKNWN) NOV99";
label variable PDKDE99 "COVR BY PRIV INS (SOURCE UNKNWN) DEC99";
label variable PNGJA99 "COVERED BY NONGROUP INS IN JAN99";
label variable PNGFE99 "COVERED BY NONGROUP INS IN FEB99";
label variable PNGMA99 "COVERED BY NONGROUP INS IN MAR99";
label variable PNGAP99 "COVERED BY NONGROUP INS IN APR99";
label variable PNGMY99 "COVERED BY NONGROUP INS IN MAY99";
label variable PNGJU99 "COVERED BY NONGROUP INS IN JUN99";
label variable PNGJL99 "COVERED BY NONGROUP INS IN JUL99";
label variable PNGAU99 "COVERED BY NONGROUP INS IN AUG99";
label variable PNGSE99 "COVERED BY NONGROUP INS IN SEP99";
label variable PNGOC99 "COVERED BY NONGROUP INS IN OCT99";
label variable PNGNO99 "COVERED BY NONGROUP INS IN NOV99";
label variable PNGDE99 "COVERED BY NONGROUP INS IN DEC99";
label variable POGJA99 "COVERED BY OTHER GROUP INS IN JAN99";
label variable POGFE99 "COVERED BY OTHER GROUP INS IN FEB99";
label variable POGMA99 "COVERED BY OTHER GROUP INS IN MAR99";
label variable POGAP99 "COVERED BY OTHER GROUP INS IN APR99";
label variable POGMY99 "COVERED BY OTHER GROUP INS IN MAY99";
label variable POGJU99 "COVERED BY OTHER GROUP INS IN JUN99";
label variable POGJL99 "COVERED BY OTHER GROUP INS IN JUL99";
label variable POGAU99 "COVERED BY OTHER GROUP INS IN AUG99";
label variable POGSE99 "COVERED BY OTHER GROUP INS IN SEP99";
label variable POGOC99 "COVERED BY OTHER GROUP INS IN OCT99";
label variable POGNO99 "COVERED BY OTHER GROUP INS IN NOV99";
label variable POGDE99 "COVERED BY OTHER GROUP INS IN DEC99";
label variable PRSJA99 "COVERED BY SELF-EMP-1 INS IN JAN99";
label variable PRSFE99 "COVERED BY SELF-EMP-1 INS IN FEB99";
label variable PRSMA99 "COVERED BY SELF-EMP-1 INS IN MAR99";
label variable PRSAP99 "COVERED BY SELF-EMP-1 INS IN APR99";
label variable PRSMY99 "COVERED BY SELF-EMP-1 INS IN MAY99";
label variable PRSJU99 "COVERED BY SELF-EMP-1 INS IN JUN99";
label variable PRSJL99 "COVERED BY SELF-EMP-1 INS IN JUL99";
label variable PRSAU99 "COVERED BY SELF-EMP-1 INS IN AUG99";
label variable PRSSE99 "COVERED BY SELF-EMP-1 INS IN SEP99";
label variable PRSOC99 "COVERED BY SELF-EMP-1 INS IN OCT99";
label variable PRSNO99 "COVERED BY SELF-EMP-1 INS IN NOV99";
label variable PRSDE99 "COVERED BY SELF-EMP-1 INS IN DEC99";
label variable POUJA99 "COVERED BY HOLDER OUTSIDE OF RU IN JAN99";
label variable POUFE99 "COVERED BY HOLDER OUTSIDE OF RU IN FEB99";
label variable POUMA99 "COVERED BY HOLDER OUTSIDE OF RU IN MAR99";
label variable POUAP99 "COVERED BY HOLDER OUTSIDE OF RU IN APR99";
label variable POUMY99 "COVERED BY HOLDER OUTSIDE OF RU IN MAY99";
label variable POUJU99 "COVERED BY HOLDER OUTSIDE OF RU IN JUN99";
label variable POUJL99 "COVERED BY HOLDER OUTSIDE OF RU IN JUL99";
label variable POUAU99 "COVERED BY HOLDER OUTSIDE OF RU IN AUG99";
label variable POUSE99 "COVERED BY HOLDER OUTSIDE OF RU IN SEP99";
label variable POUOC99 "COVERED BY HOLDER OUTSIDE OF RU IN OCT99";
label variable POUNO99 "COVERED BY HOLDER OUTSIDE OF RU IN NOV99";
label variable POUDE99 "COVERED BY HOLDER OUTSIDE OF RU IN DEC99";
label variable PRIJA99 "COVERED BY PRIVATE INS IN JAN99";
label variable PRIFE99 "COVERED BY PRIVATE INS IN FEB99";
label variable PRIMA99 "COVERED BY PRIVATE INS IN MAR99";
label variable PRIAP99 "COVERED BY PRIVATE INS IN APR99";
label variable PRIMY99 "COVERED BY PRIVATE INS IN MAY99";
label variable PRIJU99 "COVERED BY PRIVATE INS IN JUN99";
label variable PRIJL99 "COVERED BY PRIVATE INS IN JUL99";
label variable PRIAU99 "COVERED BY PRIVATE INS IN AUG99";
label variable PRISE99 "COVERED BY PRIVATE INS IN SEP99";
label variable PRIOC99 "COVERED BY PRIVATE INS IN OCT99";
label variable PRINO99 "COVERED BY PRIVATE INS IN NOV99";
label variable PRIDE99 "COVERED BY PRIVATE INS IN DEC99";
label variable HPEJA99 "HOLDER OF EMPL UNION INS IN JAN99";
label variable HPEFE99 "HOLDER OF EMPL UNION INS IN FEB99";
label variable HPEMA99 "HOLDER OF EMPL UNION INS IN MAR99";
label variable HPEAP99 "HOLDER OF EMPL UNION INS IN APR99";
label variable HPEMY99 "HOLDER OF EMPL UNION INS IN MAY99";
label variable HPEJU99 "HOLDER OF EMPL UNION INS IN JUN99";
label variable HPEJL99 "HOLDER OF EMPL UNION INS IN JUL99";
label variable HPEAU99 "HOLDER OF EMPL UNION INS IN AUG99";
label variable HPESE99 "HOLDER OF EMPL UNION INS IN SEP99";
label variable HPEOC99 "HOLDER OF EMPL UNION INS IN OCT99";
label variable HPENO99 "HOLDER OF EMPL UNION INS IN NOV99";
label variable HPEDE99 "HOLDER OF EMPL UNION INS IN DEC99";
label variable HPDJA99 "HOLDER OF PRIV INS (SOURCE UNKNWN) JAN99";
label variable HPDFE99 "HOLDER OF PRIV INS (SOURCE UNKNWN) FEB99";
label variable HPDMA99 "HOLDER OF PRIV INS (SOURCE UNKNWN) MAR99";
label variable HPDAP99 "HOLDER OF PRIV INS (SOURCE UNKNWN) APR99";
label variable HPDMY99 "HOLDER OF PRIV INS (SOURCE UNKNWN) MAY99";
label variable HPDJU99 "HOLDER OF PRIV INS (SOURCE UNKNWN) JUN99";
label variable HPDJL99 "HOLDER OF PRIV INS (SOURCE UNKNWN) JUL99";
label variable HPDAU99 "HOLDER OF PRIV INS (SOURCE UNKNWN) AUG99";
label variable HPDSE99 "HOLDER OF PRIV INS (SOURCE UNKNWN) SEP99";
label variable HPDOC99 "HOLDER OF PRIV INS (SOURCE UNKNWN) OCT99";
label variable HPDNO99 "HOLDER OF PRIV INS (SOURCE UNKNWN) NOV99";
label variable HPDDE99 "HOLDER OF PRIV INS (SOURCE UNKNWN) DEC99";
label variable HPNJA99 "HOLDER OF NONGROUP INS IN JAN99";
label variable HPNFE99 "HOLDER OF NONGROUP INS IN FEB99";
label variable HPNMA99 "HOLDER OF NONGROUP INS IN MAR99";
label variable HPNAP99 "HOLDER OF NONGROUP INS IN APR99";
label variable HPNMY99 "HOLDER OF NONGROUP INS IN MAY99";
label variable HPNJU99 "HOLDER OF NONGROUP INS IN JUN99";
label variable HPNJL99 "HOLDER OF NONGROUP INS IN JUL99";
label variable HPNAU99 "HOLDER OF NONGROUP INS IN AUG99";
label variable HPNSE99 "HOLDER OF NONGROUP INS IN SEP99";
label variable HPNOC99 "HOLDER OF NONGROUP INS IN OCT99";
label variable HPNNO99 "HOLDER OF NONGROUP INS IN NOV99";
label variable HPNDE99 "HOLDER OF NONGROUP INS IN DEC99";
label variable HPOJA99 "HOLDER OF OTHER GROUP INS IN JAN99";
label variable HPOFE99 "HOLDER OF OTHER GROUP INS IN FEB99";
label variable HPOMA99 "HOLDER OF OTHER GROUP INS IN MAR99";
label variable HPOAP99 "HOLDER OF OTHER GROUP INS IN APR99";
label variable HPOMY99 "HOLDER OF OTHER GROUP INS IN MAY99";
label variable HPOJU99 "HOLDER OF OTHER GROUP INS IN JUN99";
label variable HPOJL99 "HOLDER OF OTHER GROUP INS IN JUL99";
label variable HPOAU99 "HOLDER OF OTHER GROUP INS IN AUG99";
label variable HPOSE99 "HOLDER OF OTHER GROUP INS IN SEP99";
label variable HPOOC99 "HOLDER OF OTHER GROUP INS IN OCT99";
label variable HPONO99 "HOLDER OF OTHER GROUP INS IN NOV99";
label variable HPODE99 "HOLDER OF OTHER GROUP INS IN DEC99";
label variable HPSJA99 "HOLDER OF SELF-EMP-1 INS IN JAN99";
label variable HPSFE99 "HOLDER OF SELF-EMP-1 INS IN FEB99";
label variable HPSMA99 "HOLDER OF SELF-EMP-1 INS IN MAR99";
label variable HPSAP99 "HOLDER OF SELF-EMP-1 INS IN APR99";
label variable HPSMY99 "HOLDER OF SELF-EMP-1 INS IN MAY99";
label variable HPSJU99 "HOLDER OF SELF-EMP-1 INS IN JUN99";
label variable HPSJL99 "HOLDER OF SELF-EMP-1 INS IN JUL99";
label variable HPSAU99 "HOLDER OF SELF-EMP-1 INS IN AUG99";
label variable HPSSE99 "HOLDER OF SELF-EMP-1 INS IN SEP99";
label variable HPSOC99 "HOLDER OF SELF-EMP-1 INS IN OCT99";
label variable HPSNO99 "HOLDER OF SELF-EMP-1 INS IN NOV99";
label variable HPSDE99 "HOLDER OF SELF-EMP-1 INS IN DEC99";
label variable HPRJA99 "HOLDER OF PRIVATE INSURANCE IN JAN99";
label variable HPRFE99 "HOLDER OF PRIVATE INSURANCE IN FEB99";
label variable HPRMA99 "HOLDER OF PRIVATE INSURANCE IN MAR99";
label variable HPRAP99 "HOLDER OF PRIVATE INSURANCE IN APR99";
label variable HPRMY99 "HOLDER OF PRIVATE INSURANCE IN MAY99";
label variable HPRJU99 "HOLDER OF PRIVATE INSURANCE IN JUN99";
label variable HPRJL99 "HOLDER OF PRIVATE INSURANCE IN JUL99";
label variable HPRAU99 "HOLDER OF PRIVATE INSURANCE IN AUG99";
label variable HPRSE99 "HOLDER OF PRIVATE INSURANCE IN SEP99";
label variable HPROC99 "HOLDER OF PRIVATE INSURANCE IN OCT99";
label variable HPRNO99 "HOLDER OF PRIVATE INSURANCE IN NOV99";
label variable HPRDE99 "HOLDER OF PRIVATE INSURANCE IN DEC99";
label variable INSJA99X "COVR BY HOSP/MED INS IN JAN99 (ED)";
label variable INSFE99X "COVR BY HOSP/MED INS IN FEB99 (ED)";
label variable INSMA99X "COVR BY HOSP/MED INS IN MAR99 (ED)";
label variable INSAP99X "COVR BY HOSP/MED INS IN APR99 (ED)";
label variable INSMY99X "COVR BY HOSP/MED INS IN MAY99 (ED)";
label variable INSJU99X "COVR BY HOSP/MED INS IN JUN99 (ED)";
label variable INSJL99X "COVR BY HOSP/MED INS IN JUL99 (ED)";
label variable INSAU99X "COVR BY HOSP/MED INS IN AUG99 (ED)";
label variable INSSE99X "COVR BY HOSP/MED INS IN SEP99 (ED)";
label variable INSOC99X "COVR BY HOSP/MED INS IN OCT99 (ED)";
label variable INSNO99X "COVR BY HOSP/MED INS IN NOV99 (ED)";
label variable INSDE99X "COVR BY HOSP/MED INS IN DEC99 (ED)";
label variable PRVEV99 "EVER HAVE PRIVATE INSURANCE DURING 99";
label variable CHPEV99 "EVER HAVE CHAMPUS/CHAMPVA DURING 99";
label variable MCREV99 "EVER HAVE MEDICARE DURING 99";
label variable MCDEV99 "EVER HAVE MEDICAID DURING 99";
label variable OPAEV99 "EVER HAVE OTHER PUBLIC A INS DURING 99";
label variable OPBEV99 "EVER HAVE OTHER PUBLIC B INS DURING 99";
label variable UNINS99 "UNINSURED ALL OF 99";
label variable INSCOV99 "HEALTH INSURANCE COVERAGE INDICATOR 99";
label variable DENTIN31 "DENTAL INSURANCE - RD 3/1";
label variable DENTIN42 "DENTAL INSURANCE - RD 4/2";
label variable DENTIN53 "DENTAL INSURANCE - RD 5/3";
label variable PMEDIN31 "PRESCRIPTION DRUG INSURANCE - RD 3/1";
label variable PMEDIN42 "PRESCRIPTION DRUG INSURANCE - RD 4/2";
label variable PMEDIN53 "PRESCRIPTION DRUG INSURANCE - RD 5/3";
label variable DDNWRK31 "# DAYS MISSED WORK DUE TO ILL/INJ-R31";
label variable DDNWRK42 "# DAYS MISSED WORK DUE TO ILL/INJ-R42";
label variable DDNWRK53 "# DAYS MISSED WORK DUE TO ILL/INJ-R53";
label variable WKINBD31 "# DAYS MISSED WORK STAYED IN BED-R31";
label variable WKINBD42 "# DAYS MISSED WORK STAYED IN BED-R42";
label variable WKINBD53 "# DAYS MISSED WORK STAYED IN BED-R53";
label variable DDNSCL31 "# DAYS MISSED SCHOOL DUE TO ILL/INJ-R31";
label variable DDNSCL42 "# DAYS MISSED SCHOOL DUE TO ILL/INJ-R42";
label variable DDNSCL53 "# DAYS MISSED SCHOOL DUE TO ILL/INJ-R53";
label variable SCLNBD31 "# DAYS MISSED SCHOOL STAYED IN BED-R31";
label variable SCLNBD42 "# DAYS MISSED SCHOOL STAYED IN BED-R42";
label variable SCLNBD53 "# DAYS MISSED SCHOOL STAYED IN BED-R53";
label variable DDBDYS31 "# OTH DAYS SPENT IN BED SINCE START-R31";
label variable DDBDYS42 "# OTH DAYS SPENT IN BED SINCE START-R42";
label variable DDBDYS53 "# OTH DAYS SPENT IN BED SINCE START-R53";
label variable OTHDYS31 "MISS ANY WRK/SCH DAY TO CARE FOR OTH-R31";
label variable OTHDYS42 "MISS ANY WRK/SCH DAY TO CARE FOR OTH-R42";
label variable OTHDYS53 "MISS ANY WRK/SCH DAY TO CARE FOR OTH-R53";
label variable OTHNDD31 "# DAYS MISSED WRK/SCH CARE FOR OTHRS-R31";
label variable OTHNDD42 "# DAYS MISSED WRK/SCH CARE FOR OTHRS-R42";
label variable OTHNDD53 "# DAYS MISSED WRK/SCH CARE FOR OTHRS-R53";
label variable ACCELI42 "PERS ELIGIBLE FOR ACCESS SUPPLEMENT";
label variable HAVEUS42 "AC01 DOES PERSON HAVE A USC PROVIDER?";
label variable YNOUSC42 "AC03 MAIN REASON PERS DOESN T HAVE A USC";
label variable NOREAS42 "AC04 OTH REAS NO USC: NO OTHER REASONS";
label variable SELDSI42 "AC04 OTH REAS NO USC: SELDOM OR NEV SICK";
label variable NEWARE42 "ACO4 OTH REAS NO USC: RECENTLY MOVED";
label variable DKWHRU42 "AC04 OTH REAS NO USC: DK WHERE TO GO";
label variable USCNOT42 "AC04 OTH REAS NO USC: USC NOT AVAILABLE";
label variable PERSLA42 "AC04 OTH REAS NO USC: LANGUAGE";
label variable DIFFPL42 "AC04 OTH REAS NO USC: DIFFERENT PLACES";
label variable INSRPL42 "AC04 OTH REAS NO USC: JUST CHANGED INSUR";
label variable MYSELF42 "AC04 OTH REAS NO USC: NO DOCS/TREAT SELF";
label variable CARECO42 "AC04 OTH REAS NO USC: COST OF MED CARE";
label variable OTHINS42 "AC04 OTH REAS NO USC: INS RELATED REASON";
label variable OTHREA42 "AC04 OTH REAS NO USC: OTHER REASON";
label variable TYPEPL42 "USC TYPE of PLACE";
label variable PROVTY42 "PROVIDER TYPE";
label variable YGOTOU42 "AC08 MAIN REASON PERS GOES TO HOSP USC";
label variable NOREA942 "AC09 OTH REAS GOTO USC: NO OTHER REASONS";
label variable LIKESU42 "AC09 OTH REAS GOTO USC: PREFERS/LIKES";
label variable DKELSE42 "AC09 OTH REAS GOTO USC: DK WH ELSE TO GO";
label variable AFFORD42 "AC09 OTH REAS GOTO USC: CAN T AFFORD OTH";
label variable OFFICE42 "AC09 OTH REAS GOTO USC: DR OFFICE AT OPD";
label variable AVAILT42 "AC09 OTH REAS GOTO USC: AVAIL WHEN TIME";
label variable CONVEN42 "AC09 OTH REAS GOTO USC: CONVENIENCE";
label variable BSTPLA42 "AC09 OTH REAS GOTO USC: BEST FOR COND";
label variable INSREA42 "AC09 OTH REAS GO TO USC: INSUR RELATED";
label variable OTHRE942 "AC09 OTH REAS GOTO USC: OTHER REASON";
label variable GETTOU42 "AC09A HOW DOES PERS GET TO USC PROV";
label variable TYPEPE42 "USC TYPE OF PROVIDER";
label variable LOCATI42 "USC LOCATION";
label variable MINORP42 "AC14 GOTO USC FOR NEW HEALTH PROBLEM";
label variable PREVEN42 "AC14 GOTO USC FOR PREVENTIVE HEALTH CARE";
label variable REFFRL42 "AC14 GOTO USC FOR REFERRALS";
label variable OFFHOU42 "AC15 USC HAS OFFICE HRS NIGHTS/WEEKENDS";
label variable APPTWL42 "AC16 WHEN SEE USC,HAVE APPT OR WALK IN";
label variable APPDIF42 "AC17 HOW DIFFICULT TO GET APPT WITH USC";
label variable WAITTI42 "AC18 WITH APPT, HOW LONG TIL SEEN BY USC";
label variable PHONED42 "AC19 HOW DIFFICULT CONTACT USC BY PHONE";
label variable PRLIST42 "AC19A DOES USC PROV LISTEN?";
label variable TREATM42 "AC19B PROV ASK ABOUT OTHER TREATMENTS";
label variable CONFID42 "AC19C CONFIDENT IN USC PROV S ABILITY?";
label variable PROVST42 "AC19D HOW SATISFIED WITH USC STAFF";
label variable USCQUA42 "AC19E SATISFIED WITH QUALITY OF CARE";
label variable CHNGUS42 "AC20 HAS ANYONE CHANGED USC IN LAST YEAR";
label variable YCHNGU42 "AC21 WHY DID PERSON(S) CHANGE USC";
label variable ANYUSC42 "AC22 HAS ANYONE HAD A USC IN LAST YEAR";
label variable YNOMOR42 "AC23 WHY DON T THEY HAVE A USC ANYMORE?";
label variable NOCARE42 "AC24 DID ANYONE GO W/OUT HEALTH CARE?";
label variable HCNEED42 "AC24A SATISFIED FAMILY CAN GET CARE";
label variable OBTAIN42 "AC25 ANYONE HAVE DIFFICLTY OBTAIN CARE";
label variable MAINPR42 "AC25A MAIN REASON EXPERIENCED DIFFICULTY";
label variable NOOTHP42 "AC26 DIFFICULTY: NO OTHER PROBLEMS";
label variable NOAFFO42 "AC26 DIFFICULTY: COULDN T AFFORD CARE";
label variable INSNOP42 "AC26 DIFFICULTY: INS COMPANY WON T PAY";
label variable PREEXC42 "AC26 DIFFICULTY: PRE-EXISTING CONDITION";
label variable INSRQR42 "AC26 DIFFICULTY: INS REQUIRED REFERRAL";
label variable REFUSI42 "AC26 DIFFICULTY: DR REFUSED INS PLAN";
label variable DISTAN42 "AC26 DIFFICULTY: DISTANCE";
label variable PUBTRA42 "AC26 DIFFICULTY: PUBLIC TRANSPORTATION";
label variable EXPENS42 "AC26 DIFFICULTY: TOO EXPEN TO GET THERE";
label variable HEARPR42 "AC26 DIFFICULTY: HEARING IMPAIR/LOSS";
label variable LANGBA42 "AC26 DIFFICULTY: LANGUAGE BARRIER";
label variable INTOBL42 "AC26 DIFFICULTY: HARD TO GET INTO BLDG";
label variable INSIDE42 "AC26 DIFFICULTY: HARD TO GET AROUND";
label variable EQUIPM42 "AC26 DIFFICULTY: NO APPROPRIATE EQUIP";
label variable OFFWOR42 "AC26 DIFFICULTY: COULDN T GET TIME OFF";
label variable DKWHER42 "AC26 DIFFICULTY: DK WHERE TO GO";
label variable REFUSE42 "AC26 DIFFICULTY: WAS REFUSED SERVICES";
label variable CHLDCA42 "AC26 DIFFICULTY: COULDN T GET CHILD CARE";
label variable NOTIME42 "AC26 DIFFICULTY: NO TIME/TOOK TOO LONG";
label variable OTHRPR42 "AC26 DIFFICULTY: OTHER";
label variable RTHLTH31 "PERCEIVED HEALTH STATUS - RD 3/1";
label variable RTHLTH42 "PERCEIVED HEALTH STATUS - RD 4/2";
label variable RTHLTH53 "PERCEIVED HEALTH STATUS - RD 5/3";
label variable RTPROX31 "SELF/PROXY RATING OF HEALTH - RD 3/1";
label variable RTPROX42 "SELF/PROXY RATING OF HEALTH - RD 4/2";
label variable RTPROX53 "SELF/PROXY RATING OF HEALTH - RD 5/3";
label variable MNHLTH31 "PERCEIVED MENTAL HEALTH STATUS - RD 3/1";
label variable MNHLTH42 "PERCEIVED MENTAL HEALTH STATUS - RD 4/2";
label variable MNHLTH53 "PERCEIVED MENTAL HEALTH STATUS - RD 5/3";
label variable MNPROX31 "SELF/PROXY RATING OF MENTAL HEALTH-R3/1";
label variable MNPROX42 "SELF/PROXY RATING OF MENTAL HEALTH-R4/2";
label variable MNPROX53 "SELF/PROXY RATING OF MENTAL HEALTH-R5/3";
label variable IADLHP31 "IADL SCREENER - RD 3/1";
label variable IADLHP42 "IADL SCREENER - RD 4/2";
label variable IADLHP53 "IADL SCREENER - RD 5/3";
label variable ADLHLP31 "ADL SCREENER - RD 3/1";
label variable ADLHLP42 "ADL SCREENER - RD 4/2";
label variable ADLHLP53 "ADL SCREENER - RD 5/3";
label variable AIDHLP31 "USED ASSISTIVE DEVICES - RD 3/1";
label variable AIDHLP53 "USED ASSISTIVE DEVICES - RD 5/3";
label variable WLKLIM31 "LIMITATION IN PHYSICAL FUNCTIONING-RD3/1";
label variable WLKLIM53 "LIMITATION IN PHYSICAL FUNCTIONING-RD5/3";
label variable LFTDIF31 "DIFFICULTY LIFTING 10 POUNDS - RD 3/1";
label variable LFTDIF53 "DIFFICULTY LIFTING 10 POUNDS - RD 5/3";
label variable STPDIF31 "DIFFICULTY WALKING UP 10 STEPS - RD 3/1";
label variable STPDIF53 "DIFFICULTY WALKING UP 10 STEPS - RD 5/3";
label variable WLKDIF31 "DIFFICULTY WALKING 3 BLOCKS - RD 3/1";
label variable WLKDIF53 "DIFFICULTY WALKING 3 BLOCKS - RD 5/3";
label variable MILDIF31 "DIFFICULTY WALKING A MILE - RD 3/1";
label variable MILDIF53 "DIFFICULTY WALKING A MILE - RD 5/3";
label variable STNDIF31 "DIFFICULTY STANDING 20 MINUTES - RD 3/1";
label variable STNDIF53 "DIFFICULTY STANDING 20 MINUTES - RD 5/3";
label variable BENDIF31 "DIFFICULTY BENDING/STOOPING - RD 3/1";
label variable BENDIF53 "DIFFICULTY BENDING/STOOPING - RD 5/3";
label variable RCHDIF31 "DIFFICULTY REACHING OVERHEAD - RD 3/1";
label variable RCHDIF53 "DIFFICULTY REACHING OVERHEAD - RD 5/3";
label variable FNGRDF31 "DIFFICULTY USING FINGERS TO GRASP-RD 3/1";
label variable FNGRDF53 "DIFFICULTY USING FINGERS TO GRASP-RD 5/3";
label variable ACTLIM31 "ANY LIMITATION WORK/HOUSEWRK/SCHL-RD 3/1";
label variable ACTLIM53 "ANY LIMITATION WORK/HOUSEWRK/SCHL-RD 5/3";
label variable WRKLIM31 "WORK LIMITATION - RD 3/1";
label variable WRKLIM53 "WORK LIMITATION - RD 5/3";
label variable HSELIM31 "HOUSEWORK LIMITATION - RD 3/1";
label variable HSELIM53 "HOUSEWORK LIMITATION - RD 5/3";
label variable SCHLIM31 "SCHOOL LIMITATION - RD 3/1";
label variable SCHLIM53 "SCHOOL LIMITATION - RD 5/3";
label variable UNABLE31 "COMPLETELY UNABLE TO DO ACTIVITY-RD 3/1";
label variable UNABLE53 "COMPLETELY UNABLE TO DO ACTIVITY-RD 5/3";
label variable SOCLIM31 "SOCIAL LIMITATIONS - RD 3/1";
label variable SOCLIM53 "SOCIAL LIMITATIONS - RD 5/3";
label variable COGLIM31 "COGNITIVE LIMITATIONS - RD 3/1";
label variable COGLIM53 "COGNITIVE LIMITATIONS - RD 5/3";
label variable WRGLAS42 "WEARS EYEGLASSES OR CONTACTS - RD 4/2";
label variable SEEDIF42 "DIFFCLTY SEEING W/GLASSES/CNTCTS-RD 4/2";
label variable BLIND42 "PERSON IS BLIND - RD 4/2";
label variable READNW42 "CAN READ NEWSPRNT W/GLASSES/CNTCTS-RD4/2";
label variable RECPEP42 "CAN RECGNZE PEOPLE W/GLASSES/CNTCTS-R4/2";
label variable VISION42 "VISION IMPAIRMENT (SUMMARY) - RD 4/2";
label variable HEARAD42 "PERSON WEARS HEARING AID - RD 4/2";
label variable HEARDI42 "ANY DIFFCLTY HEARING W/HEARING AID-RD4/2";
label variable DEAF42 "PERSON IS DEAF - RD 4/2";
label variable HEARMO42 "CAN HEAR MOST CONVERSATION - RD 4/2";
label variable HEARSM42 "CAN HEAR SOME CONVERSATION - RD 4/2";
label variable HEARNG42 "HEARING IMPAIRMENT (SUMMARY) - RD 4/2";
label variable ANYLIM99 "ANY LIMITATION IN P3R3,4,5/P4R1,2,3";
label variable LIMACT42 "LIMITED IN ANY ACTIVITIES (<5 YR)-RD 4/2";
label variable PLYLIM42 "LIMITED IN PLAY ACTIVITY (<5 YRS)-RD 4/2";
label variable CANTPL42 "CAN T PARTICIPATE USUAL PLAY(<5 YR)-R4/2";
label variable SPCPRO42 "IN SPECIAL PROGRAM (<5 YRS) - RD 4/2";
label variable DPTSHT42 "IMMUNIZATION FOR DPT (<7 YRS) - RD 4/2";
label variable NUMDPT42 "ONE OR SEVERAL DPT SHOTS (<7 YRS)-RD 4/2";
label variable POLSHT42 "IMMUNIZATION FOR POLIO (<7 YRS)-RD 4/2";
label variable NUMPOL42 "ONE OR SEVERAL POLIO SHOTS (<7 YR)-RD4/2";
label variable MMRSHT42 "IMMUNIZATION MEASLES/MUMPS/RUBELLA-RD4/2";
label variable HEPSHT42 "IMMUNIZATION FOR HEPATITIS (<7 YR)-RD4/2";
label variable MOMPRO42 "PROBLEM GETTING ALONG W/MOM (5-17)-RD4/2";
label variable DADPRO42 "PROBLEM GETTING ALONG W/DAD (5-17)-RD4/2";
label variable UNHAP42 "PROBLEM FEELING UNHAPPY/SAD (5-17)-RD4/2";
label variable SCHLBH42 "PROBLEM BEHAVIOR AT SCHOOL (5-17)-RD 4/2";
label variable HAVFUN42 "PROBLEM HAVING FUN (5-17) - RD 4/2";
label variable ADUPRO42 "PRBLM GETTING ALONG W/ADULTS (5-17)-R4/2";
label variable NERVAF42 "PRBLM FEELING NERVOUS/AFRAID (5-17)-R4/2";
label variable SIBPRO42 "PROBLEM GETTING ALONG W/SIB (5-17)-RD4/2";
label variable KIDPRO42 "PRBLM GETTING ALONG W/KIDS (5-17)-RD 4/2";
label variable SPRPRO42 "PROBLEM W/SPORTS/HOBBIES (5-17) - RD 4/2";
label variable SCHPRO42 "PROBLEM WITH SCHOOLWORK (5-17)-RD 4/2";
label variable HOMEBH42 "PROBLEM W/BEHAVIOR AT HOME (5-17)-RD 4/2";
label variable TRBLE42 "PRBLM STAY OUT OF TROUBLE (5-17)-RD 4/2";
label variable SPCSCH42 "NEED SPECIAL SCHOOL PROGRAM (5-17)-RD4/2";
label variable SPECED42 "IN SPECIAL EDUCATION (5-17) - RD 4/2";
label variable SPCHTH42 "RECEIVED SPEECH THERAPY (5-17) - RD 4/2";
label variable PSYCNS42 "PSYCHOLOGICAL COUNSELING (5-17) - RD 4/2";
label variable OCUPTH42 "RECEIVED OCCUPATIONAL THRPY (5-17)-R4/2";
label variable VOCSVC42 "RECEIVED VOCATIONAL SERVICES (5-17)-R4/2";
label variable TUTOR42 "RECEIVED TUTORING (5-17) - RD 4/2";
label variable READIN42 "USED READER OR INTERPRETER (5-17)-RD 4/2";
label variable PHYTHR42 "RECEIVED PHYSICAL THERAPY (5-17)-RD 4/2";
label variable LIFSKL42 "RECEIVED LIFE SKILLS TRAINING(5-17)-R4/2";
label variable FAMCNS42 "RECEIVED FAMILY COUNSELING (5-17)-RD 4/2";
label variable RECTHR42 "RECEIVED RECREATIONAL THRPY (5-17)-R4/2";
label variable OTHSVC42 "RECEIVED OTH SCHOOL SERVICE (5-17)-RD4/2";
label variable CANTSC42 "LMTED/UNABLE TO GO TO SCHOOL (5-17)-R4/2";
label variable LMOACT42 "LMTED IN NON-SCHOOL ACTIVITY (5-17)-R4/2";
label variable HLTHY42 "CHILD RESISTS ILLNESS WELL (0-17)-RD 4/2";
label variable NTHLTH42 "LESS HLTHY THAN SAME AGE KIDS(0-17)-R4/2";
label variable GETSIC42 "CHILD CATCHES WHAT S AROUND (0-17)-R4/2";
label variable HGTFT42 "CHILD S HEIGHT - FEET (0-17) - RD 4/2";
label variable HGTIN42 "CHILD S HEIGHT - INCHES (0-17) - RD 4/2";
label variable WGTLB42 "CHILD S WEIGHT - POUNDS (0-17) - RD 4/2";
label variable WGTOZ42 "CHILD S WEIGHT - OUNCES (0-17) - RD 4/2";
label variable CHLIM42 "CHILD HAS ANY LIMITATION (0-17) - RD 4/2";
label variable WHRCAR99 "WHERE WAS CHILD CARE PROVIDED  99";
label variable WHOCAR99 "WHO PROVIDED CHILD CARE  99";
label variable DAYCAR99 "CHILD CARE ARRANGEMENTS REQUIRED  99";
label variable TOTTCH99 "TOTAL HEALTH CARE CHARGES 99, EXCL RX";
label variable TOTEXP99 "TOTAL HEALTH CARE EXP 99";
label variable TOTSLF99 "TOTAL AMT PAID BY SELF/FAMILY 99";
label variable TOTMCR99 "TOTAL AMT PAID BY MEDICARE 99";
label variable TOTMCD99 "TOTAL AMT PAID BY MEDICAID 99";
label variable TOTPRV99 "TOTAL AMT PAID BY PRIVATE INS 99";
label variable TOTVA99 "TOTAL AMT PAID BY VA 99";
label variable TOTCHM99 "TOTAL AMT PAID BY CHAMPUS/CHAMPVA 99";
label variable TOTOFD99 "TOTAL AMT PAID BY OTHER FEDERAL 99";
label variable TOTSTL99 "TOTAL AMT PAID BY OTH ST/LOCAL 99";
label variable TOTWCP99 "TOTAL AMT PAID BY WORKERS COMP 99";
label variable TOTOPR99 "TOTAL AMT PAID BY OTHER PRIVATE 99";
label variable TOTOPU99 "TOTAL AMT PAID BY OTHER PUBLIC 99";
label variable TOTOSR99 "TOTAL AMT PAID BY OTHER SOURCES 99";
label variable OBTOTV99 "# OFFICE-BASED PROVIDER VISITS 99";
label variable OBVTCH99 "OFFICE-BASED PROVIDER VISIT CHARGES 99";
label variable OBVEXP99 "TOTAL OFFICE-BASED EXP 99";
label variable OBVSLF99 "ALL OFFICE VISITS -SELF/FAMILY AMT 99";
label variable OBVMCR99 "ALL OFFICE VISITS -MEDICARE AMT 99";
label variable OBVMCD99 "ALL OFFICE VISITS -MEDICAID AMT 99";
label variable OBVPRV99 "ALL OFFICE VISITS -PRIVATE INS AMT 99";
label variable OBVVA99 "ALL OFFICE VISITS-VA AMT 99";
label variable OBVCHM99 "ALL OFFICE VISITS-CHAMPUS/CHAMPVA AMT 99";
label variable OBVOFD99 "ALL OFFICE VISITS-OTHER FEDERAL AMT 99";
label variable OBVSTL99 "ALL OFFICE VISITS-OTH ST/LOCAL AMT 99";
label variable OBVWCP99 "ALL OFFICE VISITS -WORKERS COMP AMT 99";
label variable OBVOPR99 "ALL OFFICE VISITS - OTH PRIVATE AMT 99";
label variable OBVOPU99 "ALL OFFICE VISITS - OTH PUBLIC AMT 99";
label variable OBVOSR99 "ALL OFF VSTS - OTH UNCLASS SRCE AMT 99";
label variable OBDRV99 "# OFFICE-BASED PHYSICIAN VISITS 99";
label variable OBDTCH99 "OFFICE-BASED PHYSICIAN VISIT CHARGES 99";
label variable OBDEXP99 "TOTAL OFF-BASED DR EXP 99";
label variable OBDSLF99 "DR OFFICE VISITS -SELF/FAMILY AMT 99";
label variable OBDMCR99 "DR OFFICE VISITS -MEDICARE AMT 99";
label variable OBDMCD99 "DR OFFICE VISITS -MEDICAID AMT 99";
label variable OBDPRV99 "DR OFFICE VISITS -PRIVATE INS AMT 99";
label variable OBDVA99 "DR OFFICE VISITS -VA AMT 99";
label variable OBDCHM99 "DR OFFICE VISITS-CHAMPUS/CHAMPVA AMT 99";
label variable OBDOFD99 "DR OFFICE VISITS -OTHER FEDERAL AMT 99";
label variable OBDSTL99 "DR OFFICE VISITS -OTH ST/LOCAL AMT 99";
label variable OBDWCP99 "DR OFFICE VISITS -WORKERS COMP AMT 99";
label variable OBDOPR99 "DR OFFICE VISITS - OTH PRIVATE AMT 99";
label variable OBDOPU99 "DR OFFICE VISITS - OTH PUBLIC AMT 99";
label variable OBDOSR99 "DR OFF VSTS - OTH UNCLASS SRCE AMT 99";
label variable OBOTHV99 "# OFFICE-BASED NON-PHYSICAN VISITS 99";
label variable OBOTCH99 "OFFICE-BASED NON-DR VISIT CHARGES 99";
label variable OBOEXP99 "TOTAL OFF-BASED NON-DR EXP 99";
label variable OBOSLF99 "NON-DR OFF VISTS -SELF/FAMILY AMT 99";
label variable OBOMCR99 "NON-DR OFF VISTS -MEDICARE AMT 99";
label variable OBOMCD99 "NON-DR OFF VISTS -MEDICAID AMT 99";
label variable OBOPRV99 "NON-DR OFF VISTS -PRIVATE INS AMT 99";
label variable OBOVA99 "NON-DR OFF VISTS -VA AMT 99";
label variable OBOCHM99 "NON-DR OFF VISTS-CHAMPUS/CHAMPVA AMT 99";
label variable OBOOFD99 "NON-DR OFF VISTS -OTHER FEDERAL AMT 99";
label variable OBOSTL99 "NON-DR OFF VISTS -OTH ST/LOCAL AMT 99";
label variable OBOWCP99 "NON-DR OFF VISTS -WORKERS COMP AMT 99";
label variable OBOOPR99 "NON-DR OFF VISTS - OTH PRIVATE AMT 99";
label variable OBOOPU99 "NON-DR OFF VISTS - OTH PUBLIC AMT 99";
label variable OBOOSR99 "NON-DR OF VSTS - OTH UNCLASS SRCE AMT 99";
label variable OBCHIR99 "# OFFICE-BASED CHIROPRACTOR VISITS 99";
label variable OBCTCH99 "OFFICE-BASED CHIRO VISIT CHARGES 99";
label variable OBCEXP99 "TOTAL OFF-BASED CHIRO EXP 99";
label variable OBCSLF99 "CHIRO OFF VISITS -SELF/FAMILY AMT 99";
label variable OBCMCR99 "CHIRO OFF VISITS -MEDICARE AMT 99";
label variable OBCMCD99 "CHIRO OFF VISITS -MEDICAID AMT 99";
label variable OBCPRV99 "CHIRO OFF VISITS -PRIVATE INS AMT 99";
label variable OBCVA99 "CHIRO OFF VISITS -VA AMT 99";
label variable OBCCHM99 "CHIRO OFF VISITS-CHAMPUS/CHAMPVA AMT 99";
label variable OBCOFD99 "CHIRO OFF VISITS -OTHER FEDERAL AMT 99";
label variable OBCSTL99 "CHIRO OFF VISITS -OTH ST/LOCAL AMT 99";
label variable OBCWCP99 "CHIRO OFF VISITS -WORKERS COMP AMT 99";
label variable OBCOPR99 "CHIRO OFF VISTS - OTHR PRIVATE AMT 99";
label variable OBCOPU99 "CHIRO OFF VISTS - OTHR PUBLIC AMT 99";
label variable OBCOSR99 "CHIRO OF VSTS - OTHR UNCLASS SRCE AMT 99";
label variable OBNURS99 "# OFF-BASED NURSE/PRACTITIONER VISITS 99";
label variable OBNTCH99 "OFFICE-BASED NURSE/PRAC VISIT CHARGES 99";
label variable OBNEXP99 "TOTAL OFF-BASED NURSE/PRAC 99";
label variable OBNSLF99 "NURSE/PRAC OFF VISITS-SELF/FAMILY AMT 99";
label variable OBNMCR99 "NURSE/PRAC OFF VISITS -MEDICARE AMT 99";
label variable OBNMCD99 "NURSE/PRAC OFF VSTS -MEDICAID AMT 99";
label variable OBNPRV99 "NURSE/PRAC OFF VSTS -PRIVATE INS AMT 99";
label variable OBNVA99 "NURSE/PRAC OFF VSTS-VA AMT 99";
label variable OBNCHM99 "NURSE/PRAC OFF VSTS-CHMPUS/CHMPVA AMT 99";
label variable OBNOFD99 "NURSE/PRAC OFF VSTS-OTHER FEDERAL AMT 99";
label variable OBNSTL99 "NURSE/PRAC OFF VSTS -OTH ST/LOCAL AMT 99";
label variable OBNWCP99 "NURSE/PRAC OFF VSTS -WORKERS COMP AMT 99";
label variable OBNOPR99 "NURSE/PRAC OFF VSTS - OTH PRIVATE AMT 99";
label variable OBNOPU99 "NURSE/PRAC OFF VSTS - OTH PUBLIC AMT 99";
label variable OBNOSR99 "NRS/PR OF VSTS - OTH UNCLASS SRCE AMT 99";
label variable OBOPTO99 "# OFF-BASED OPTOMETRIST VISITS 99";
label variable OBETCH99 "OFFICE-BASED OPTOMTRIST VISIT CHARGES 99";
label variable OBEEXP99 "TOTAL OFF-BASED OPOTMETRIST EXP 99";
label variable OBESLF99 "OPTOMETRIST OFF VSTS -SELF/FAMILY AMT 99";
label variable OBEMCR99 "OPTOMETRIST OFF VSTS -MEDICARE AMT 99";
label variable OBEMCD99 "OPTOMETRIST OFF VSTS -MEDICAID AMT 99";
label variable OBEPRV99 "OPTOMETRIST OFF VSTS -PRIVATE INS AMT 99";
label variable OBEVA99 "OPTOMETRIST OFF VSTS -VA AMT 99";
label variable OBECHM99 "OPTOMETRIST OFF VSTS-CHMPUS/CHPVA AMT 99";
label variable OBEOFD99 "OPTOMETRIST OFF VSTS-OTH FEDERAL AMT 99";
label variable OBESTL99 "OPTOMETRIST OFF VSTS -OTH ST/LOCL AMT 99";
label variable OBEWCP99 "OPTOMETRIST OFF VSTS-WORKERS COMP AMT 99";
label variable OBEOPR99 "OPTOMETRIST OFF VSTS -OTH PRIVATE AMT 99";
label variable OBEOPU99 "OPTOMETRIST OFF VSTS -OTH PUBLIC AMT 99";
label variable OBEOSR99 "OPTOM OF VSTS - OTH UNCLASS SRCE AMT 99";
label variable OBASST99 "# OFF-BASED PHYSICIAN ASSIST VISITS 99";
label variable OBATCH99 "OFFICE-BASED PHYS ASST VISIT CHARGES 99";
label variable OBAEXP99 "TOTAL OFF-BASED PHYS ASS T EXP 99";
label variable OBASLF99 "PHYS ASS T OFF VSTS-SELF/FAMILY AMT 99";
label variable OBAMCR99 "PHYS ASS T OFF VSTS-MEDICARE AMT 99";
label variable OBAMCD99 "PHYS ASS T OFF VSTS-MEDICAID AMT 99";
label variable OBAPRV99 "PHYS ASS T OFF VSTS-PRIVATE INS AMT 99";
label variable OBAVA99 "PHYS ASS T OFF VSTS-VA AMT 99";
label variable OBACHM99 "PHYS ASS T OFF VSTS-CHMPUS/CHMPVA AMT 99";
label variable OBAOFD99 "PHYS ASS T OFF VSTS -OTHER FED AMT 99";
label variable OBASTL99 "PHYS ASS T OFF VSTS -OTH ST/LOCL AMT 99";
label variable OBAWCP99 "PHYS ASS T OFF VSTS-WORKERS COMP AMT 99";
label variable OBAOPR99 "PHYS ASS T OFF VSTS - OTH PRIVATE AMT 99";
label variable OBAOPU99 "PHYS ASS T OFF VSTS - OTH PUBLIC AMT 99";
label variable OBAOSR99 "P A OFF VSTS - OTH UNCLASS SRCE AMT 99";
label variable OBTHER99 "# OFF-BASED PT/OT VISITS 99";
label variable OBTTCH99 "OFFICE-BASED PT/OC VISIT CHARGES 99";
label variable OBTEXP99 "TOT OFF-BASED PT EXP 99";
label variable OBTSLF99 "PT/OT OFF VISITS-SELF/FAMILY AMT 99";
label variable OBTMCR99 "PT/OT OFF VISITS-MEDICARE AMT 99";
label variable OBTMCD99 "PT/OT OFF VISITS-MEDICAID AMT 99";
label variable OBTPRV99 "PT/OT OFF VISITS-PRIVATE INS AMT 99";
label variable OBTVA99 "PT/OT OFF VISITS-VA AMT 99";
label variable OBTCHM99 "PT/OT OFF VISITS-CHAMPUS/CHAMPVA AMT 99";
label variable OBTOFD99 "PT/OT OFF VISITS -OTHER FED AMT 99";
label variable OBTSTL99 "PT/OT OFF VISITS-OTH ST/LOCL AMT 99";
label variable OBTWCP99 "PT/OT OFF VISITS-WORKERS COMP AMT 99";
label variable OBTOPR99 "PT/OT OFF VISITS - OTH PRIVATE AMT 99";
label variable OBTOPU99 "PT/OT OFF VISITS - OTH PUBLIC AMT 99";
label variable OBTOSR99 "PT/OT OF VSTS-OTH UNCLASS SRCE AMT 99";
label variable OPTOTV99 "# OUTPATIENT DEPT PROVIDER VISITS 99";
label variable OPFTCH99 "OPD PROVIDER VISIT CHARGES - FAC 99";
label variable OPFEXP99 "TOTAL OUTPATIENT FACILITY EXP 99";
label variable OPFSLF99 "ALL OPD VISITS-SELF/FAMILY AMT-FAC 99";
label variable OPFMCR99 "ALL OPD VISITS-MEDICARE AMT-FAC 99";
label variable OPFMCD99 "ALL OPD VISITS-MEDICAID AMT-FAC 99";
label variable OPFPRV99 "ALL OPD VISITS-PRIV INS AMT-FAC 99";
label variable OPFVA99 "ALL OPD VISITS-VA AMT-FAC 99";
label variable OPFCHM99 "ALL OPD VISITS-CHMPUS/CHMPVA AMT-FAC 99";
label variable OPFOFD99 "ALL OPD VISITS-OTHER FED AMT-FAC 99";
label variable OPFSTL99 "ALL OPD VISITS-OTH ST/LOCAL AMT-FAC 99";
label variable OPFWCP99 "ALL OPD VISITS-WORKERS COMP AMT-FAC 99";
label variable OPFOPR99 "ALL OPD VISITS - OTH PRIVATE AMT-FAC 99";
label variable OPFOPU99 "ALL OPD VISITS - OTH PUBLIC AMT-FAC 99";
label variable OPFOSR99 "ALL OPD VSTS-OTH UNCLASS SRCE AMT-FAC 99";
label variable OPDEXP99 "TOTAL OUTPATIENT PROVIDER EXP 99";
label variable OPDTCH99 "OPD PROVIDER VISIT CHARGES - DR 99";
label variable OPDSLF99 "ALL OPD VISITS-SELF/FAMILY AMT-DR 99";
label variable OPDMCR99 "ALL OPD VISITS-MEDICARE AMT -DR 99";
label variable OPDMCD99 "ALL OPD VISITS-MEDICAID AMT -DR 99";
label variable OPDPRV99 "ALL OPD VISITS-PRIV INS AMT-DR 99";
label variable OPDVA99 "ALL OPD VISITS-VA AMT-DR 99";
label variable OPDCHM99 "ALL OPD VISITS-CHMPUS/CHMPVA AMT-DR 99";
label variable OPDOFD99 "ALL OPD VISITS-OTHER FED AMT-DR 99";
label variable OPDSTL99 "ALL OPD VISITS-OTH ST/LOCAL AMT-DR 99";
label variable OPDWCP99 "ALL OPD VISITS-WORKERS COMP AMT-DR 99";
label variable OPDOPR99 "ALL OPD VISITS - OTH PRIVATE AMT-DR 99";
label variable OPDOPU99 "ALL OPD VISITS-OTH PUBLIC AMT-DR 99";
label variable OPDOSR99 "ALL OPD VSTS-OTH UNCLASS SRCE AMT-DR 99";
label variable OPDRV99 "# OUTPATIENT DEPT PHYSICIAN VISITS 99";
label variable OPVTCH99 "OPD PHYSICIAN VISIT CHARGES - FAC 99";
label variable OPVEXP99 "TOTAL OUTPATIENT PHYSICIAN - FAC EXP 99";
label variable OPVSLF99 "OPD DR VISITS-SELF/FAMILY AMT-FAC 99";
label variable OPVMCR99 "OPD DR VISITS-MEDICARE AMT-FAC 99";
label variable OPVMCD99 "OPD DR VISITS-MEDICAID AMT-FAC 99";
label variable OPVPRV99 "OPD DR VISITS-PRIV INS AMT-FAC 99";
label variable OPVVA99 "OPD DR VISITS-VA AMT-FAC 99";
label variable OPVCHM99 "OPD DR VISITS-CHPUS/CHPVA AMT-FAC 99";
label variable OPVOFD99 "OPD DR VISITS-OTHER FED AMT-FAC 99";
label variable OPVSTL99 "OPD DR VISITS-OTH ST/LOCAL AMT-FAC 99";
label variable OPVWCP99 "OPD DR VISITS-WORKERS COMP AMT-FAC 99";
label variable OPVOPR99 "OPD DR VISITS - OTH PRIVATE AMT-FAC 99";
label variable OPVOPU99 "OPD DR VISITS-OTH PUBLIC AMT-FAC 99";
label variable OPVOSR99 "OPD DR VSTS-OTH UNCLASS SRCE AMT-FAC 99";
label variable OPSEXP99 "TOTAL OUTPATIENT PHYSICIAN - DR EXP 99";
label variable OPSTCH99 "OPD PHYSICIAN VISIT CHARGES - DR 99";
label variable OPSSLF99 "OPD DR VISITS-SELF/FAMILY AMT-DR 99";
label variable OPSMCR99 "OPD DR VISITS-MEDICARE AMT-DR 99";
label variable OPSMCD99 "OPD DR VISITS-MEDICAID AMT-DR 99";
label variable OPSPRV99 "OPD DR VISITS-PRIV INS AMT-DR 99";
label variable OPSVA99 "OPD DR VISITS-VA AMT-DR 99";
label variable OPSCHM99 "OPD DR VISITS-CHMPUS/CHMPVA AMT-DR 99";
label variable OPSOFD99 "OPD DR VISITS-OTHER FED AMT-DR 99";
label variable OPSSTL99 "OPD DR VISITS-OTH ST/LOCAL AMT-DR 99";
label variable OPSWCP99 "OPD DR VISITS-WORKERS COMP AMT-DR 99";
label variable OPSOPR99 "OPD DR VISITS - OTH PRIVATE AMT-DR 99";
label variable OPSOPU99 "OPD DR VISITS-OTH PUBLIC AMT-DR 99";
label variable OPSOSR99 "OPD DR VSTS-OTH UNCLASS SRCE AMT-DR 99";
label variable OPOTHV99 "# OUTPATIENT DEPT NON-DR VISITS 99";
label variable OPOTCH99 "OPD NON-PHYS VISIT CHARGES - FAC 99";
label variable OPOEXP99 "TOTAL OUTPATIENT NON-DR - FAC EXP 99";
label variable OPOSLF99 "OPD NON-DR VISITS-SELF/FAM AMT-FAC 99";
label variable OPOMCR99 "OPD NON-DR VISITS-MEDICARE AMT-FAC 99";
label variable OPOMCD99 "OPD NON-DR VISITS-MEDICAID AMT-FAC 99";
label variable OPOPRV99 "OPD NON-DR VISITS-PRIV INS AMT-FAC 99";
label variable OPOVA99 "OPD NON-DR VISITS-VA AMT-FAC 99";
label variable OPOCHM99 "OPD NON-DR VISITS-CHPS/CHVA AMT-FAC 99";
label variable OPOOFD99 "OPD NON-DR VISITS-OTHER FED AMT-FAC 99";
label variable OPOSTL99 "OPD NON-DR VISITS-OTH ST/LOC AMT-FAC 99";
label variable OPOWCP99 "OPD NON-DR VISITS-WRKRS COMP AMT-FAC 99";
label variable OPOOPR99 "OPD NON-DR VISITS-OTH PRIVATE AMT-FAC 99";
label variable OPOOPU99 "OPD NON-DR VISITS-OTH PUBLIC AMT-FAC 99";
label variable OPOOSR99 "OPD NON-DR VSTS-OT UNCLAS SRC AMT-FAC 99";
label variable OPPEXP99 "TOTAL OUTPATIENT NON-DR - DR EXP 99";
label variable OPPTCH99 "OPD NON-PHYS VISIT CHARGES - DR 99";
label variable OPPSLF99 "OPD NON-DR VISITS-SELF/FAM AMT-DR 99";
label variable OPPMCR99 "OPD NON-DR VISITS-MEDICARE AMT-DR 99";
label variable OPPMCD99 "OPD NON-DR VISITS-MEDICAID AMT-DR 99";
label variable OPPPRV99 "OPD NON-DR VISITS-PRIV INS AMT-DR 99";
label variable OPPVA99 "OPD NON-DR VISITS-VA AMT-DR 99";
label variable OPPCHM99 "OPD NON-DR VISITS-CHPS/CHVA AMT-DR 99";
label variable OPPOFD99 "OPD NON-DR VISITS-OTHER FED AMT-DR 99";
label variable OPPSTL99 "OPD NON-DR VISITS-OTH ST/LOC AMT-DR 99";
label variable OPPWCP99 "OPD NON-DR VISITS-WRKRS COMP AMT-DR 99";
label variable OPPOPR99 "OPD NON-DR VISITS-OTH PRIVATE AMT-DR 99";
label variable OPPOPU99 "OPD NON-DR VISITS-OTH PUBLIC AMT-DR 99";
label variable OPPOSR99 "OPD NON-DR VSTS-OT UNCLAS SRC AMT-DR 99";
label variable AMCHIR99 "# CHIROPRACTR VSTS (OFF+OUTPAT), 1999";
label variable AMCTCH99 "CHIRO AMBULATORY VISIT CHARGES 99";
label variable AMCEXP99 "TOTL AMBULTRY (OB+OP) CHIRO EXP 99";
label variable AMCSLF99 "CHIRO AMB VISITS -SELF/FAMILY AMT 99";
label variable AMCMCR99 "CHIRO AMB VISITS -MEDICARE AMT 99";
label variable AMCMCD99 "CHIRO AMB VISITS -MEDICAID AMT 99";
label variable AMCPRV99 "CHIRO AMB VISITS -PRIVATE INS AMT 99";
label variable AMCVA99 "CHIRO AMB VISITS -VA AMT 99";
label variable AMCCHM99 "CHIRO AMB VISITS-CHAMPUS/CHAMPVA AMT 99";
label variable AMCOFD99 "CHIRO AMB VISITS -OTHER FEDERAL AMT 99";
label variable AMCSTL99 "CHIRO AMB VISITS -OTH ST/LOCAL AMT 99";
label variable AMCWCP99 "CHIRO AMB VISITS-WORKERS COMP AMT 99";
label variable AMCOPR99 "CHIRO AMB VISITS - OTH PRIVATE AMT 99";
label variable AMCOPU99 "CHIRO AMB VISITS - OTH PUBLIC AMT 99";
label variable AMCOSR99 "CHIR AMB VSTS - OTH UNCLASS SRCE AMT 99";
label variable AMNURS99 "# AMB NURSE/PRCTITIONR VSTS(OB+OP) 99";
label variable AMNTCH99 "NRS/PRAC AMBULATORY VISIT CHARGES 99";
label variable AMNEXP99 "TOTL AMBULTRY (OB+OP) NURSE/PRAC EXP 99";
label variable AMNSLF99 "NRS/PRAC AMB VSTS -SELF/FAMILY AMT 99";
label variable AMNMCR99 "NRS/PRAC AMB VSTS -MEDICARE AMT 99";
label variable AMNMCD99 "NRS/PRAC AMB VSTS -MEDICAID AMT 99";
label variable AMNPRV99 "NRS/PRAC AMB VSTS -PRIV INS AMT 99";
label variable AMNVA99 "NRS/PRAC AMB VSTS-VA AMT 99";
label variable AMNCHM99 "NRS/PRAC AMB VSTS-CHAMPUS/CHAMPVA AMT 99";
label variable AMNOFD99 "NRS/PRAC AMB VSTS-OTHER FEDERAL AMT 99";
label variable AMNSTL99 "NRS/PRAC AMB VSTS-OTH ST/LOCAL AMT 99";
label variable AMNWCP99 "NRS/PRAC AMB VSTS-WORKERS COMP AMT 99";
label variable AMNOPR99 "NRS/PRAC AMB VSTS - OTH PRIVATE AMT 99";
label variable AMNOPU99 "NRS/PRAC AMB VSTS - OTH PUBLIC AMT 99";
label variable AMNOSR99 "NRS/PR AMB VSTS - OTH UNCLAS SRCE AMT 99";
label variable AMOPTO99 "# AMB OPTOMETRIST VSTS (OB+OP) 99";
label variable AMETCH99 "OPTOMETRIST AMBULATORY VISIT CHARGES 99";
label variable AMEEXP99 "TOTL AMBULTRY (OB+OP) OPTOMETRIST EXP 99";
label variable AMESLF99 "OPTMTRIST AMB VSTS -SELF/FAMILY AMT 99";
label variable AMEMCR99 "OPTMTRIST AMB VSTS -MEDICARE AMT 99";
label variable AMEMCD99 "OPTMTRIST AMB VSTS -MEDICAID AMT 99";
label variable AMEPRV99 "OPTMTRIST AMB VSTS -PRIVATE INS AMT 99";
label variable AMEVA99 "OPTMTRIST AMB VSTS-VA AMT 99";
label variable AMECHM99 "OPTMTRIST AMB VSTS-CHMPUS/CHMPVA AMT 99";
label variable AMEOFD99 "OPTMTRIST AMB VSTS-OTHER FED AMT 99";
label variable AMESTL99 "OPTMTRIST AMB VSTS-OTH ST/LOCAL AMT 99";
label variable AMEWCP99 "OPTMTRIST AMB VSTS-WORKERS COMP AMT 99";
label variable AMEOPR99 "OPTMTRIST AMB VSTS - OTH PRIVATE AMT 99";
label variable AMEOPU99 "OPTMTRIST AMB VSTS - OTH PUBLIC AMT 99";
label variable AMEOSR99 "OPTOM AMB VSTS - OTH UNCLAS SRCE AMT 99";
label variable AMASST99 "# PHYSICIAN ASS T VSTS (OFF+OUPAT), 1999";
label variable AMATCH99 "PHYS ASS T AMBULATORY VISIT CHARGES 99";
label variable AMAEXP99 "TOTL AMBULTRY (OB+OP) PHYS ASS T EXP 99";
label variable AMASLF99 "PHYS ASS T AMB VSTS-SELF/FAMILY AMT 99";
label variable AMAMCR99 "PHYS ASS T AMB VSTS-MEDICARE AMT 99";
label variable AMAMCD99 "PHYS ASS T AMB VSTS-MEDICAID AMT 99";
label variable AMAPRV99 "PHYS ASS T AMB VSTS-PRIVATE INS AMT 99";
label variable AMAVA99 "PHYS ASS T AMB VSTS-VA AMT 99";
label variable AMACHM99 "PHYS ASS T AMB VSTS-CHMPUS/CHMPVA AMT 99";
label variable AMAOFD99 "PHYS ASS T AMB VSTS -OTHER FED AMT 99";
label variable AMASTL99 "PHYS ASS T AMB VSTS-OTH ST/LOCL AMT 99";
label variable AMAWCP99 "PHYS ASS T AMB VSTS-WRKERS COMP AMT 99";
label variable AMAOPR99 "PHYS ASS T AMB VSTS - OTH PRIVATE AMT 99";
label variable AMAOPU99 "PHYS ASS T AMB VSTS - OTH PUBLIC AMT 99";
label variable AMAOSR99 "P A AMB VSTS- OTH UNCLASS SRCE AMT 99";
label variable AMTHER99 "# AMB PT/OT THRPY VISITS (OB+OP) 99";
label variable AMTTCH99 "PT/OC AMBULATORY VISIT CHARGES 99";
label variable AMTEXP99 "TOTL AMBULTRY (OB+OP) PT/OT EXP 99";
label variable AMTSLF99 "PT/OT AMB VISITS-SELF/FAMILY AMT 99";
label variable AMTMCR99 "PT/OT AMB VISITS-MEDICARE AMT 99";
label variable AMTMCD99 "PT/OT AMB VISITS-MEDICAID AMT 99";
label variable AMTPRV99 "PT/OT AMB VISITS-PRIVATE INS AMT 99";
label variable AMTVA99 "PT/OT AMB VISITS-VA AMT 99";
label variable AMTCHM99 "PT/OT AMB VISITS-CHAMPUS/CHAMPVA AMT 99";
label variable AMTOFD99 "PT/OT AMB VISITS -OTHER FED AMT 99";
label variable AMTSTL99 "PT/OT AMB VISITS-OTH ST/LOCL AMT 99";
label variable AMTWCP99 "PT/OT AMB VISITS-WORKERS COMP AMT 99";
label variable AMTOPR99 "PT/OT AMB VISITS - OTH PRIVATE AMT 99";
label variable AMTOPU99 "PT/OT AMB VISITS-OTH PUBLIC AMT 99";
label variable AMTOSR99 "PT/OT AMB VSTS-OTH UNCLAS SRCE AMT 99";
label variable AMTOTC99 "# CALLS W/OFFICE & OUPAT DEPTS, 1999";
label variable AMDRC99 "# CALLS W/OFF & OUTPAT PHYSICIANS, 1999";
label variable ERTOT99 "# EMERGENCY ROOM VISITS 99";
label variable ERFTCH99 "ER FACILITY VISIT CHARGES 99";
label variable ERFEXP99 "TOTAL ER FACILITY EXP 99";
label variable ERFSLF99 "ER-SELF/FAMILY AMT - FAC 99";
label variable ERFMCR99 "ER-MEDICARE AMT - FAC 99";
label variable ERFMCD99 "ER-MEDICAID AMT - FAC 99";
label variable ERFPRV99 "ER-PRIVATE INS AMT - FAC 99";
label variable ERFVA99 "ER-VA AMT - FAC 99";
label variable ERFCHM99 "ER-CHAMPUS/CHAMPVA AMT - FAC 99";
label variable ERFOFD99 "ER-OTHER FEDERAL AMT - FAC 99";
label variable ERFSTL99 "ER-OTH ST/LOCAL AMT - FAC 99";
label variable ERFWCP99 "ER-WORKERS COMP AMT - FAC 99";
label variable ERFOPR99 "ER-OTHER PRIVATE AMT - FAC 99";
label variable ERFOPU99 "ER-OTHER PUBLIC AMT - FAC 99";
label variable ERFOSR99 "ER-OTH UNCLASS SRCE AMT - FAC 99";
label variable ERDEXP99 "TOTAL EMERGENCY ROOM DR EXP 99";
label variable ERDTCH99 "ER DOCTOR VISIT CHARGES 99";
label variable ERDSLF99 "ER-SELF/FAMILY AMT - DR 99";
label variable ERDMCR99 "ER-MEDICARE AMT - DR 99";
label variable ERDMCD99 "ER-MEDICAID AMT - DR 99";
label variable ERDPRV99 "ER-PRIVATE INS AMT - DR 99";
label variable ERDVA99 "ER-VA AMT - DR 99";
label variable ERDCHM99 "ER-CHAMPUS/CHAMPVA AMT - DR 99";
label variable ERDOFD99 "ER-OTHER FED AMT - DR 99";
label variable ERDSTL99 "ER-OTH ST/LOCAL AMT - DR 99";
label variable ERDWCP99 "ER-WORKERS COMP AMT - DR 99";
label variable ERDOPR99 "ER - OTHER PRIVATE AMT - DR 99";
label variable ERDOPU99 "ER - OTHER PUBLIC AMT - DR 99";
label variable ERDOSR99 "ER-OTH UNCLASS SRCE AMT - DR 99";
label variable IPZERO99 "# ZERO-NIGHT HOSPITAL STAYS 99";
label variable ZIFTCH99 "ZERO-NITE IP STAY CHARGES - FAC 99";
label variable ZIFEXP99 "TOTAL ZERO-NITE STAYS FAC EXP 99";
label variable ZIFSLF99 "ZERO-NITE IP STAZ -SELF/FAM AMT-FAC 99";
label variable ZIFMCR99 "ZERO-NITE IP STAZ-MEDICARE AMT-FAC 99";
label variable ZIFMCD99 "ZERO-NITE IP STAZ-MEDICAID AMT-FAC 99";
label variable ZIFPRV99 "ZERO-NITE IP STAZ-PRIV INS AMT-FAC 99";
label variable ZIFVA99 "ZERO-NITE IP STAZ-VA AMT-FAC 99";
label variable ZIFCHM99 "ZERO-NITE IP STAZ-CHPUS/CHPVA AMT-FAC 99";
label variable ZIFOFD99 "ZERO-NITE IP STAZ-OTHER FED AMT-FAC 99";
label variable ZIFSTL99 "ZERO-NITE IP STAZ-OTH ST/LOC AMT-FAC 99";
label variable ZIFWCP99 "ZERO-NITE IP STAZ-WRKERS COMP AMT-FAC 99";
label variable ZIFOPR99 "ZERO-NITE IP STAZ-OTH PRIVATE AMT-FAC 99";
label variable ZIFOPU99 "ZERO-NITE IP STAZ-OTH PUBLIC AMT-FAC 99";
label variable ZIFOSR99 "ZERO-NITE IP STAZ-UNCLAS SRCE AMT-FAC 99";
label variable ZIDEXP99 "TOTAL ZERO-NITE STAZ DR 99";
label variable ZIDTCH99 "ZERO-NITE IP STAY CHARGES - DR 99";
label variable ZIDSLF99 "ZERO-NITE IP STAZ-SELF/FAM AMT-DR 99";
label variable ZIDMCR99 "ZERO-NITE IP STAZ-MEDICARE AMT-DR 99";
label variable ZIDMCD99 "ZERO-NITE IP STAZ-MEDICAID AMT-DR 99";
label variable ZIDPRV99 "ZERO-NITE IP STAZ-PRIV INS AMT-DR 99";
label variable ZIDVA99 "ZERO-NITE IP STAZ-VA AMT-DR 99";
label variable ZIDCHM99 "ZERO-NITE IP STAZ-CHPUS/CHPVA AMT-DR 99";
label variable ZIDOFD99 "ZERO-NITE IP STAZ-OTHER FED AMT-DR 99";
label variable ZIDSTL99 "ZERO-NITE IP STAZ-OTH ST/LOC AMT-DR 99";
label variable ZIDWCP99 "ZERO-NITE IP STAZ-WRKERS COMP AMT-DR 99";
label variable ZIDOPR99 "ZERO-NITE IP STAZ-OTH PRIVATE AMT-DR 99";
label variable ZIDOPU99 "ZERO-NITE IP STAZ-OTH PUBLIC AMT-DR 99";
label variable ZIDOSR99 "ZERO-NITE IP STAZ-UNCLAS SRCE AMT-DR 99";
label variable IPDIS99 "# HOSPITAL DISCHARGES, 1999";
label variable IPFEXP99 "TOT HOSP IP FACILITY EXP-INC 0 NITES 99";
label variable IPFTCH99 "IP HOSP STAY CHARGES - FAC 99";
label variable IPFSLF99 "IP HOSP STAZ-SELF/FAMILY AMT-FAC 99";
label variable IPFMCR99 "IP HOSP STAZ-MEDICARE AMT-FAC 99";
label variable IPFMCD99 "IP HOSP STAZ-MEDICAID AMT-FAC 99";
label variable IPFPRV99 "IP HOSP STAZ-PRIV INS AMT-FAC 99";
label variable IPFVA99 "IP HOSP STAZ-VA AMT-FAC 99";
label variable IPFCHM99 "IP HOSP STAZ-CHAMPUS/CHAMPVA AMT-FAC 99";
label variable IPFOFD99 "IP HOSP STAZ-OTHER FED AMT-FAC 99";
label variable IPFSTL99 "IP HOSP STAZ-OTH ST/LOCAL AMT-FAC 99";
label variable IPFWCP99 "IP HOSP STAZ-WORKERS COMP AMT-FAC 99";
label variable IPFOPR99 "IP HOSP STAZ - OTH PRIVATE AMT-FAC 99";
label variable IPFOPU99 "IP HOSP STAZ - OTH PUBLIC AMT-FAC 99";
label variable IPFOSR99 "IP HOSP STAZ-OT UNCLASS SRCE AMT-FAC 99";
label variable IPDEXP99 "TOTL HOSP STAZ DR EXP 99";
label variable IPDTCH99 "IP HOSP STAY CHARGES - DR 99";
label variable IPDSLF99 "IP HOSP STAZ-SELF/FAMILY AMT-DR 99";
label variable IPDMCR99 "IP HOSP STAZ-MEDICARE AMT- DR 99";
label variable IPDMCD99 "IP HOSP STAZ-MEDICAID AMT-DR 99";
label variable IPDPRV99 "IP HOSP STAZ-PRIV INS AMT- DR 99";
label variable IPDVA99 "IP HOSP STAZ-VA AMT-DR 99";
label variable IPDCHM99 "IP HOSP STAZ-CHAMPUS/CHAMPVA AMT-DR 99";
label variable IPDOFD99 "IP HOSP STAZ-OTHER FED AMT-DR 99";
label variable IPDSTL99 "IP HOSP STAZ-OTH ST/LOCAL AMT-DR 99";
label variable IPDWCP99 "IP HOSP STAZ-WORKERS COMP AMT-DR 99";
label variable IPDOPR99 "IP HOSP STAZ - OTH PRIVATE AMT-DR 99";
label variable IPDOPU99 "IP HOSP STAZ - OTH PUBLIC AMT-DR 99";
label variable IPDOSR99 "IP HOSP STAZ-OT UNCLASS SORCE AMT-DR 99";
label variable IPNGTD99 "# NIGHTS IN HOSP FOR DISCHARGES, 1999";
label variable DVTOT99 "# DENTAL CARE VISITS 99";
label variable DVTTCH99 "TOTAL DENTAL CARE VISIT CHARGES 99";
label variable DVTEXP99 "TOTAL DENTAL CARE EXP 99";
label variable DVTSLF99 "ALL DENTAL CARE -SELF/FAMILY AMT 99";
label variable DVTMCR99 "ALL DENTAL CARE -MEDICARE AMT 99";
label variable DVTMCD99 "ALL DENTAL CARE -MEDICAID AMT 99";
label variable DVTPRV99 "ALL DENTAL CARE -PRIVATE INS AMT 99";
label variable DVTVA99 "ALL DENTAL CARE-VA AMT 99";
label variable DVTCHM99 "ALL DENTAL CARE-CHAMPUS/CHAMPVA AMT 99";
label variable DVTOFD99 "ALL DENTAL CARE -OTHER FEDRL AMT 99";
label variable DVTSTL99 "ALL DENTAL CARE-OTH ST/LOCAL AMT 99";
label variable DVTWCP99 "ALL DENTAL CARE-WORKERS COMP AMT 99";
label variable DVTOPR99 "ALL DENTAL CARE - OTH PRIVATE AMT 99";
label variable DVTOPU99 "ALL DENTAL CARE - OTH PUBLIC AMT 99";
label variable DVTOSR99 "ALL DENT CARE-OT UNCLASS SRCE AMT 99";
label variable DVGEN99 "# GENERAL DENTIST VISITS 99";
label variable DVGTCH99 "GENERAL DENTAL CARE VISIT CHARGES 99";
label variable DVGEXP99 "TOTAL GENERAL DENTIST EXP 99";
label variable DVGSLF99 "GNRL DENTAL VISITS -SELF/FAM AMT 99";
label variable DVGMCR99 "GNRL DENTAL VISITS -MEDICARE AMT 99";
label variable DVGMCD99 "GNRL DENTAL VISITS -MEDICAID AMT 99";
label variable DVGPRV99 "GNRL DENTAL VISITS -PRIVATE INS AMT 99";
label variable DVGVA99 "GNRL DENTAL VISITS -VA AMT 99";
label variable DVGCHM99 "GNRL DENTAL VISITS-CHMPUS/CHMPVA AMT 99";
label variable DVGOFD99 "GNRL DENTAL VISITS- OTHER FED AMT 99";
label variable DVGSTL99 "GNRL DENTAL VISITS - OTH ST/LOCAL AMT 99";
label variable DVGWCP99 "GNRL DENTAL VISITS - WORKERS COMP AMT 99";
label variable DVGOPR99 "GNRL DENTAL VISITS - OTH PRIVATE AMT 99";
label variable DVGOPU99 "GNRL DENTAL VISITS - OTH PUBLIC AMT 99";
label variable DVGOSR99 "GNRL DENT VSTS - OT UNCLASS SRCE AMT 99";
label variable DVORTH99 "# ORTHODONTIST VISITS 99";
label variable DVOTCH99 "ORTHODONTIST VISIT CHARGES 99";
label variable DVOEXP99 "TOTAL ORTHODONTIST EXP 99";
label variable DVOSLF99 "ORTHODONTIST VISITS -SELF/FAMILY AMT 99";
label variable DVOMCR99 "ORTHODONTIST VISITS -MEDICARE AMT 99";
label variable DVOMCD99 "ORTHODONTIST VISITS -MEDICAID AMT 99";
label variable DVOPRV99 "ORTHODONTIST VISITS -PRIVATE INS AMT 99";
label variable DVOVA99 "ORTHODONTIST VISITS-VA AMT 99";
label variable DVOCHM99 "ORTHODONTIST VISITS-CHMPUS/CHMPVA AMT 99";
label variable DVOOFD99 "ORTHODONTIST VISITS-OTHR FED AMT 99";
label variable DVOSTL99 "ORTHODONTIST VISITS-OTHR ST/LOCAL AMT 99";
label variable DVOWCP99 "ORTHODONTIST VISITS-WORKERS COMP AMT 99";
label variable DVOOPR99 "ORTHODONTIST VISITS-OTHR PRIVATE AMT 99";
label variable DVOOPU99 "ORTHODONTIST VISITS-OTHR PUBLIC AMT 99";
label variable DVOOSR99 "ORTHODONT VSTS - OT UNCLASS SRCE AMT 99";
label variable HHTOTD99 "# HOME HEALTH PROVIDER DAYS, 1999";
label variable HHAGD99 "# AGENCY HOME HEALTH PROVIDER DAYS 99";
label variable HHATCH99 "HOME HEALTH AGENCY VISIT CHARGES 99";
label variable HHAEXP99 "TOTAL HOME HEALTH AGENCY EXP 99";
label variable HHASLF99 "HOME HLTH AGENCY -SELF/FAMILY AMT 99";
label variable HHAMCR99 "HOME HLTH AGENCY -MEDICARE AMT 99";
label variable HHAMCD99 "HOME HLTH AGENCY -MEDICAID AMT 99";
label variable HHAPRV99 "HOME HLTH AGENCY -PRIVATE INS AMT 99";
label variable HHAVA99 "HOME HLTH AGENCY-VA AMT 99";
label variable HHACHM99 "HOME HLTH AGENCY-CHAMPUS/CHAMPVA AMT 99";
label variable HHAOFD99 "HOME HLTH AGENCY-OTHER FED AMT 99";
label variable HHASTL99 "HOME HLTH AGENCY-OTHR ST/LOCAL AMT 99";
label variable HHAWCP99 "HOME HLTH AGENCY- WORKERS COMP AMT 99";
label variable HHAOPR99 "HOME HLTH AGENCY - OTH PRIVATE AMT 99";
label variable HHAOPU99 "HOME HLTH AGENCY - OTH PUBLIC AMT 99";
label variable HHAOSR99 "H HLTH AGENCY - OT UNCLASS SRCE AMT 99";
label variable HHINDD99 "# NON-AGENCY HOME HEALTH PROVIDR DAYS 99";
label variable HHNTCH99 "HOME HEALTH NON-AGENCY VISIT CHARGES 99";
label variable HHNEXP99 "TOTAL HOME HEALTH NON-AGNCY EXP 99";
label variable HHNSLF99 "HOME HLTH NON-AGNCY -SELF/FAM AMT 99";
label variable HHNMCR99 "HOME HLTH NON-AGNCY -MEDICARE AMT 99";
label variable HHNMCD99 "HOME HLTH NON-AGNCY -MEDICAID AMT 99";
label variable HHNPRV99 "HOME HLTH NON-AGNCY -PRIV INS AMT 99";
label variable HHNVA99 "HOME HLTH NON-AGNCY-VA AMT 99";
label variable HHNCHM99 "HOME HLTH NON-AGNCY-CHMPUS/CHMPVA AMT 99";
label variable HHNOFD99 "HOME HLTH NON-AGNCY-OTHR FED AMT 99";
label variable HHNSTL99 "HOME HLTH NON-AGNCY-OTHR ST/LOCL AMT 99";
label variable HHNWCP99 "HOME HLTH NON-AGNCY-WORKERS COMP AMT 99";
label variable HHNOPR99 "HOME HLTH NON-AGNCY-OTH PRIVATE AMT 99";
label variable HHNOPU99 "HOME HLTH NON-AGNCY-OTH PUBLIC AMT 99";
label variable HHNOSR99 "H HLTH NON-AGNCY-OT UNCLASS SRCE AMT 99";
label variable HHINFD99 "# INFORMAL HOME HEALTH PROVIDER DAYS 99";
label variable VISEXP99 "TOTAL GLASSES/CONTACT LENS EXP 99";
label variable VISTCH99 "GLASSES/CONTACT LENSES CHARGES 99";
label variable VISSLF99 "GLASSES/CNTCT LENSES -SELF/FAM AMT 99";
label variable VISMCR99 "GLASSES/CNTCT LENSES-MEDICARE AMT 99";
label variable VISMCD99 "GLASSES/CNTCT LENSES-MEDICAID AMT 99";
label variable VISPRV99 "GLASSES/CNTCT LENSES-PRIV INS AMT 99";
label variable VISVA99 "GLASSES/CNTCT LENSES-VA AMT 99";
label variable VISCHM99 "GLASSES/LENSES-CHAMPUS/CHAMPVA AMT 99";
label variable VISOFD99 "GLASSES/CNTCT LENSES-OTHR FED AMT 99";
label variable VISSTL99 "GLASSES/CNTCT LENSES-OTH ST/LOCL AMT 99";
label variable VISWCP99 "GLASSES/CNTCT LENSES-WORKERS COMP AMT 99";
label variable VISOPR99 "GLASSES/CNTCT LENSES-OTH PRIVATE AMT 99";
label variable VISOPU99 "GLASSES/CNTCT LENSES-OTH PUBLIC AMT 99";
label variable VISOSR99 "GLASES/CNTCT LENSE-OT UNCLAS SRCE AMT 99";
label variable OTHTCH99 "OTHER EQUP/SUPPLIES CHARGES 99";
label variable OTHEXP99 "TOT OTHER EQUIP/SPLY (EXCL DIAB) EXP 99";
label variable OTHSLF99 "OTHER EQUP/SUPPLIES -SELF/FAM AMT 99";
label variable OTHMCR99 "OTHER EQUP/SUPPLIES-MEDICARE AMT 99";
label variable OTHMCD99 "OTHER EQUP/SUPPLIES-MEDICAID AMT 99";
label variable OTHPRV99 "OTHER EQUP/SUPPLIES-PRIV INS AMT 99";
label variable OTHVA99 "OTHER EQUP/SUPPLY-VA AMT 99";
label variable OTHCHM99 "OTHER EQUP/SUPPLY-CHAMPUS/CHAMPVA AMT 99";
label variable OTHOFD99 "OTHER EQUP/SUPPLIES-OTHR FEDRL AMT 99";
label variable OTHSTL99 "OTHER EQUP/SUPPLY-OTHR ST/LOCAL AMT 99";
label variable OTHWCP99 "OTHER EQUP/SUPPLY -WORKERS COMP AMT 99";
label variable OTHOPR99 "OTHER EQUP/SUPPLY-OTH PRIVATE AMT 99";
label variable OTHOPU99 "OTHER EQUP/SUPPLY -OTH PUBLIC AMT 99";
label variable OTHOSR99 "OTH EQUP/SUPLY -OT UNCLASS SRCE AMT 99";
label variable RXTOT99 "# PRESC MEDS INCL REFILLS 99";
label variable RXEXP99 "TOTAL RX-EXP 99";
label variable RXSLF99 "TOTAL RX-SELF/FAMILY AMT 99";
label variable RXMCR99 "TOTAL RX--MEDICARE AMT 99";
label variable RXMCD99 "TOTAL RX-MEDICAID AMT 99";
label variable RXPRV99 "TOTAL RX-PRIVATE INS AMT 99";
label variable RXVA99 "TOTAL RX-VA AMT 99";
label variable RXCHM99 "TOTAL RX-CHAMPUS/CHAMPVA AMT 99";
label variable RXOFD99 "TOTAL RX-OTHER FED AMT 99";
label variable RXSTL99 "TOTAL RX-OTHER ST/LOCAL AMT 99";
label variable RXWCP99 "TOTAL RX-WORKERS COMP AMT 99";
label variable RXOPR99 "TOTAL RX - OTH PRIVATE AMT 99";
label variable RXOPU99 "TOTAL RX - OTH PUBLIC AMT 99";
label variable RXOSR99 "TOT RX-OTH UNCLASS SRCE AMT 99";
label variable PERWT99F "FINAL PERSON WEIGHT, 1999";
label variable FAMWT99F "FINAL FAMILY WEIGHT, 1999";
label variable FAMWT99C "POV ADJ FAMILY WGT-CPS FAM ON 12/31/99";
label variable VARSTR99 "VARIANCE ESTIMATION STRATUM - 1999";
label variable VARPSU99 "VARIANCE ESTIMATION PSU - 1999";


*DEFINE VALUE LABELS FOR REPORTS;
label define H380001X
         -1 "-1 INAPPLICABLE"
         -3 "-3 NO DATA IN ROUND"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES"
         2 "2 NO" ;

label define H380002X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES - ACTIVE DUTY"
         2 "2 NO - NOT FT ACTIVE DUTY"
         3 "3 UNDER 16 - INAPPLICABLE"
         4 "4 OVER 59 - INAPPLICABLE" ;

label define H380003X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES - ACTIVE DUTY"
         2 "2 NO - NOT FT ACTIVE DUTY"
         3 "3 UNDER 16 - INAPPLICABLE"
         4 "4 OVER 59 - INAPPLICABLE" ;

label define H380004X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES - ACTIVE DUTY"
         2 "2 NO - NOT FT ACTIVE DUTY"
         3 "3 UNDER 16 - INAPPLICABLE"
         4 "4 OVER 59 - INAPPLICABLE" ;

label define H380005X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES"
         2 "2 NO" ;

label define H380006X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES"
         2 "2 NO" ;

label define H380007X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES"
         2 "2 NO" ;

label define H380008X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES"
         2 "2 NO" ;

label define H380009X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES"
         2 "2 NO" ;

label define H380010X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         99 "99 ASKED, BUT INAPPLICABLE" ;

label define H380011X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 AFDC"
         2 "2 NOT AFDC" ;

label define H380012X
         -1 "-1 INAPPLICABLE"
         -3 "-3 NO DATA IN ROUND"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES"
         2 "2 NO" ;

label define H380013X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES"
         2 "2 NO" ;

label define H380014X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES"
         2 "2 NO" ;

label define H380015X
         1 "1 ORIGINAL RESPONSE USED"
         2 "2 BRACKET CONVERTED"
         3 "3 MISSING VALUES SET TO 0"
         6 "6 UNCONDITIONAL HOTDECK" ;

label define H380016X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H380017X
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H380018X
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H380019X
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H380020X
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H380021X
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H380022X
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H380023X
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H380024X
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H380025X
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H380026X
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H380027X
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H380028X
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H380029X
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H380030X
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H380031X
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H380032X
         -9 "-9 NOT ASCERTAINED"
         0 "0"
         10 "$10" ;

label define H380033X
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H380034X
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H380035X
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H380036X
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H380037X
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H380038X
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H380039X
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H380040X
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H380041X
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H380042X
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H380043X
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H380044X
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H380045X
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H380046X
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H380047X
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H380048X
         -9 "-9 NOT ASCERTAINED"
         0 "0"
         18 "$18" ;

label define H380049X
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H380050X
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H380051X
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H380052X
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H380053X
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H380054X
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H380055X
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H380056X
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H380057X
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H380058X
         -9 "-9 NOT ASCERTAINED"
         0 "0"
         10 "$10" ;

label define H380059X
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H380060X
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H380061X
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H380062X
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H380063X
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H380064X
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H380065X
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H380066X
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H380067X
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H380068X
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H380069X
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H380070X
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H380071X
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H380072X
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H380073X
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H380074X
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H380075X
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H380076X
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H380077X
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H380078X
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H380079X
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H380080X
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H380081X
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H380082X
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H380083X
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H380084X
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H380085X
         -9 "-9 NOT ASCERTAINED"
         0 "0"
         157 "$157" ;

label define H380086X
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H380087X
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H380088X
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H380089X
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H380090X
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H380091X
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H380092X
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H380093X
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H380094X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES"
         2 "2 NO" ;

label define H380095X
         -1 "-1 INAPPLICABLE"
         -3 "-3 NO DATA IN ROUND"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES"
         2 "2 NO" ;

label define H380096X
         -1 "-1 INAPPLICABLE"
         -3 "-3 NO DATA IN ROUND"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 VERY DIFFICULT"
         2 "2 SOMEWHAT DIFFICULT"
         3 "3 NOT TOO DIFFICULT"
         4 "4 NOT AT ALL DIFFICULT" ;

label define H380097X
         -1 "-1 INAPPLICABLE"
         -3 "-3 NO DATA IN ROUND"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 HAVE APPOINTMENT"
         2 "2 JUST WALKS IN"
         3 "3 SOMETIMES APPOINTM,SOMETIMES WALKS IN" ;

label define H380098X
         -1 "-1 INAPPLICABLE"
         -3 "-3 NO DATA IN ROUND"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES"
         2 "2 NO" ;

label define H380099X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED" ;

label define H380100X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED" ;

label define H380101X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED" ;

label define H380102X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 JANUARY"
         10 "10 OCTOBER"
         11 "11 NOVEMBER"
         12 "12 DECEMBER"
         2 "2 FEBRUARY"
         3 "3 MARCH"
         4 "4 APRIL"
         5 "5 MAY"
         6 "6 JUNE"
         7 "7 JULY"
         8 "8 AUGUST"
         9 "9 SEPTEMBER" ;

label define H380103X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 JANUARY"
         10 "10 OCTOBER"
         11 "11 NOVEMBER"
         12 "12 DECEMBER"
         2 "2 FEBRUARY"
         3 "3 MARCH"
         4 "4 APRIL"
         5 "5 MAY"
         6 "6 JUNE"
         7 "7 JULY"
         8 "8 AUGUST"
         9 "9 SEPTEMBER" ;

label define H380104X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 JANUARY"
         10 "10 OCTOBER"
         11 "11 NOVEMBER"
         12 "12 DECEMBER"
         2 "2 FEBRUARY"
         3 "3 MARCH"
         4 "4 APRIL"
         5 "5 MAY"
         6 "6 JUNE"
         7 "7 JULY"
         8 "8 AUGUST"
         9 "9 SEPTEMBER" ;

label define H380105X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1998 "1998 YEAR"
         1999 "1999 YEAR" ;

label define H380106X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1999 "1999 YEAR" ;

label define H380107X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1999 "1999 YEAR"
         2000 "2000 YEAR" ;

label define H380108X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 NO DIFFICULTY"
         2 "2 SOME DIFFICULTY"
         3 "3 A LOT OF DIFFICULTY"
         4 "4 UNABLE TO DO" ;

label define H380109X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 NO DIFFICULTY"
         2 "2 SOME DIFFICULTY"
         3 "3 A LOT OF DIFFICULTY"
         4 "4 UNABLE TO DO" ;

label define H380110X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         95 "95 SCHEDULE CONSISTENTLY VARIES" ;

label define H380111X
         -1 "-1 INAPPLICABLE"
         -2 "-2 DETERMINED IN PREVIOUS ROUND"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         95 "95 SCHEDULE CONSISTENTLY VARIES" ;

label define H380112X
         -1 "-1 INAPPLICABLE"
         -2 "-2 DETERMINED IN PREVIOUS ROUND"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         95 "95 SCHEDULE CONSISTENTLY VARIES" ;

label define H380113X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES"
         2 "2 NO" ;

label define H380114X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 INCORPORATED"
         2 "2 PROPRIETORSHIP"
         3 "3 PARTNERSHIP" ;

label define H380115X
         -1 "-1 INAPPLICABLE"
         -2 "-2 DETERMINED IN PREVIOUS ROUND"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 INCORPORATED"
         2 "2 PROPRIETORSHIP"
         3 "3 PARTNERSHIP" ;

label define H380116X
         -1 "-1 INAPPLICABLE"
         -2 "-2 DETERMINED IN PREVIOUS ROUND"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 INCORPORATED"
         2 "2 PROPRIETORSHIP"
         3 "3 PARTNERSHIP" ;

label define H380117X
         -1 "-1 INAPPLICABLE"
         -3 "-3 NO DATA IN ROUND"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES"
         2 "2 NO" ;

label define H380118X
         1 "1 ORIGINAL RESPONSE USED"
         2 "2 BRACKET CONVERTED"
         3 "3 MISSING VALUES SET TO 0"
         5 "5 CONDITIONAL HOTDECK"
         6 "6 UNCONDITIONAL HOTDECK" ;

label define H380119X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H380120X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES"
         2 "2 NO" ;

label define H380121X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 LIMITED IN ATTENDANCE"
         2 "2 UNABLE TO ATTEND"
         3 "3 NEITHER" ;

label define H380122X
         -1 "-1 INAPPLICABLE"
         -3 "-3 NO DATA IN ROUND"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES"
         2 "2 NO" ;

label define H380123X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H380124X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H380125X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H380126X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H380127X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H380128X
         -1 "-1 INAPPLICABLE"
         -9 "-9 NOT ASCERTAINED"
         1 "1 LEFT PREVIOUS CMJ/HAS CMJ"
         2 "2 CHANGED CURRENT MAIN JOB"
         3 "3 LEFT PREVIOUS CMJ/DOES NOT HAVE CMJ"
         4 "4 PREVIOUS CMJ CONTINUES; NO JOB CHANGE" ;

label define H380129X
         -1 "-1 INAPPLICABLE"
         -9 "-9 NOT ASCERTAINED"
         1 "1 LEFT PREVIOUS CMJ/HAS CMJ"
         2 "2 CHANGED CURRENT MAIN JOB"
         3 "3 LEFT PREVIOUS CMJ/DOES NOT HAVE CMJ"
         4 "4 PREVIOUS CMJ CONTINUES; NO JOB CHANGE" ;

label define H380130X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H380131X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H380132X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H380133X
         -1 "-1 INAPPLICABLE"
         -3 "-3 NO DATA IN ROUND"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES"
         2 "2 NO" ;

label define H380134X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H380135X
         -1 "-1 INAPPLICABLE"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES"
         2 "2 NO" ;

label define H380136X
         1 "1 ORIGINAL RESPONSE USED"
         2 "2 BRACKET CONVERTED"
         3 "3 MISSING VALUES SET TO 0"
         6 "6 UNCONDITIONAL HOTDECK" ;

label define H380137X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H380138X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H380139X
         -1 "-1 INAPPLICABLE"
         -3 "-3 NO DATA IN ROUND"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES"
         2 "2 NO" ;

label define H380140X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H380141X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H380142X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES"
         2 "2 NO" ;

label define H380143X
         -1 "-1 INAPPLICABLE"
         -2 "-2 DETERMINED IN PREVIOUS ROUND"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES"
         2 "2 NO" ;

label define H380144X
         -1 "-1 INAPPLICABLE"
         -2 "-2 DETERMINED IN PREVIOUS ROUND"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES"
         2 "2 NO" ;

label define H380145X
         -1 "-1 INAPPLICABLE"
         -3 "-3 NO DATA IN ROUND"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES"
         2 "2 NO" ;

label define H380146X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H380147X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 AGRICULTURE, FORESTRY, FISHERIES"
         10 "10 ENTERTAINMENT AND RECREATION"
         11 "11 PROFESSIONAL SERVICES"
         12 "12 PUBLIC ADMINISTRATION"
         13 "13 UNCLASSIFIABLE INDUSTRY"
         14 "14 ACTIVE MILITARY"
         2 "2 MINING"
         3 "3 CONSTRUCTION"
         4 "4 MANUFACTURING"
         5 "5 TRANSPORTATION/COMMUNICATION/UTILITIES"
         6 "6 SALES"
         7 "7 FINANCE, INSURANCE, REAL ESTATE"
         8 "8 REPAIR SERVICES"
         9 "9 PERSONAL SERVICES" ;

label define H380148X
         -1 "-1 INAPPLICABLE"
         -2 "-2 DETERMINED IN PREVIOUS ROUND"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 AGRICULTURE, FORESTRY, FISHERIES"
         10 "10 ENTERTAINMENT AND RECREATION"
         11 "11 PROFESSIONAL SERVICES"
         12 "12 PUBLIC ADMINISTRATION"
         13 "13 UNCLASSIFIABLE INDUSTRY"
         14 "14 ACTIVE MILITARY"
         2 "2 MINING"
         3 "3 CONSTRUCTION"
         4 "4 MANUFACTURING"
         5 "5 TRANSPORATION/COMMUNICATION/UTILITIES"
         6 "6 SALES"
         7 "7 FINANCE, INSURANCE, REAL ESTATE"
         8 "8 REPAIR SERVICES"
         9 "9 PERSONAL SERVICES" ;

label define H380149X
         -1 "-1 INAPPLICABLE"
         -2 "-2 DETERMINED IN PREVIOUS ROUND"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 AGRICULTURE, FORESTRY, FISHERIES"
         10 "10 ENTERTAINMENT AND RECREATION"
         11 "11 PROFESSIONAL SERVICES"
         12 "12 PUBLIC ADMINISTRATION"
         13 "13 UNCLASSIFIABLE INDUSTRY"
         14 "14 ACTIVE MILITARY"
         2 "2 MINING"
         3 "3 CONSTRUCTION"
         4 "4 MANUFACTURING"
         5 "5 TRANSPORTATION/COMMUNICATION/UTILITIES"
         6 "6 SALES"
         7 "7 FINANCE, INSURANCE, REAL ESTATE"
         8 "8 REPAIR SERVICES"
         9 "9 PERSONAL SERVICES" ;

label define H380150X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES"
         2 "2 NO" ;

label define H380151X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES"
         2 "2 NO"
         3 "3 NOT APPLICABLE" ;

label define H380152X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 PROFESSIONAL, TECHNICAL AND KINDRED"
         10 "10 FARM OWNERS AND MANAGERS"
         11 "11 FARM LABORERS AND FOREMEN"
         12 "12 UNCLASSIFIABLE OCCUPATION"
         13 "13 ACTIVE MILITARY"
         14 "14 LAST WORKED PRIOR TO 1984"
         2 "2 MANAGERIAL AND ADMINISTRATIVE"
         3 "3 SALES WORKERS"
         4 "4 CLERICAL AND KINDRED WORKERS"
         5 "5 CRAFTSMEN AND FOREMEN"
         6 "6 OPERATIVES"
         7 "7 TRANSPORT OPERATIVES"
         8 "8 SERVICE WORKERS"
         9 "9 LABORERS, NOT FARMING" ;

label define H380153X
         -1 "-1 INAPPLICABLE"
         -2 "-2 DETERMINED IN PREVIOUS ROUND"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 PROFESSIONAL, TECHNICAL AND KINDRED"
         10 "10 FARM OWNERS AND MANAGERS"
         11 "11 FARM LABORERS AND FOREMEN"
         12 "12 UNCLASSIFIABLE OCCUPATION"
         13 "13 ACTIVE MILITARY"
         14 "14 LAST WORKED PRIOR TO 1984"
         2 "2 MANAGERIAL AND ADMINISTRATIVE"
         3 "3 SALES WORKERS"
         4 "4 CLERICAL AND KINDRED WORKERS"
         5 "5 CRAFTSMEN AND FOREMEN"
         6 "6 OPERATIVES"
         7 "7 TRANSPORT OPERATIVES"
         8 "8 SERVICE WORKERS"
         9 "9 LABORERS, NOT FARMING" ;

label define H380154X
         -1 "-1 INAPPLICABLE"
         -2 "-2 DETERMINED IN PREVIOUS ROUND"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 PROFESSIONAL, TECHNICAL AND KINDRED"
         10 "10 FARM OWNERS AND MANAGERS"
         11 "11 FARM LABORERS AND FOREMEN"
         12 "12 UNCLASSIFIABLE OCCUPATION"
         13 "13 ACTIVE MILITARY"
         14 "14 LAST WORKED PRIOR TO 1984"
         2 "2 MANAGERIAL AND ADMINISTRATIVE"
         3 "3 SALES WORKERS"
         4 "4 CLERICAL AND KINDRED WORKERS"
         5 "5 CRAFTSMEN AND FOREMEN"
         6 "6 OPERATIVES"
         7 "7 TRANSPORT OPERATIVES"
         8 "8 SERVICE WORKERS"
         9 "9 LABORERS, NOT FARMING" ;

label define H380155X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES"
         2 "2 NO" ;

label define H380156X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES"
         2 "2 NO" ;

label define H380157X
         -1 "-1 INAPPLICABLE"
         -3 "-3 NO DATA IN ROUND"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES"
         2 "2 NO" ;

label define H380158X
         -1 "-1 INAPPLICABLE"
         -3 "-3 NO DATA IN ROUND"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES"
         2 "2 NO" ;

label define H380159X
         1 "1 ORIGINAL RESPONSE USED"
         2 "2 BRACKET CONVERTED"
         3 "3 MISSING VALUES SET TO 0"
         6 "6 UNCONDITIONAL HOTDECK" ;

label define H380160X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         99 "99 ASKED, BUT INAPPLICABLE" ;

label define H380161X
         -1 "-1 INAPPLICABLE"
         -9 "-9 NOT ASCERTAINED" ;

label define H380162X
         -1 "-1 INAPPLICABLE"
         -9 "-9 NOT ASCERTAINED" ;

label define H380163X
         -1 "-1 INAPPLICABLE"
         -9 "-9 NOT ASCERTAINED" ;

label define H380164X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES"
         2 "2 NO" ;

label define H380165X
         -1 "-1 IN APPLICABLE"
         -3 "-3 NO DATA IN ROUND"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H380166X
         -1 "-1 IN APPLICABLE"
         -3 "-3 NO DATA IN ROUND"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H380167X
         -1 "-1 IN APPLICABLE"
         -3 "-3 NO DATA IN ROUND"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H380168X
         -1 "-1 IN APPLICABLE"
         -3 "-3 NO DATA IN ROUND"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H380169X
         -1 "-1 IN APPLICABLE"
         -3 "-3 NO DATA IN ROUND"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H380170X
         -1 "-1 IN APPLICABLE"
         -3 "-3 NO DATA IN ROUND"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H380171X
         -1 "-1 IN APPLICABLE"
         -3 "-3 NO DATA IN ROUND"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H380172X
         -1 "-1 IN APPLICABLE"
         -3 "-3 NO DATA IN ROUND"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H380173X
         -1 "-1 IN APPLICABLE"
         -3 "-3 NO DATA IN ROUND"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H380174X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES"
         2 "2 NO" ;

label define H380175X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 ITEMIZED DEDUCTIONS"
         2 "2 STANDARD DEDUCTIONS" ;

label define H380176X
         -1 "-1 INAPPLICABLE"
         -3 "-3 NO DATA IN ROUND"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES"
         2 "2 NO" ;

label define H380177X
         -1 "-1 INAPPLICABLE"
         -3 "-3 NO DATA IN ROUND"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES"
         2 "2 NO" ;

label define H380178X
         -1 "-1 INAPPLICABLE"
         -3 "-3 NO DATA IN ROUND"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES"
         2 "2 NO" ;

label define H380179X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES" ;

label define H380180X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES"
         2 "2 NO"
         3 "3 UNDER 16 - INAPPLICABLE"
         4 "4 NOW ACTIVE DUTY" ;

label define H380181X
         -1 "-1 INAPPLICABLE"
         -3 "-3 NO DATA IN ROUND"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES"
         2 "2 NO" ;

label define H380182X
         -1 "-1 INAPPLICABLE"
         -3 "-3 NO DATA IN ROUND"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES"
         2 "2 NO" ;

label define H380183X
         -1 "-1 INAPPLICABLE"
         -9 "-9 NOT ASCERTAINED"
         1 "1 DISAVOWS INSURANCE THROUGH CMJ"
         2 "2 DOES NOT DISAVOW INSURANCE THROUGH CMJ" ;

label define H380184X
         -1 "-1 INAPPLICABLE"
         -9 "-9 NOT ASCERTAINED"
         1 "1 DISAVOWS INSURANCE THROUGH CMJ"
         2 "2 DOES NOT DISAVOW INSURANCE THROUGH CMJ" ;

label define H380185X
         -1 "-1 INAPPLICABLE"
         -9 "-9 NOT ASCERTAINED"
         1 "1 DISAVOWS INSURANCE THROUGH CMJ"
         2 "2 DOES NOT DISAVOW INSURANCE THROUGH CMJ" ;

label define H380186X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H380187X
         1 "1 ORIGINAL RESPONSE USED"
         2 "2 BRACKET CONVERTED"
         3 "3 MISSING VALUES SET TO 0"
         4 "4 WEEKS WORKED/EARNINGS USED(WAGEIMP ONLY)"
         5 "5 CONDITIONAL HOTDECK"
         6 "6 UNCONDITIONAL HOTDECK"
         7 "7 EDITED USING NHIS DATA" ;

label define H380188X
         -1 "-1 INAPPLICABLE"
         -3 "-3 NO DATA IN ROUND"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES"
         2 "2 NO" ;

label define H380189X
         -1 "-1 INAPPLICABLE"
         -3 "-3 NO DATA IN ROUND"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES"
         2 "2 NO" ;

label define H380190X
         -1 "-1 INAPPLICABLE"
         -3 "-3 NO DATA IN ROUND"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES"
         2 "2 NO" ;

label define H380191X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 JANUARY"
         10 "10 OCTOBER"
         11 "11 NOVEMBER"
         12 "12 DECEMBER"
         2 "2 FEBRUARY"
         3 "3 MARCH"
         4 "4 APRIL"
         5 "5 MAY"
         6 "6 JUNE"
         7 "7 JULY"
         8 "8 AUGUST"
         9 "9 SEPTEMBER" ;

label define H380192X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED" ;

label define H380193X
         -1 "-1 INAPPLICABLE"
         -9 "-9 NOT ASCERTAINED"
         1 "1 DEPS IN RU"
         2 "2 DEPS IN AND OUT OF RU"
         3 "3 DEPS OUT OF RU" ;

label define H380194X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         0 "0 NO DEPENDENTS OUTSIDE RU"
         1 "1 ONE DEPENDENT OUTSIDE RU"
         2 "2 TWO DEPENDENTS OUTSIDE RU"
         3 "3 THREE DEPENDENTS OUTSIDE RU" ;

label define H380195X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES"
         2 "2 NO" ;

label define H380196X
         0 "0"
         158 "$158" ;

label define H380197X
         0 "0"
         3516 "$3516" ;

label define H380198X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         0 "0 NEVER ATTENDED SCHOOL/KINDERGARTEN"
         12 "12 GRADE 12"
         13 "13 1 YEAR COLLEGE"
         14 "14 2 YEARS COLLEGE"
         15 "15 3 YEARS COLLEGE"
         16 "16 4 YEARS COLLEGE"
         17 "17 5+ YEARS COLLEGE" ;

label define H380199X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES"
         2 "2 NO"
         3 "3 NOT APPLICABLE" ;

label define H380200X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES"
         2 "2 NO"
         3 "3 NOT APPLICABLE" ;

label define H380201X
         1 "1 PERSON IS ELIGIBLE"
         2 "2 PERSON IS IN NON-RESPONDING RU"
         3 "3 PERSON IS NOT ELIGIBLE"
         4 "4 PERSON IS NOT IN AN RU" ;

label define H380202X
         1 "1 PERSON IS ELIGIBLE"
         2 "2 PERSON IS IN NON-RESPONDING RU"
         3 "3 PERSON IS NOT ELIGIBLE"
         4 "4 PERSON IS NOT IN AN RU" ;

label define H380203X
         1 "1 PERSON IS ELIGIBLE"
         2 "2 PERSON IS IN NON-RESPONDING RU"
         3 "3 PERSON IS NOT ELIGIBLE"
         4 "4 PERSON IS NOT IN AN RU" ;

label define H380204X
         1 "1 PERSON IS ELIGIBLE"
         2 "2 PERSON IS IN NON-RESPONDING RU"
         3 "3 PERSON IS NOT ELIGIBLE"
         4 "4 PERSON IS NOT IN AN RU" ;

label define H380205X
         1 "1 PERSON IS ELIGIBLE"
         2 "2 NOT ELIG/NOT LINKED TO RESPONDING RU" ;

label define H380206X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 EMPLOYED AT RD 3/1 INT DATE"
         2 "2 JOB TO RETURN TO AT RD 3/1 INT DATE"
         3 "3 JOB DURING RD 3/1 REF PERIOD"
         4 "4 NOT EMPLOYED DURING RD 3/1" ;

label define H380207X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 EMPLOYED AT RD 4/2 INT DATE"
         2 "2 JOB TO RETURN TO AT RD 4/2 INT DATE"
         3 "3 JOB DURING RD 4/2 REF PERIOD"
         4 "4 NOT EMPLOYED DURING RD 4/2" ;

label define H380208X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 EMPLOYED AT RD 5/3 INT DATE"
         2 "2 JOB TO RETURN TO AT RD 5/3 INT DATE"
         3 "3 JOB DURING RD 5/3 REF PERIOD"
         4 "4 NOT EMPLOYED DURING RD 5/3" ;

label define H380209X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED" ;

label define H380210X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED" ;

label define H380211X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED" ;

label define H380212X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED" ;

label define H380213X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 JANUARY"
         10 "10 OCTOBER"
         11 "11 NOVEMBER"
         12 "12 DECEMBER"
         2 "2 FEBRUARY"
         3 "3 MARCH"
         4 "4 APRIL"
         5 "5 MAY"
         6 "6 JUNE"
         7 "7 JULY"
         8 "8 AUGUST"
         9 "9 SEPTEMBER" ;

label define H380214X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 JANUARY"
         10 "10 OCTOBER"
         11 "11 NOVEMBER"
         12 "12 DECEMBER"
         2 "2 FEBRUARY"
         3 "3 MARCH"
         4 "4 APRIL"
         5 "5 MAY"
         6 "6 JUNE"
         7 "7 JULY"
         8 "8 AUGUST"
         9 "9 SEPTEMBER" ;

label define H380215X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 JANUARY"
         10 "10 OCTOBER"
         11 "11 NOVEMBER"
         12 "12 DECEMBER"
         2 "2 FEBRUARY"
         3 "3 MARCH"
         4 "4 APRIL"
         5 "5 MAY"
         6 "6 JUNE"
         7 "7 JULY"
         8 "8 AUGUST"
         9 "9 SEPTEMBER" ;

label define H380216X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 JANUARY"
         10 "10 OCTOBER"
         11 "11 NOVEMBER"
         12 "12 DECEMBER"
         2 "2 FEBRUARY"
         3 "3 MARCH"
         4 "4 APRIL"
         5 "5 MAY"
         6 "6 JUNE"
         7 "7 JULY"
         8 "8 AUGUST"
         9 "9 SEPTEMBER" ;

label define H380217X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1999 "1999 YEAR" ;

label define H380218X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1999 "1999 YEAR" ;

label define H380219X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1999 "1999 YEAR"
         2000 "2000 YEAR" ;

label define H380220X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1999 "1999 YEAR" ;

label define H380221X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         95 "95 SCHEDULE CONSISTENTLY VARIES" ;

label define H380222X
         -1 "-1 INAPPLICABLE"
         -2 "-2 DETERMINED IN PREVIOUS ROUND"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         95 "95 SCHEDULE CONSISTENTLY VARIES" ;

label define H380223X
         -1 "-1 INAPPLICABLE"
         -2 "-2 DETERMINED IN PREVIOUS ROUND"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         95 "95 SCHEDULE CONSISTENTLY VARIES" ;

label define H380224X
         -1 "-1 INAPPLICABLE"
         -3 "-3 NO DATA IN ROUND"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES"
         2 "2 NO" ;

label define H380225X
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H380226X
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H380227X
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H380228X
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H380229X
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H380230X
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H380231X
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H380232X
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H380233X
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H380234X
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H380235X
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H380236X
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H380237X
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H380238X
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H380239X
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H380240X
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H380241X
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H380242X
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H380243X
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H380244X
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H380245X
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H380246X
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H380247X
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H380248X
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H380249X
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H380250X
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H380251X
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H380252X
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H380253X
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H380254X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES"
         2 "2 NO" ;

label define H380255X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES"
         2 "2 NO" ;

label define H380256X
         -1 "-1 INAPPLICABLE"
         -3 "-3 NO DATA IN ROUND"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES"
         2 "2 NO" ;

label define H380257X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 SET"
         2 "2 NOT SET" ;

label define H380258X
         -1 "-1 INAPPLICABLE"
         0 "0 NOT A REFERENCE PERSON"
         1 "1 REFERENCE PERSON" ;

label define H380259X
         -1 "-1 INAPPLICABLE"
         1 "1 PERSON"
         10 "10 PERSONS"
         11 "11 PERSONS"
         12 "12 PERSONS"
         13 "13 PERSONS"
         14 "14 PERSONS"
         17 "17 PERSONS"
         2 "2 PERSONS"
         3 "3 PERSONS"
         4 "4 PERSONS"
         5 "5 PERSONS"
         6 "6 PERSONS"
         7 "7 PERSONS"
         8 "8 PERSONS"
         9 "9 PERSONS" ;

label define H380260X
         -1 "-1 INAPPLICABLE"
         1 "1 PERSON"
         10 "10 PERSONS"
         11 "11 PERSONS"
         12 "12 PERSONS"
         13 "13 PERSONS"
         14 "14 PERSONS"
         17 "17 PERSONS"
         2 "2 PERSONS"
         3 "3 PERSONS"
         4 "4 PERSONS"
         5 "5 PERSONS"
         6 "6 PERSONS"
         7 "7 PERSONS"
         8 "8 PERSONS"
         9 "9 PERSONS" ;

label define H380261X
         -1 "-1 INAPPLICABLE"
         1 "1 PERSON"
         10 "10 PERSONS"
         11 "11 PERSONS"
         12 "12 PERSONS"
         13 "13 PERSONS"
         14 "14 PERSONS"
         18 "18 PERSONS"
         2 "2 PERSONS"
         3 "3 PERSONS"
         4 "4 PERSONS"
         5 "5 PERSONS"
         6 "6 PERSONS"
         7 "7 PERSONS"
         8 "8 PERSONS"
         9 "9 PERSONS" ;

label define H380262X
         -1 "-1 INAPPLICABLE"
         1 "1 PERSON"
         10 "10 PERSONS"
         11 "11 PERSONS"
         12 "12 PERSONS"
         13 "13 PERSONS"
         14 "14 PERSONS"
         18 "18 PERSONS"
         2 "2 PERSONS"
         3 "3 PERSONS"
         4 "4 PERSONS"
         5 "5 PERSONS"
         6 "6 PERSONS"
         7 "7 PERSONS"
         8 "8 PERSONS"
         9 "9 PERSONS" ;

label define H380263X
         1 "1 ORIGINAL RESPONSE USED"
         2 "2 BRACKET CONVERTED"
         3 "3 MISSING VALUES SET TO 0"
         5 "5 CONDITIONAL HOTDECK"
         6 "6 UNCONDITIONAL HOTDECK" ;

label define H380264X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H380265X
         -1 "-1 INAPP, NOT MEM OF 12/31 FAMILY"
         0 "0 NOT A REFERENCE PERSON"
         1 "1 REFERENCE PERSON" ;

label define H380266X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES"
         2 "2 NO" ;

label define H380267X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 PRIMARY FILER"
         2 "2 SECONDARY FILER" ;

label define H380268X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 SINGLE"
         2 "2 MARRIED FILING JOINT RETURN"
         3 "3 MARRIED FILING SEPARATELY"
         4 "4 HEAD OF HOUSEHOLD W/ QUALIFYING PERSON"
         5 "5 QUALIFYING WIDOWER W/ DEPENDENT" ;

label define H380269X
         -1 "-1 INAPPLICABLE"
         0 "0 NONRESPONDING 12/31 FAMILY"
         1 "1 RESPONDING 12/31 FAMILY" ;

label define H380270X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 NO DIFFICULTY"
         2 "2 SOME DIFFICULTY"
         3 "3 A LOT OF DIFFICULTY"
         4 "4 UNABLE TO DO" ;

label define H380271X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 NO DIFFICULTY"
         2 "2 SOME DIFFICULTY"
         3 "3 A LOT OF DIFFICULTY"
         4 "4 UNABLE TO DO" ;

label define H380272X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H380273X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         12 "12 FULL YEAR" ;

label define H380274X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES"
         2 "2 NO" ;

label define H380275X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H380276X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 FULL-TIME"
         2 "2 PART-TIME"
         3 "3 NOT A STUDENT" ;

label define H380277X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 FULL-TIME"
         2 "2 PART-TIME"
         3 "3 NOT A STUDENT" ;

label define H380278X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 FULL-TIME"
         2 "2 PART-TIME"
         3 "3 NOT A STUDENT" ;

label define H380279X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 FULL-TIME"
         2 "2 PART-TIME"
         3 "3 NOT A STUDENT" ;

label define H380280X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         0 "0 NO FY FAM. WEIGHT & NO PERS WEIGHT"
         1 "1 FY RESP. FAM. PRESENT ON 12-31-99, K/I"
         2 "2 FY RESP. FAM. NOT PRES 12-31-99, K/I"
         3 "3 FY RESP. FAM. NOT PRES 12-31 NO K/I"
         4 "4 NO FY RESP. FAM. WGT BUT HAS PERS WGT" ;

label define H380281X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 DEFINITELY FALSE"
         2 "2 MOSTLY FALSE"
         3 "3 MOSTLY TRUE"
         4 "4 DEFINITELY TRUE" ;

label define H380282X
         -1 "-1 INAPPLICABLE"
         -3 "-3 NO DATA IN ROUND"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 DRIVE/IS DRIVEN"
         2 "2 TAXI,BUS,TRAIN,OTHER PUBLIC TRANSPORT"
         3 "3 WALKS"
         91 "91 OTHER WAY" ;

label define H380283X
         -1 "-1 INAPPLICABLE"
         -3 "-3 NO DATA IN ROUND"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES"
         2 "2 NO" ;

label define H380284X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         99 "99 ASKED, BUT INAPPLICABLE" ;

label define H380285X
         -1 "-1 INAPPLICABLE"
         -3 "-3 NO DATA IN ROUND"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 VERY SATISFIED"
         2 "2 SOMEWHAT SATISFIED"
         3 "3 NOT TOO SATISFIED"
         4 "4 NOT AT ALL SATISFIED" ;

label define H380286X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES"
         2 "2 NO" ;

label define H380287X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES"
         2 "2 NO" ;

label define H380288X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES"
         2 "2 NO" ;

label define H380289X
         -1 "-1 INAPPLICABLE"
         -9 "-9 NOT ASCERTAINED"
         1 "1 NO DIFFICULTY"
         2 "2 SLIGHT IMPAIRMENT"
         3 "3 MODERATE IMPAIRMENT"
         4 "4 MAJOR IMPAIRMENT"
         5 "5 DEAF" ;

label define H380290X
         -1 "-1 INAPPLICABLE"
         -3 "-3 NO DATA IN ROUND"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES"
         2 "2 NO" ;

label define H380291X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES"
         2 "2 NO" ;

label define H380292X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES"
         2 "2 NO" ;

label define H380293X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES"
         2 "2 NO" ;

label define H380294X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES"
         2 "2 NO" ;

label define H380295X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES"
         2 "2 NO" ;

label define H380296X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED" ;

label define H380297X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED" ;

label define H380298X
         -9 "-9 NOT ASCERTAINED"
         0 "0"
         195 "$195" ;

label define H380299X
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H380300X
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H380301X
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H380302X
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H380303X
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H380304X
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H380305X
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H380306X
         -9 "-9 NOT ASCERTAINED"
         0 "0"
         160 "$160" ;

label define H380307X
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H380308X
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H380309X
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H380310X
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H380311X
         -9 "-9 NOT ASCERTAINED"
         0 "0"
         319 "$319" ;

label define H380312X
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H380313X
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H380314X
         -9 "-9  NOT ASCERTAINED"
         0 "0" ;

label define H380315X
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H380316X
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H380317X
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H380318X
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H380319X
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H380320X
         -9 "-9 NOT ASCERTAINED"
         0 "0"
         25 "$25" ;

label define H380321X
         -9 "-9 NOT ASCERTAINED"
         0 "0"
         77 "$77" ;

label define H380322X
         -9 "-9 NOT ASCERTAINED"
         0 "0"
         900 "$900" ;

label define H380323X
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H380324X
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H380325X
         -9 "-9 NOT ASCERTAINED"
         0 "0"
         4650 "$4650" ;

label define H380326X
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H380327X
         -9 "-9 NOT ASCERTAINED"
         0 "0"
         1500 "$1500" ;

label define H380328X
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H380329X
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H380330X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 NO DEGREE"
         2 "2 GED"
         3 "3 HIGH SCHOOL DIPLOMA"
         4 "4 BACHELOR'S DEGREE"
         5 "5 MASTER'S DEGREE"
         6 "6 DOCTORATE DEGREE"
         7 "7 OTHER DEGREE"
         8 "8 UNDER 16-INAPPLICABLE" ;

label define H380331X
         1 "1 HISPANIC"
         2 "2 NOT HISPANIC" ;

label define H380332X
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 PUERTO RICAN"
         2 "2 CUBAN"
         3 "3 MEXICAN/MEXICAN AMERI/MEXICANO/CHICANO"
         4 "4 OTHER LATIN AMERICAN/OTHER SPANISH"
         5 "5 NON-HISPANIC" ;

label define H380333X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 DEFINITELY FALSE"
         2 "2 MOSTLY FALSE"
         3 "3 MOSTLY TRUE"
         4 "4 DEFINITELY TRUE" ;

label define H380334X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         99 "99 ASKED, BUT INAPPLICABLE" ;

label define H380335X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED" ;

label define H380336X
         -1 "-1 INAPPLICABLE"
         -2 "-2 DETERMINED IN PREVIOUS ROUND"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED" ;

label define H380337X
         -1 "-1 INAPPLICABLE"
         -2 "-2 DETERMINED IN PREVIOUS ROUND"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED" ;

label define H380338X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H380339X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H380340X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H380341X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H380342X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H380343X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H380344X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H380345X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H380346X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H380347X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H380348X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H380349X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H380350X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H380351X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H380352X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H380353X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H380354X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H380355X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H380356X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H380357X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H380358X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H380359X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H380360X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H380361X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H380362X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H380363X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H380364X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H380365X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H380366X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H380367X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H380368X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H380369X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H380370X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H380371X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H380372X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H380373X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H380374X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H380375X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H380376X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H380377X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H380378X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H380379X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H380380X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H380381X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H380382X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H380383X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H380384X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H380385X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H380386X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H380387X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H380388X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H380389X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H380390X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H380391X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H380392X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H380393X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H380394X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H380395X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H380396X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H380397X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H380398X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H380399X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H380400X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H380401X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H380402X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H380403X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H380404X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H380405X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H380406X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H380407X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H380408X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H380409X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H380410X
         -1 "-1 INAPPLICABLE"
         -9 "-9 UNKNOWN (NOT IMPUTED)"
         1 "1 IMPUTED USING RANGE ESTIMATE"
         2 "2 IMPUTED WITHOUT RANGE ESTIMATE"
         3 "3 NO CALCULATION: HOURLY WAGE PROVIDED"
         4 "4 CALCULATED FROM SALARY"
         5 "5 CALCULATED FROM PAID BY DAY"
         6 "6 CALCULATED FROM PIECEWORK/JOB/MILE"
         7 "7 CALCULATED FROM COMMISSIONS"
         8 "8 CALCULATED FROM BONUS" ;

label define H380411X
         -1 "-1 INAPPLICABLE"
         -2 "-2 DETERMINED IN PREVIOUS ROUND"
         -9 "-9 UNKNOWN (NOT IMPUTED)"
         1 "1 IMPUTED USING RANGE ESTIMATE"
         2 "2 IMPUTED WITHOUT RANGE ESTIMATE"
         3 "3 NO CALCULATION: HOURLY WAGE PROVIDED"
         4 "4 CALCULATED FROM SALARY"
         5 "5 CALCULATED FROM PAID BY DAY"
         6 "6 CALCULATED FROM PIECEWORK/JOB/MILE"
         7 "7 CALCULATED FROM COMMISSIONS"
         8 "8 CALCULATED FROM BONUS" ;

label define H380412X
         -1 "-1 INAPPLICABLE"
         -2 "-2 DETERMINED IN PREVIOUS ROUND"
         -9 "-9 UNKNOWN (NOT IMPUTED)"
         1 "1 IMPUTED USING RANGE ESTIMATE"
         2 "2 IMPUTED WITHOUT RANGE ESTIMATE"
         3 "3 NO CALCULATION: HOURLY WAGE PROVIDED"
         4 "4 CALCULATED FROM SALARY"
         5 "5 CALCULATED FROM PAID BY DAY"
         6 "6 CALCULATED FROM PIECEWORK/JOB/MILE"
         7 "7 CALCULATED FROM COMMISSIONS"
         8 "8 CALCULATED FROM BONUS" ;

label define H380413X
         -1 "-1 INAPPLICABLE"
         -10 "-10 HOURLY WAGE >= $52.88"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED" ;

label define H380414X
         -1 "-1 INAPPLICABLE"
         -10 "-10 HOURLY WAGE >= $52.88"
         -2 "-2 DETERMINED IN PREVIOUS ROUND"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED" ;

label define H380415X
         -1 "-1 INAPPLICABLE"
         -10 "-10 HOURLY WAGE >= $52.88"
         -2 "-2 DETERMINED IN PREVIOUS ROUND"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED" ;

label define H380416X
         0 "0 NO"
         1 "1 YES" ;

label define H380417X
         0 "0 NO"
         1 "1 YES" ;

label define H380418X
         0 "0 NO"
         1 "1 YES" ;

label define H380419X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES"
         2 "2 NO" ;

label define H380420X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES"
         2 "2 NO" ;

label define H380421X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES"
         2 "2 NO" ;

label define H380422X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES"
         2 "2 NO" ;

label define H380423X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES"
         2 "2 NO" ;

label define H380424X
         0 "0 NON-RESPONSE"
         1 "1 YES"
         2 "2 NO" ;

label define H380425X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H380426X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H380427X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         0 "0 NOT IN-SCOPE - NOT RESP/NOT IN AN RU"
         1 "1 IN-SCOPE ON 12/31/1999"
         2 "2 NOT IN-SCOPE ON 12/31/1999" ;

label define H380428X
         0 "0 INCOR LISTED/OUT-OF-SCOPE PRIOR 1/1/99"
         1 "1 INSCOPE FOR WHOLE REFERENCE PERIOD"
         2 "2 INSCOPE AT START OF REF PER, NOT END"
         3 "3 NOT INSCOPE STRT REF PER, INSCOPE END"
         4 "4 INSCOPE REF PER, BUT NOT START NOR END"
         5 "5 MEM OF RU BUT OUT-OF-SCOPE ALL REF PER"
         6 "6 OUT-OF-SCOPE IN RU DURING THIS ROUND"
         7 "7 NOT IN RU, JOINED IN LATER ROUND"
         8 "8 RU NON-RESPONSE"
         9 "9 NON-KEY, NOT IN RU, PREVIOUS RU MEMBER" ;

label define H380429X
         0 "0 INCOR LISTED/OUT-OF-SCOPE PRIOR 1/1/99"
         1 "1 INSCOPE FOR WHOLE REFERENCE PERIOD"
         2 "2 INSCOPE AT START OF REF PER, NOT END"
         3 "3 NOT INSCOPE STRT REF PER, INSCOPE END"
         4 "4 INSCOPE REF PER, BUT NOT START NOR END"
         5 "5 MEM OF RU BUT OUT-OF-SCOPE ALL REF PER"
         6 "6 OUT-OF-SCOPE IN RU DURING THIS ROUND"
         7 "7 NOT IN RU, JOINED IN LATER ROUND"
         8 "8 RU NON-RESPONSE"
         9 "9 NON-KEY, NOT IN RU, PREVIOUS RU MEMBER" ;

label define H380430X
         0 "0 INCOR LISTED/OUT-OF-SCOPE PRIOR 1/1/99"
         1 "1 INSCOPE FOR WHOLE REFERENCE PERIOD"
         2 "2 INSCOPE AT START OF REF PER, NOT END"
         3 "3 NOT INSCOPE STRT REF PER, INSCOPE END"
         4 "4 INSCOPE REF PER, BUT NOT START NOR END"
         5 "5 MEM OF RU BUT OUT-OF-SCOPE ALL REF PER"
         6 "6 OUT-OF-SCOPE IN RU DURING THIS ROUND"
         7 "7 NOT IN RU, JOINED IN LATER ROUND"
         8 "8 RU NON-RESPONSE"
         9 "9 NON-KEY, NOT IN RU, PREVIOUS RU MEMBER" ;

label define H380431X
         0 "0 INCOR LISTED/OUT-OF-SCOPE PRIOR 1/1/99"
         1 "1 INSCOPE FOR WHOLE REFERENCE PERIOD"
         2 "2 INSCOPE AT START OF REF PER, NOT END"
         3 "3 NOT INSCOPE STRT REF PER, INSCOPE END"
         4 "4 INSCOPE REF PER, BUT NOT START NOR END"
         5 "5 MEM OF RU BUT OUT-OF-SCOPE ALL REF PER"
         6 "6 OUT-OF-SCOPE IN RU DURING THIS ROUND"
         7 "7 NOT IN RU, JOINED IN LATER ROUND"
         8 "8 RU NON-RESPONSE"
         9 "9 NON-KEY, NOT IN RU, PREVIOUS RU MEMBER" ;

label define H380432X
         0 "0 NOT RECORDED AS BEING INSCOPE"
         1 "1 INSCOPE AT SOME TIME DURING 1999"
         2 "2 OUT-OF-SCOPE FOR ALL OF 1999" ;

label define H380433X
         1 "1 ANY PRIVATE"
         2 "2 PUBLIC ONLY"
         3 "3 UNINSURED" ;

label define H380434X
         -1 "-1 INAPPLICABLE"
         -3 "-3 NO DATA IN ROUND"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES"
         2 "2 NO" ;

label define H380435X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H380436X
         -1 "-1 INAPPLICABLE"
         -3 "-3 NO DATA IN ROUND"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES"
         2 "2 NO" ;

label define H380437X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H380438X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H380439X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H380440X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H380441X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H380442X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H380443X
         -1 "-1 INAPPLICABLE"
         -3 "-3 NO DATA IN ROUND"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES"
         2 "2 NO" ;

label define H380444X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H380445X
         -1 "-1 INAPPLICABLE"
         -3 "-3 NO DATA IN ROUND"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES"
         2 "2 NO" ;

label define H380446X
         -1 "-1 INAPPLICABLE"
         -3 "-3 NO DATA IN ROUND"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES"
         2 "2 NO" ;

label define H380447X
         -1 "-1 INAPPLICABLE"
         -3 "-3 NO DATA IN ROUND"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES"
         2 "2 NO" ;

label define H380448X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H380449X
         1 "1 ORIGINAL RESPONSE USED"
         2 "2 BRACKET CONVERTED"
         3 "3 MISSING VALUES SET TO 0"
         4 "4 WEEKS WORKED/EARNINGS USED(WAGEIMP ONLY)"
         5 "5 CONDITIONAL HOTDECK"
         6 "6 UNCONDITIONAL HOTDECK"
         7 "7 EDITED USING NHIS DATA" ;

label define H380450X
         -1 "-1 INAPPLICABLE"
         -3 "-3 NO DATA IN ROUND"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES"
         2 "2 NO" ;

label define H380451X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H380452X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H380453X
         -1 "-1 INAPPLICABLE"
         1 "1 ENGLISH"
         2 "2 SPANISH"
         3 "3 ENGLISH & SPANISH"
         91 "91 OTHER" ;

label define H380454X
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H380455X
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H380456X
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H380457X
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H380458X
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H380459X
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H380460X
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H380461X
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H380462X
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H380463X
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H380464X
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H380465X
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H380466X
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H380467X
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H380468X
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H380469X
         -9 "-9 NOT ASCERTAINED"
         0 "0"
         1167 "$1167 - $1167" ;

label define H380470X
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H380471X
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H380472X
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H380473X
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H380474X
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H380475X
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H380476X
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H380477X
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H380478X
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H380479X
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H380480X
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H380481X
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H380482X
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H380483X
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H380484X
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H380485X
         1 "1 ORIGINAL RESPONSE USED"
         2 "2 BRACKET CONVERTED"
         6 "6 UNCONDITIONAL HOTDECK" ;

label define H380486X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H380487X
         -1 "-1 INAPPLICABLE"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H380488X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES"
         2 "2 NO" ;

label define H380489X
         -1 "-1 INAPPLICABLE"
         -9 "-9 NOT ASCERTAINED" ;

label define H380490X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 PRIVATE COMPANY OR FOREIGN GOVT"
         2 "2 FEDERAL GOVT OR ARMED FORCES"
         3 "3 STATE OR LOCAL GOVT" ;

label define H380491X
         -1 "-1 INAPPLICABLE"
         -2 "-2 DETERMINED IN PREVIOUS ROUND"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 PRIVATE COMPANY OR FOREIGN GOVT"
         2 "2 FEDERAL GOVT OR ARMED FORCES"
         3 "3 STATE OR LOCAL GOVT" ;

label define H380492X
         -1 "-1 INAPPLICABLE"
         -2 "-2 DETERMINED IN PREVIOUS ROUND"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 PRIVATE COMPANY OR FOREIGN GOVT"
         2 "2 FEDERAL GOVT OR ARMED FORCES"
         3 "3 STATE OR LOCAL GOVT" ;

label define H380493X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H380494X
         -1 "-1 INAPPLICABLE"
         1 "1 KEY"
         2 "2 NOT KEY" ;

label define H380495X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         99 "99 ASKED, BUT INAPPLICABLE" ;

label define H380496X
         -1 "-1 INAPPLICABLE"
         -3 "-3 NO DATA IN ROUND"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES"
         2 "2 NO" ;

label define H380497X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 NO DIFFICULTY"
         2 "2 SOME DIFFICULTY"
         3 "3 A LOT OF DIFFICULTY"
         4 "4 UNABLE TO DO" ;

label define H380498X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 NO DIFFICULTY"
         2 "2 SOME DIFFICULTY"
         3 "3 A LOT OF DIFFICULTY"
         4 "4 UNABLE TO DO" ;

label define H380499X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 SET"
         2 "2 NOT SET" ;

label define H380500X
         -1 "-1 INAPPLICABLE"
         -3 "-3 NO DATA IN ROUND"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES"
         2 "2 NO" ;

label define H380501X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES"
         2 "2 NO" ;

label define H380502X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 SET"
         2 "2 NOT SET" ;

label define H380503X
         -1 "-1 INAPPLICABLE"
         -3 "-3 NO DATA IN ROUND"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 OFFICE"
         2 "2 HOSP, NOT ER"
         3 "3 HOSP, ER" ;

label define H380504X
         -1 "-1 INAPPLICABLE"
         -3 "-3 NO DATA IN ROUND"
         -8 "-8 DK"
         1 "1 COULD NOT AFFORD CARE"
         10 "10 DIFFERENT LANGUAGE"
         11 "11 HARD TO GET INTO BUILDING"
         13 "13 NO APPROPRIATE EQUIPMENT IN OFFICE"
         14 "14 COULD NOT GET TIME OFF WORK"
         15 "15 DK WHERE TO GO TO GET CARE"
         16 "16 WAS REFUSED SERVICES"
         17 "17 COULDN'T GET CHILD CARE"
         18 "18 DID NOT HAVE TIME OR TOOK TOO LONG"
         2 "2 INS CO WOULD NOT APPROVE/COVER/PAY"
         3 "3 PRE-EXISTING CONDITION"
         4 "4 INS CO REQUIRED REFERRL-COULD NOT GET"
         5 "5 DOCTOR REFUSED FAMILY INS PLAN"
         6 "6 MEDICAL CARE TOO FAR AWAY"
         7 "7 CAN NOT DRIVE/NO CAR/NO PUBLIC TRANSP"
         8 "8 TOO EXPENSIVE TO GET THERE"
         9 "9 HEARING IMPAIRMENT OR LOSS"
         91 "91 OTHER" ;

label define H380505X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 MARRIED"
         10 "10 SEPARATED IN ROUND"
         2 "2 WIDOWED"
         3 "3 DIVORCED"
         4 "4 SEPARATED"
         5 "5 NEVER MARRIED"
         6 "6 UNDER 16 - INAPPLICABLE"
         7 "7 MARRIED IN ROUND"
         8 "8 WIDOWED IN ROUND"
         9 "9 DIVORCED IN ROUND" ;

label define H380506X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 MARRIED"
         10 "10 SEPARATED IN ROUND"
         2 "2 WIDOWED"
         3 "3 DIVORCED"
         4 "4 SEPARATED"
         5 "5 NEVER MARRIED"
         6 "6 UNDER 16 - INAPPLICABLE"
         7 "7 MARRIED IN ROUND"
         8 "8 WIDOWED IN ROUND"
         9 "9 DIVORCED IN ROUND" ;

label define H380507X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 MARRIED"
         10 "10 SEPARATED IN ROUND"
         2 "2 WIDOWED"
         3 "3 DIVORCED"
         4 "4 SEPARATED"
         5 "5 NEVER MARRIED"
         6 "6 UNDER 16 INAPPLICABLE"
         7 "7 MARRIED IN ROUND"
         8 "8 WIDOWED IN ROUND"
         9 "9 DIVORCED IN ROUND" ;

label define H380508X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 MARRIED"
         2 "2 WIDOWED"
         3 "3 DIVORCED"
         4 "4 SEPARATED"
         5 "5 NEVER MARRIED"
         6 "6 UNDER 16 - INAPPLICABLE" ;

label define H380509X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H380510X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H380511X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H380512X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H380513X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H380514X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H380515X
         -1 "-1 INAPPLICABLE"
         -3 "-3 NO DATA IN ROUND"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES"
         2 "2 NO" ;

label define H380516X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H380517X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H380518X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H380519X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H380520X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H380521X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H380522X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H380523X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H380524X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H380525X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H380526X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H380527X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H380528X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H380529X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H380530X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H380531X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H380532X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H380533X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H380534X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H380535X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H380536X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H380537X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H380538X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H380539X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H380540X
         -1 "-1 INAPPLICABLE"
         -3 "-3 NO DATA IN ROUND"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES"
         2 "2 NO" ;

label define H380541X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H380542X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H380543X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H380544X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H380545X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H380546X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H380547X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H380548X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H380549X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H380550X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H380551X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H380552X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H380553X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H380554X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H380555X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H380556X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H380557X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H380558X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H380559X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H380560X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 NO DIFFICULTY"
         2 "2 SOME DIFFICULTY"
         3 "3 A LOT OF DIFFICULTY"
         4 "4 UNABLE TO DO" ;

label define H380561X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 NO DIFFICULTY"
         2 "2 SOME DIFFICULTY"
         3 "3 A LOT OF DIFFICULTY"
         4 "4 UNABLE TO DO" ;

label define H380562X
         -1 "-1 INAPPLICABLE"
         -3 "-3 NO DATA IN ROUND"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES"
         2 "2 NO" ;

label define H380563X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES"
         2 "2 NO" ;

label define H380564X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 EXCELLENT"
         2 "2 VERY GOOD"
         3 "3 GOOD"
         4 "4 FAIR"
         5 "5 POOR" ;

label define H380565X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 EXCELLENT"
         2 "2 VERY GOOD"
         3 "3 GOOD"
         4 "4 FAIR"
         5 "5 POOR" ;

label define H380566X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 EXCELLENT"
         2 "2 VERY GOOD"
         3 "3 GOOD"
         4 "4 FAIR"
         5 "5 POOR" ;

label define H380567X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 SELF"
         2 "2 PROXY" ;

label define H380568X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 SELF"
         2 "2 PROXY" ;

label define H380569X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 SELF"
         2 "2 PROXY" ;

label define H380570X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         99 "99 ASKED, BUT INAPPLICABLE" ;

label define H380571X
         -1 "-1 INAPPLICABLE"
         -9 "-9 NOT ASCERTAINED" ;

label define H380572X
         -1 "-1 INAPPLICABLE"
         -9 "-9 NOT ASCERTAINED" ;

label define H380573X
         -1 "-1 INAPPLICABLE"
         -9 "-9 NOT ASCERTAINED" ;

label define H380574X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES"
         2 "2 NO" ;

label define H380575X
         -1 "-1 INAPPLICABLE"
         -2 "-2 DETERMINED IN PREVIOUS ROUND"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES"
         2 "2 NO" ;

label define H380576X
         -1 "-1 INAPPLICABLE"
         -2 "-2 DETERMINED IN PREVIOUS ROUND"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES"
         2 "2 NO" ;

label define H380577X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 MORE THAN ONE CURRENT JOB"
         2 "2 NOT MORE THAN ONE CURRENT JOB" ;

label define H380578X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 MORE THAN ONE CURRENT JOB"
         2 "2 NOT MORE THAN ONE CURRENT JOB" ;

label define H380579X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 MORE THAN ONE CURRENT JOB"
         2 "2 NOT MORE THAN ONE CURRENT JOB" ;

label define H380580X
         -1 "-1 INAPPLICABLE"
         0 "0 NON-MSA"
         1 "1 MSA" ;

label define H380581X
         -1 "-1 INAPPLICABLE"
         0 "0 NON-MSA"
         1 "1 MSA" ;

label define H380582X
         -1 "-1 INAPPLICABLE"
         -3 "-3 NO DATA IN ROUND"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES"
         2 "2 NO" ;

label define H380583X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         99 "99 ASKED, BUT INAPPLICABLE" ;

label define H380584X
         -1 "-1 INAPPLICABLE"
         -3 "-3 NO DATA IN ROUND"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES"
         2 "2 NO" ;

label define H380585X
         -1 "-1 INAPPLICABLE"
         -3 "-3 NO DATA IN ROUND"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES"
         2 "2 NO" ;

label define H380586X
         -1 "-1 INAPPLICABLE"
         -3 "-3 NO DATA IN ROUND"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES"
         2 "2 NO" ;

label define H380587X
         -1 "-1 INAPPLICABLE"
         -3 "-3 NO DATA IN ROUND"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES"
         2 "2 NO" ;

label define H380588X
         -1 "-1 INAPPLICABLE"
         -3 "-3 NO DATA IN ROUND"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES"
         2 "2 NO" ;

label define H380589X
         -1 "-1 INAPPLICABLE"
         -3 "-3 NO DATA IN ROUND"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES"
         2 "2 NO" ;

label define H380590X
         -1 "-1 INAPPLICABLE"
         -3 "-3 NO DATA IN ROUND"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES"
         2 "2 NO" ;

label define H380591X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 DEFINITELY FALSE"
         2 "2 MOSTLY FALSE"
         3 "3 MOSTLY TRUE"
         4 "4 DEFINITELY TRUE" ;

label define H380592X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H380593X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 ONCE"
         2 "2 SEVERAL TIMES" ;

label define H380594X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED" ;

label define H380595X
         -1 "-1 INAPPLICABLE"
         -2 "-2 DETERMINED IN PREVIOUS ROUND"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED" ;

label define H380596X
         -1 "-1 INAPPLICABLE"
         -2 "-2 DETERMINED IN PREVIOUS ROUND"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED" ;

label define H380597X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 ONCE"
         2 "2 SEVERAL TIMES" ;

label define H380598X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 COULD NOT FIND WORK"
         2 "2 RETIRED"
         3 "3 UNABLE TO WORK BECAUSE ILL/DISABLED"
         4 "4 ON TEMPORARY LAYOFF"
         5 "5 MATERNITY/PATERNITY LEAVE"
         6 "6 GOING TO SCHOOL"
         7 "7 TAKING CARE OF HOME OR FAMILY"
         8 "8 WANTED SOME TIME OFF"
         9 "9 WAITING TO START NEW JOB"
         91 "91 OTHER" ;

label define H380599X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 COULD NOT FIND WORK"
         2 "2 RETIRED"
         3 "3 UNABLE TO WORK BECAUSE ILL/DISABLED"
         4 "4 ON TEMPORARY LAYOFF"
         5 "5 MATERNITY/PATERNITY LEAVE"
         6 "6 GOING TO SCHOOL"
         7 "7 TAKING CARE OF HOME OR FAMILY"
         8 "8 WANTED SOME TIME OFF"
         9 "9 WAITING TO START NEW JOB"
         91 "91 OTHER" ;

label define H380600X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 COULD NOT FIND WORK"
         2 "2 RETIRED"
         3 "3 UNABLE TO WORK BECAUSE ILL/DISABLED"
         4 "4 ON TEMPORARY LAYOFF"
         5 "5 MATERNITY/PATERNITY LEAVE"
         6 "6 GOING TO SCHOOL"
         7 "7 TAKING CARE OF HOME OR FAMILY"
         8 "8 WANTED SOME TIME OFF"
         9 "9 WAITING TO START NEW JOB"
         91 "91 OTHER" ;

label define H380601X
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H380602X
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H380603X
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H380604X
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H380605X
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H380606X
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H380607X
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H380608X
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H380609X
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H380610X
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H380611X
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H380612X
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H380613X
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H380614X
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H380615X
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H380616X
         -9 "-9 NOT ASCERTAINED"
         0 "0"
         10 "$10" ;

label define H380617X
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H380618X
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H380619X
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H380620X
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H380621X
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H380622X
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H380623X
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H380624X
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H380625X
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H380626X
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H380627X
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H380628X
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H380629X
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H380630X
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H380631X
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H380632X
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H380633X
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H380634X
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H380635X
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H380636X
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H380637X
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H380638X
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H380639X
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H380640X
         -9 "-9 NOT ASCERTAINED"
         0 "0"
         1 "1" ;

label define H380641X
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H380642X
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H380643X
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H380644X
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H380645X
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H380646X
         -9 "-9 NOT ASCERTAINED"
         0 "0"
         18 "$18" ;

label define H380647X
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H380648X
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H380649X
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H380650X
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H380651X
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H380652X
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H380653X
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H380654X
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H380655X
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H380656X
         -9 "-9 NOT ASCERTAINED"
         0 "0"
         10 "$10" ;

label define H380657X
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H380658X
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H380659X
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H380660X
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H380661X
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H380662X
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H380663X
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H380664X
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H380665X
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H380666X
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H380667X
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H380668X
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H380669X
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H380670X
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H380671X
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H380672X
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H380673X
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H380674X
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H380675X
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H380676X
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H380677X
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H380678X
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H380679X
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H380680X
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H380681X
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H380682X
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H380683X
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H380684X
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H380685X
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H380686X
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H380687X
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H380688X
         -9 "-9 NOT ASCERTAINED"
         0 "0"
         1 "1"
         2 "2" ;

label define H380689X
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H380690X
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H380691X
         -1 "-1 INAPPLICABLE"
         -3 "-3 NO DATA IN ROUND"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES"
         2 "2 NO" ;

label define H380692X
         -9 "-9 NOT ASCERTAINED"
         0 "0"
         198 "$198" ;

label define H380693X
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H380694X
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H380695X
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H380696X
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H380697X
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H380698X
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H380699X
         -9 "-9 NOT ASCERTAINED"
         0 "0"
         157 "$157" ;

label define H380700X
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H380701X
         -9 "-9 NOT ASCERTAINED"
         0 "0"
         1 "1" ;

label define H380702X
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H380703X
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H380704X
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H380705X
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H380706X
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H380707X
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H380708X
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H380709X
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H380710X
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H380711X
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H380712X
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H380713X
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H380714X
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H380715X
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H380716X
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H380717X
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H380718X
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H380719X
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H380720X
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H380721X
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H380722X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 SET"
         2 "2 NOT SET" ;

label define H380723X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES"
         2 "2 NO" ;

label define H380724X
         -1 "-1 INAPPLICABLE"
         -2 "-2 DETERMINED IN PREVIOUS ROUND"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES"
         2 "2 NO" ;

label define H380725X
         -1 "-1 INAPPLICABLE"
         -2 "-2 DETERMINED IN PREVIOUS ROUND"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES"
         2 "2 NO" ;

label define H380726X
         -1 "-1 INAPPLICABLE"
         -3 "-3 NO DATA IN ROUND"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES"
         2 "2 NO" ;

label define H380727X
         -1 "-1 INAPPLICABLE"
         -3 "-3 NO DATA IN ROUND"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES"
         2 "2 NO" ;

label define H380728X
         -1 "-1 INAPPLICABLE"
         -3 "-3 NO DATA IN ROUND"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES"
         2 "2 NO" ;

label define H380729X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H380730X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H380731X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H380732X
         -1 "-1 INAPPLICABLE"
         -3 "-3 NO DATA IN ROUND"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES"
         2 "2 NO" ;

label define H380733X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H380734X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H380735X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H380736X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H380737X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H380738X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H380739X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H380740X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H380741X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H380742X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H380743X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H380744X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H380745X
         -1 "-1 INAPPLICABLE"
         -3 "-3 NO DATA IN ROUND"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES"
         2 "2 NO" ;

label define H380746X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H380747X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H380748X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H380749X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H380750X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H380751X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H380752X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H380753X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H380754X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H380755X
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H380756X
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H380757X
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H380758X
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H380759X
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H380760X
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H380761X
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H380762X
         -9 "-9 NOT ASCERTAINED"
         0 "0"
         102 "$102" ;

label define H380763X
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H380764X
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H380765X
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H380766X
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H380767X
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H380768X
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H380769X
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H380770X
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H380771X
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H380772X
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H380773X
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H380774X
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H380775X
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H380776X
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H380777X
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H380778X
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H380779X
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H380780X
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H380781X
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H380782X
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H380783X
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H380784X
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H380785X
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H380786X
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H380787X
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H380788X
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H380789X
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H380790X
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H380791X
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H380792X
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H380793X
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H380794X
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H380795X
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H380796X
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H380797X
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H380798X
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H380799X
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H380800X
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H380801X
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H380802X
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H380803X
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H380804X
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H380805X
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H380806X
         -9 "-9 NOT ASCERTAINED"
         0 "0"
         102 "$102" ;

label define H380807X
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H380808X
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H380809X
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H380810X
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H380811X
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H380812X
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H380813X
         -9 "-9 NOT ASCERTAINED"
         0 "0"
         669 "$669" ;

label define H380814X
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H380815X
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H380816X
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H380817X
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H380818X
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H380819X
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H380820X
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H380821X
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H380822X
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H380823X
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H380824X
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H380825X
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H380826X
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H380827X
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H380828X
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H380829X
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H380830X
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H380831X
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H380832X
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H380833X
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H380834X
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H380835X
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H380836X
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H380837X
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H380838X
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H380839X
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H380840X
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H380841X
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H380842X
         -9 "-9 NOT ASCERTAINED"
         0 "0"
         8 "$8" ;

label define H380843X
         -1 "-1 IN APPLICABLE"
         -3 "-3 NO DATA IN ROUND"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         0 "0"
         1 "1 YES"
         2 "2 NO/NOT WORK" ;

label define H380844X
         -1 "-1 IN APPLICABLE"
         -3 "-3 NO DATA IN ROUND"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         0 "0"
         1 "1 YES"
         2 "2 NO/NOT WORK" ;

label define H380845X
         -1 "-1 IN APPLICABLE"
         -3 "-3 NO DATA IN ROUND"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         0 "0"
         1 "1 YES"
         2 "2 NO/NOT WORK" ;

label define H380846X
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H380847X
         1 "1 ORIGINAL RESPONSE USED"
         2 "2 BRACKET CONVERTED"
         3 "3 MISSING VALUES SET TO 0"
         6 "6 UNCONDITIONAL HOTDECK" ;

label define H380848X
         -1 "-1 INAPPLICABLE"
         -3 "-3 NO DATA IN ROUND"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES"
         2 "2 NO" ;

label define H380849X
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H380850X
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H380851X
         -1 "-1 IN APPLICABLE"
         -3 "-3 NO DATA IN ROUND"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H380852X
         -1 "-1 IN APPLICABLE"
         -3 "-3 NO DATA IN ROUND"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H380853X
         -1 "-1 IN APPLICABLE"
         -3 "-3 NO DATA IN ROUND"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H380854X
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H380855X
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H380856X
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H380857X
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H380858X
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H380859X
         -1 "-1 INAPPLICABLE"
         -3 "-3 NO DATA IN ROUND"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES"
         2 "2 NO" ;

label define H380860X
         -1 "-1 INAPPLICABLE"
         -3 "-3 NO DATA IN ROUND"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES"
         2 "2 NO" ;

label define H380861X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H380862X
         -1 "-1 INAPPLICABLE"
         -3 "-3 NO DATA IN ROUND"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES"
         2 "2 NO" ;

label define H380863X
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H380864X
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H380865X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 SET"
         2 "2 NOT SET" ;

label define H380866X
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H380867X
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H380868X
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H380869X
         3 "3 PANEL 3"
         4 "4 PANEL 4" ;

label define H380870X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES"
         2 "2 NO" ;

label define H380871X
         -1 "-1 INAPPLICABLE"
         -2 "-2 DETERMINED IN PREVIOUS ROUND"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES"
         2 "2 NO" ;

label define H380872X
         -1 "-1 INAPPLICABLE"
         -2 "-2 DETERMINED IN PREVIOUS ROUND"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES"
         2 "2 NO" ;

label define H380873X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES"
         2 "2 NO" ;

label define H380874X
         -1 "-1 INAPPLICABLE"
         -2 "-2 DETERMINED IN PREVIOUS ROUND"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES"
         2 "2 NO" ;

label define H380875X
         -1 "-1 INAPPLICABLE"
         -2 "-2 DETERMINED IN PREVIOUS ROUND"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES"
         2 "2 NO" ;

label define H380876X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H380877X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H380878X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H380879X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H380880X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H380881X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H380882X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H380883X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H380884X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H380885X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H380886X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H380887X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H380888X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H380889X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H380890X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H380891X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H380892X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H380893X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H380894X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H380895X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H380896X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H380897X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H380898X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H380899X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H380900X
         1 "1 ORIGINAL RESPONSE USED"
         2 "2 BRACKET CONVERTED"
         3 "3 MISSING VALUES SET TO 0"
         4 "4 WEEKS WORKED/EARNINGS USED(WAGEIMP ONLY)"
         5 "5 CONDITIONAL HOTDECK"
         6 "6 UNCONDITIONAL HOTDECK"
         7 "7 EDITED USING NHIS DATA" ;

label define H380901X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H380902X
         -1 "-1 INAPPLICABLE"
         -3 "-3 NO DATA IN ROUND"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES"
         2 "2 NO" ;

label define H380903X
         -1 "-1 INAPPLICABLE"
         -3 "-3 NO DATA IN ROUND"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 VERY DIFFICULT"
         2 "2 SOMEWHAT DIFFICULT"
         3 "3 NOT TOO DIFFICULT"
         4 "4 NOT AT ALL DIFFICULT" ;

label define H380904X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 SET"
         2 "2 NOT SET" ;

label define H380905X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES"
         2 "2 NO" ;

label define H380906X
         -1 "-1 INAPPLICABLE"
         -3 "-3 NO DATA IN ROUND"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES"
         2 "2 NO" ;

label define H380907X
         -1 "-1 INAPPLICABLE"
         -3 "-3 NO DATA IN ROUND"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES"
         2 "2 NO" ;

label define H380908X
         -1 "-1 INAPPLICABLE"
         -3 "-3 NO DATA IN ROUND"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES"
         2 "2 NO" ;

label define H380909X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H380910X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H380911X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H380912X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H380913X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H380914X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H380915X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H380916X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H380917X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H380918X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H380919X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H380920X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H380921X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H380922X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H380923X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H380924X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H380925X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H380926X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H380927X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H380928X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H380929X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H380930X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H380931X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H380932X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H380933X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES"
         2 "2 NO" ;

label define H380934X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H380935X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H380936X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H380937X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H380938X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H380939X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H380940X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H380941X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H380942X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H380943X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H380944X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H380945X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H380946X
         1 "1 NEGATIVE OR POOR"
         2 "2 NEAR POOR"
         3 "3 LOW INCOME"
         4 "4 MIDDLE INCOME"
         5 "5 HIGH INCOME" ;

label define H380947X
         -1 "-1 INAPPLICABLE"
         -3 "-3 NO DATA IN ROUND"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES"
         2 "2 NO" ;

label define H380948X
         -1 "-1 INAPPLICABLE"
         -3 "-3 NO DATA IN ROUND"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES"
         2 "2 NO" ;

label define H380949X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H380950X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H380951X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H380952X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H380953X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H380954X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H380955X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H380956X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H380957X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H380958X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H380959X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H380960X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H380961X
         -1 "-1 INAPPLICABLE"
         -3 "-3 NO DATA IN ROUND"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES"
         2 "2 NO" ;

label define H380962X
         -1 "-1 INAPPLICABLE"
         -3 "-3 NO DATA IN ROUND"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 VERY SATISFIED"
         2 "2 SOMEWHAT SATISFIED"
         3 "3 NOT TOO SATISFIED"
         4 "4 NOT AT ALL SATISFIED" ;

label define H380963X
         -1 "-1 INAPPLICABLE"
         -3 "-3 NO DATA IN ROUND"
         -9 "-9 NOT ASCERTAINED"
         1 "1 FACILITY"
         2 "2 PERSON"
         3 "3 PERSON IN FACILITY PROV" ;

label define H380964X
         -1 "-1 NON-RESPONSE"
         1 "1 RESPONDENT IS RU MEMBER"
         2 "2 RESPONDENT IS A PROXY" ;

label define H380965X
         -1 "-1 NON-RESPONSE"
         1 "1 RESPONDENT IS RU MEMBER"
         2 "2 RESPONDENT IS A PROXY" ;

label define H380966X
         -1 "-1 NON-RESPONSE"
         1 "1 RESPONDENT IS RU MEMBER"
         2 "2 RESPONDENT IS A PROXY" ;

label define H380967X
         -1 "-1 NON-RESPONSE"
         1 "1 RESPONDENT IS RU MEMBER"
         2 "2 RESPONDENT IS A PROXY" ;

label define H380968X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H380969X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H380970X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H380971X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H380972X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H380973X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H380974X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H380975X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H380976X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H380977X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H380978X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H380979X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H380980X
         -1 "-1 INAPPLICABLE"
         -3 "-3 NO DATA IN ROUND"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES"
         2 "2 NO" ;

label define H380981X
         -1 "-1 NOT FIELDED/NON-RESPONSE RU"
         0 "0 INCORRECTLY LISTED IN RU AT NHIS"
         11 "11 PERSON IN HOUSEHLD, NOT FT ACTIVE MIL"
         12 "12 IN HOUSEHLD, FT MIL DUTY-OUT-SCOPE"
         13 "13 FT STUD LIVING AWAY FROM HOME"
         14 "14 IN ORIG HH, FT ACTIVE DUTY-INSCOPE"
         21 "21 INSTITUTIONALIZED WHOLE RD: 4/2, 5/3"
         22 "22 LEAVE INSTITUTION ROUND: 4/2, 5/3"
         23 "23 LEAVES INSTITUTION & DIES RD: 4/2, 5/3"
         24 "24 DIES IN INST DURING ROUND: 4/2, 5/3"
         31 "31 DECEASED"
         32 "32 INSTITUTIONALIZED IN HEALTH CARE FAC"
         33 "33 INSTITUTIONALIZED NON-HEALTH CARE FAC"
         34 "34 MOVED OUTSIDE U.S., NOT AS STUDENT"
         35 "35 MOVED, FT ACTIVE DUTY"
         36 "36 INSTITUTIONALIZED (TYPE UNKNOWN)"
         41 "41 MOVED WITHIN U.S."
         42 "42 PERSON WHO JOINED RU, NOT FT MIL"
         43 "43 REASON UNK OR MOVED TO UNK LOCATION"
         44 "44 JOINS ANOTHER RU, & IS INSCOPE"
         51 "51 NEWBORN IN REF PERIOD"
         61 "61 DECEASED PRIOR TO REF PERIOD-R1 ONLY"
         62 "62 INSTITUT PRIOR TO REF PER-R1 ONLY"
         63 "63 LEFT U.S. PRIOR TO REF PER-R1 ONLY"
         64 "64 FT MIL, MIL FAC MOVE PRIOR REF PER-R1"
         71 "71 LIVING AWAY GRADES 1-12 NONKEY"
         72 "72 INELIG NON-KEY/RESIDENCY SCHL YR ONLY"
         73 "73 NONKEY, NOT FT MIL, MOVED W/OUT KEY"
         74 "74 MOVED AS FT MIL, NOT TO FAC, W/O KEY"
         81 "81 MOVED, FT STUD, NO RESP, DATA IMPUTED" ;

label define H380982X
         -1 "-1 NOT FIELDED/NON-RESPONSE RU"
         0 "0 INCORRECTLY LISTED IN RU AT NHIS"
         11 "11 PERSON IN HOUSEHLD, NOT FT ACTIVE MIL"
         12 "12 IN HOUSEHLD, FT MIL DUTY-OUT-SCOPE"
         13 "13 FT STUD LIVING AWAY FROM HOME"
         14 "14 IN ORIG HH, FT ACTIVE DUTY-INSCOPE"
         21 "21 INSTITUTIONALIZED WHOLE RD: 4/2, 5/3"
         22 "22 LEAVE INSTITUTION ROUND: 4/2, 5/3"
         23 "23 LEAVES INSTITUTION & DIES RD: 4/2, 5/3"
         24 "24 DIES IN INST DURING ROUND: 4/2, 5/3"
         31 "31 DECEASED"
         32 "32 INSTITUTIONALIZED IN HEALTH CARE FAC"
         33 "33 INSTITUTIONALIZED NON-HEALTH CARE FAC"
         34 "34 MOVED OUTSIDE U.S., NOT AS STUDENT"
         35 "35 MOVED, FT ACTIVE DUTY"
         36 "36 INSTITUTIONALIZED (TYPE UNKNOWN)"
         41 "41 MOVED WITHIN U.S."
         42 "42 PERSON WHO JOINED RU, NOT FT MIL"
         43 "43 REASON UNK OR MOVED TO UNK LOCATION"
         44 "44 JOINS ANOTHER RU, & IS INSCOPE"
         51 "51 NEWBORN IN REF PERIOD"
         61 "61 DECEASED PRIOR TO REF PERIOD-R1 ONLY"
         62 "62 INSTITUT PRIOR TO REF PER-R1 ONLY"
         63 "63 LEFT U.S. PRIOR TO REF PER-R1 ONLY"
         64 "64 FT MIL, MIL FAC MOVE PRIOR REF PER-R1"
         71 "71 LIVING AWAY GRADES 1-12 NONKEY"
         72 "72 INELIG NON-KEY/RESIDENCY SCHL YR ONLY"
         73 "73 NONKEY, NOT FT MIL, MOVED W/OUT KEY"
         74 "74 MOVED AS FT MIL, NOT TO FAC, W/O KEY"
         81 "81 MOVED, FT STUD, NO RESP, DATA IMPUTED" ;

label define H380983X
         -1 "-1 NOT FIELDED/NON-RESPONSE RU"
         0 "0 INCORRECTLY LISTED IN RU AT NHIS"
         11 "11 PERSON IN HOUSEHLD, NOT FT ACTIVE MIL"
         12 "12 IN HOUSEHLD, FT MIL DUTY-OUT-SCOPE"
         13 "13 FT STUD LIVING AWAY FROM HOME"
         14 "14 IN ORIG HH, FT ACTIVE DUTY-INSCOPE"
         21 "21 INSTITUTIONALIZED WHOLE RD: 4/2, 5/3"
         22 "22 LEAVE INSTITUTION ROUND: 4/2, 5/3"
         23 "23 LEAVES INSTITUTION & DIES RD: 4/2, 5/3"
         24 "24 DIES IN INST DURING ROUND: 4/2, 5/3"
         31 "31 DECEASED"
         32 "32 INSTITUTIONALIZED IN HEALTH CARE FAC"
         33 "33 INSTITUTIONALIZED NON-HEALTH CARE FAC"
         34 "34 MOVED OUTSIDE U.S., NOT AS STUDENT"
         35 "35 MOVED, FT ACTIVE DUTY"
         36 "36 INSTITUTIONALIZED (TYPE UNKNOWN)"
         41 "41 MOVED WITHIN U.S."
         42 "42 PERSON WHO JOINED RU, NOT FT MIL"
         43 "43 REASON UNK OR MOVED TO UNK LOCATION"
         44 "44 JOINS ANOTHER RU, & IS INSCOPE"
         51 "51 NEWBORN IN REF PERIOD"
         61 "61 DECEASED PRIOR TO REF PERIOD-R1 ONLY"
         62 "62 INSTITUT PRIOR TO REF PER-R1 ONLY"
         63 "63 LEFT U.S. PRIOR TO REF PER-R1 ONLY"
         64 "64 FT MIL, MIL FAC MOVE PRIOR REF PER-R1"
         71 "71 LIVING AWAY GRADES 1-12 NONKEY"
         72 "72 INELIG NON-KEY/RESIDENCY SCHL YR ONLY"
         73 "73 NONKEY, NOT FT MIL, MOVED W/OUT KEY"
         74 "74 MOVED AS FT MIL, NOT TO FAC, W/O KEY"
         81 "81 MOVED, FT STUD, NO RESP, DATA IMPUTED" ;

label define H380984X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 SET"
         2 "2 NOT SET" ;

label define H380985X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H380986X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H380987X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H380988X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H380989X
         1 "1 ORIGINAL RESPONSE USED"
         2 "2 BRACKET CONVERTED"
         5 "5 CONDITIONAL HOTDECK"
         6 "6 UNCONDITIONAL HOTDECK" ;

label define H380990X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H380991X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H380992X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H380993X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H380994X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H380995X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H380996X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H380997X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H380998X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H380999X
         -1 "-1 INAPPLICABLE"
         -3 "-3 NO DATA IN ROUND"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES"
         2 "2 NO" ;

label define H381000X
         -1 "-1 NO RD 2 CROSSOVER PROBLEM"
         1 "1 RD 2 ENDS IN 1999; RD 3 BEGINS IN 1999"
         2 "2 NO RD 2; RD 3 BEGINS IN 1999"
         3 "3 RD 2 ENDS IN 1998; RD 3 BEGINS IN 1999"
         4 "4 RD 2 ENDS IN 1999; RD 3 BEGINS IN 1998" ;

label define H381001X
         1 "1 PERSON IS HISPANIC"
         2 "2 PERSON IS BLACK/NOT HISPANIC"
         3 "3 OTHER" ;

label define H381002X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 AMERICAN INDIAN"
         2 "2 ALEUT, ESKIMO"
         3 "3 ASIAN OR PACIFIC ISLANDER"
         4 "4 BLACK"
         5 "5 WHITE"
         91 "91 OTHER" ;

label define H381003X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 NO DIFFICULTY"
         2 "2 SOME DIFFICULTY"
         3 "3 A LOT OF DIFFICULTY"
         4 "4 UNABLE TO DO" ;

label define H381004X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 NO DIFFICULTY"
         2 "2 SOME DIFFICULTY"
         3 "3 A LOT OF DIFFICULTY"
         4 "4 UNABLE TO DO" ;

label define H381005X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 SET"
         2 "2 NOT SET" ;

label define H381006X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES"
         2 "2 NO" ;

label define H381007X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES"
         2 "2 NO" ;

label define H381008X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 SET"
         2 "2 NOT SET" ;

label define H381009X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H381010X
         -1 "-1 INAPPLICABLE"
         -3 "-3 NO DATA IN ROUND"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES"
         2 "2 NO" ;

label define H381011X
         1 "1 ORIGINAL RESPONSE USED"
         2 "2 BRACKET CONVERTED"
         6 "6 UNCONDITIONAL HOTDECK" ;

label define H381012X
         -1 "-1 INAPPLICABLE"
         -3 "-3 NO DATA IN ROUND"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES"
         2 "2 NO" ;

label define H381013X
         -1 "-1 INAPPLICABLE"
         -3 "-3 NO DATA IN ROUND"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES"
         2 "2 NO" ;

label define H381014X
         -1 "-1 INAPPLICABLE"
         1 "1 NORTHEAST"
         2 "2 MIDWEST"
         3 "3 SOUTH"
         4 "4 WEST" ;

label define H381015X
         -1 "-1 INAPPLICABLE"
         1 "1 NORTHEAST"
         2 "2 MIDWEST"
         3 "3 SOUTH"
         4 "4 WEST" ;

label define H381016X
         -1 "-1 INAPPLICABLE"
         1 "1 NORTHEAST"
         2 "2 MIDWEST"
         3 "3 SOUTH"
         4 "4 WEST" ;

label define H381017X
         -1 "-1 INAPPLICABLE"
         1 "1 NORTHEAST"
         2 "2 MIDWEST"
         3 "3 SOUTH"
         4 "4 WEST" ;

label define H381018X
         0 "0 NON-RESPONSE"
         1 "1 YES, FIRST RESPONDENT"
         2 "2 NO, NOT FIRST RESPONDENT"
         3 "3 NOT DETERMINED" ;

label define H381019X
         0 "0 NON-RESPONSE"
         1 "1 YES, FIRST RESPONDENT"
         2 "2 NO, NOT FIRST RESPONDENT"
         3 "3 NOT DETERMINED" ;

label define H381020X
         0 "0 NON-RESPONSE"
         1 "1 YES, FIRST RESPONDENT"
         2 "2 NO, NOT FIRST RESPONDENT"
         3 "3 NOT DETERMINED" ;

label define H381021X
         0 "0 NON-RESPONSE"
         1 "1 YES, FIRST RESPONDENT"
         2 "2 NO, NOT FIRST RESPONDENT"
         3 "3 NOT DETERMINED" ;

label define H381022X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES"
         2 "2 NO" ;

label define H381023X
         -1 "-1 INAPPLICABLE"
         -2 "-2 DETERMINED IN PREVIOUS ROUND"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES"
         2 "2 NO" ;

label define H381024X
         -1 "-1 INAPPLICABLE"
         -2 "-2 DETERMINED IN PREVIOUS ROUND"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES"
         2 "2 NO" ;

label define H381025X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         0 "0 SELF"
         1 "1 MOTHER"
         10 "10 FATHER-IN-LAW"
         11 "11 SISTER-IN-LAW"
         12 "12 BROTHER-IN-LAW"
         13 "13 DAUGHTER-IN-LAW"
         14 "14 SON-IN-LAW"
         15 "15 STEPMOTHER"
         16 "16 STEPFATHER"
         17 "17 STEPDAUGHTER"
         18 "18 STEPSON"
         19 "19 GRANDMOTHER"
         2 "2 FATHER"
         20 "20 GRANDFATHER"
         21 "21 AUNT"
         22 "22 UNCLE"
         23 "23 NIECE"
         24 "24 NEPHEW"
         25 "25 COUSIN"
         26 "26 GRANDSON"
         27 "27 GRANDDAUGHTER"
         28 "28 FEMALE PARTNER"
         29 "29 MALE PARTNER"
         3 "3 SISTER/STEP/HALF"
         30 "30 MOTHER'S PARTNER"
         31 "31 FATHER'S PARTNER"
         32 "32 DAUGHTER OF PARTNER"
         33 "33 SON OF PARTNER"
         34 "34 FOSTER CHILD"
         35 "35 GREAT GRANDMOTHER"
         36 "36 GREAT GRANDFATHER"
         37 "37 GREAT GRANDDAUGHTER"
         38 "38 GREAT GRANDSON"
         39 "39 GREAT AUNT"
         4 "4 BROTHER/STEP/HALF"
         40 "40 GREAT UNCLE"
         41 "41 GREAT NIECE"
         42 "42 GREAT NEPHEW"
         43 "43 FOSTER MOTHER"
         44 "44 FOSTER FATHER"
         45 "45 FOSTER DAUGHTER"
         46 "46 FOSTER SON"
         5 "5 DAUGHTER/ADOPTED DAUGHTER"
         6 "6 SON/ADOPTED SON"
         7 "7 WIFE/SPOUSE"
         8 "8 HUSBAND/SPOUSE"
         9 "9 MOTHER-IN-LAW"
         91 "91 OTHER RELATED, SPECIFY"
         99 "99 NOT RELATED" ;

label define H381026X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         0 "0 SELF"
         1 "1 MOTHER"
         10 "10 FATHER-IN-LAW"
         11 "11 SISTER-IN-LAW"
         12 "12 BROTHER-IN-LAW"
         13 "13 DAUGHTER-IN-LAW"
         14 "14 SON-IN-LAW"
         15 "15 STEPMOTHER"
         16 "16 STEPFATHER"
         17 "17 STEPDAUGHTER"
         18 "18 STEPSON"
         19 "19 GRANDMOTHER"
         2 "2 FATHER"
         20 "20 GRANDFATHER"
         21 "21 AUNT"
         22 "22 UNCLE"
         23 "23 NIECE"
         24 "24 NEPHEW"
         25 "25 COUSIN"
         26 "26 GRANDSON"
         27 "27 GRANDDAUGHTER"
         28 "28 FEMALE PARTNER"
         29 "29 MALE PARTNER"
         3 "3 SISTER/STEP/HALF"
         30 "30 MOTHER'S PARTNER"
         31 "31 FATHER'S PARTNER"
         32 "32 DAUGHTER OF PARTNER"
         33 "33 SON OF PARTNER"
         34 "34 FOSTER CHILD"
         35 "35 GREAT GRANDMOTHER"
         36 "36 GREAT GRANDFATHER"
         37 "37 GREAT GRANDDAUGHTER"
         38 "38 GREAT GRANDSON"
         39 "39 GREAT AUNT"
         4 "4 BROTHER/STEP/HALF"
         40 "40 GREAT UNCLE"
         41 "41 GREAT NIECE"
         42 "42 GREAT NEPHEW"
         43 "43 FOSTER MOTHER"
         44 "44 FOSTER FATHER"
         45 "45 FOSTER DAUGHTER"
         46 "46 FOSTER SON"
         5 "5 DAUGHTER/ADOPTED DAUGHTER"
         6 "6 SON/ADOPTED SON"
         7 "7 WIFE/SPOUSE"
         8 "8 HUSBAND/SPOUSE"
         9 "9 MOTHER-IN-LAW"
         91 "91 OTHER RELATED, SPECIFY"
         99 "99 NOT RELATED" ;

label define H381027X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         0 "0 SELF"
         1 "1 MOTHER"
         10 "10 FATHER-IN-LAW"
         11 "11 SISTER-IN-LAW"
         12 "12 BROTHER-IN-LAW"
         13 "13 DAUGHTER-IN-LAW"
         14 "14 SON-IN-LAW"
         15 "15 STEPMOTHER"
         16 "16 STEPFATHER"
         17 "17 STEPDAUGHTER"
         18 "18 STEPSON"
         19 "19 GRANDMOTHER"
         2 "2 FATHER"
         20 "20 GRANDFATHER"
         21 "21 AUNT"
         22 "22 UNCLE"
         23 "23 NIECE"
         24 "24 NEPHEW"
         25 "25 COUSIN"
         26 "26 GRANDSON"
         27 "27 GRANDDAUGHTER"
         28 "28 FEMALE PARTNER"
         29 "29 MALE PARTNER"
         3 "3 SISTER/STEP/HALF"
         30 "30 MOTHER'S PARTNER"
         31 "31 FATHER'S PARTNER"
         32 "32 DAUGHTER OF PARTNER"
         33 "33 SON OF PARTNER"
         34 "34 FOSTER CHILD"
         35 "35 GREAT GRANDMOTHER"
         36 "36 GREAT GRANDFATHER"
         37 "37 GREAT GRANDDAUGHTER"
         38 "38 GREAT GRANDSON"
         39 "39 GREAT AUNT"
         4 "4 BROTHER/STEP/HALF"
         40 "40 GREAT UNCLE"
         41 "41 GREAT NIECE"
         42 "42 GREAT NEPHEW"
         43 "43 FOSTER MOTHER"
         44 "44 FOSTER FATHER"
         45 "45 FOSTER DAUGHTER"
         46 "46 FOSTER SON"
         5 "5 DAUGHTER/ADOPTED DAUGHTER"
         6 "6 SON/ADOPTED SON"
         7 "7 WIFE/SPOUSE"
         8 "8 HUSBAND/SPOUSE"
         9 "9 MOTHER-IN-LAW"
         91 "91 OTHER RELATED, SPECIFY"
         99 "99 NOT RELATED" ;

label define H381028X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         0 "0 SELF"
         1 "1 MOTHER"
         10 "10 FATHER-IN-LAW"
         11 "11 SISTER-IN-LAW"
         12 "12 BROTHER-IN-LAW"
         13 "13 DAUGHTER-IN-LAW"
         14 "14 SON-IN-LAW"
         15 "15 STEPMOTHER"
         16 "16 STEPFATHER"
         17 "17 STEPDAUGHTER"
         18 "18 STEPSON"
         19 "19 GRANDMOTHER"
         2 "2 FATHER"
         20 "20 GRANDFATHER"
         21 "21 AUNT"
         22 "22 UNCLE"
         23 "23 NIECE"
         24 "24 NEPHEW"
         25 "25 COUSIN"
         26 "26 GRANDSON"
         27 "27 GRANDDAUGHTER"
         28 "28 FEMALE PARTNER"
         29 "29 MALE PARTNER"
         3 "3 SISTER/STEP/HALF"
         30 "30 MOTHER'S PARTNER"
         31 "31 FATHER'S PARTNER"
         32 "32 DAUGHTER OF PARTNER"
         33 "33 SON OF PARTNER"
         34 "34 FOSTER CHILD"
         35 "35 GREAT GRANDMOTHER"
         36 "36 GREAT GRANDFATHER"
         37 "37 GREAT GRANDDAUGHTER"
         38 "38 GREAT GRANDSON"
         39 "39 GREAT AUNT"
         4 "4 BROTHER/STEP/HALF"
         40 "40 GREAT UNCLE"
         41 "41 GREAT NIECE"
         42 "42 GREAT NEPHEW"
         43 "43 FOSTER MOTHER"
         44 "44 FOSTER FATHER"
         45 "45 FOSTER DAUGHTER"
         46 "46 FOSTER SON"
         5 "5 DAUGHTER/ADOPTED DAUGHTER"
         6 "6 SON/ADOPTED SON"
         7 "7 WIFE/SPOUSE"
         8 "8 HUSBAND/SPOUSE"
         9 "9 MOTHER-IN-LAW"
         91 "91 OTHER RELATED, SPECIFY"
         99 "99 NOT RELATED" ;

label define H381029X
         -1 "-1 INAPPLICABLE"
         -9 "-9 NOT ASCERTAINED"
         1 "1 ROUND 1"
         2 "2 ROUND 2"
         3 "3 ROUND 3" ;

label define H381030X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 EXCELLENT"
         2 "2 VERY GOOD"
         3 "3 GOOD"
         4 "4 FAIR"
         5 "5 POOR" ;

label define H381031X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 EXCELLENT"
         2 "2 VERY GOOD"
         3 "3 GOOD"
         4 "4 FAIR"
         5 "5 POOR" ;

label define H381032X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 EXCELLENT"
         2 "2 VERY GOOD"
         3 "3 GOOD"
         4 "4 FAIR"
         5 "5 POOR" ;

label define H381033X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 SELF"
         2 "2 PROXY" ;

label define H381034X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 SELF"
         2 "2 PROXY" ;

label define H381035X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 SELF"
         2 "2 PROXY" ;

label define H381036X
         -1 "-1 INAPPLICABLE"
         1 "1 STANDARD RU"
         2 "2 NEW RU"
         3 "3 STUDENT RU" ;

label define H381037X
         -1 "-1 INAPPLICABLE"
         1 "1 STANDARD RU"
         2 "2 NEW RU"
         3 "3 STUDENT RU" ;

label define H381038X
         -1 "-1 INAPPLICABLE"
         1 "1 STANDARD RU"
         2 "2 NEW RU"
         3 "3 STUDENT RU" ;

label define H381039X
         -1 "-1 INAPPLICABLE"
         -9 "-9 NOT ASCERTAINED"
         1 "1 STANDARD RU"
         2 "2 NEW RU"
         3 "3 STUDENT RU" ;

label define H381040X
         -1 "-1 INAPPLICABLE"
         1 "1 PERSON IN RU"
         10 "10 PERSONS IN RU"
         11 "11 PERSONS IN RU"
         12 "12 PERSONS IN RU"
         13 "13 PERSONS IN RU"
         14 "14 PERSONS IN RU"
         17 "17 PERSONS IN RU"
         2 "2 PERSONS IN RU"
         3 "3 PERSONS IN RU"
         4 "4 PERSONS IN RU"
         5 "5 PERSONS IN RU"
         6 "6 PERSONS IN RU"
         7 "7 PERSONS IN RU"
         8 "8 PERSONS IN RU"
         9 "9 PERSONS IN RU" ;

label define H381041X
         -1 "-1 INAPPLICABLE"
         1 "1 PERSON IN RU"
         10 "10 PERSONS IN RU"
         11 "11 PERSONS IN RU"
         12 "12 PERSONS IN RU"
         13 "13 PERSONS IN RU"
         14 "14 PERSONS IN RU"
         17 "17 PERSONS IN RU"
         2 "2 PERSONS IN RU"
         3 "3 PERSONS IN RU"
         4 "4 PERSONS IN RU"
         5 "5 PERSONS IN RU"
         6 "6 PERSONS IN RU"
         7 "7 PERSONS IN RU"
         8 "8 PERSONS IN RU"
         9 "9 PERSONS IN RU" ;

label define H381042X
         -1 "-1 INAPPLICABLE"
         1 "1 PERSON IN RU"
         10 "10 PERSONS IN RU"
         11 "11 PERSONS IN RU"
         12 "12 PERSONS IN RU"
         13 "13 PERSONS IN RU"
         14 "14 PERSONS IN RU"
         18 "18 PERSONS IN RU"
         2 "2 PERSONS IN RU"
         3 "3 PERSONS IN RU"
         4 "4 PERSONS IN RU"
         5 "5 PERSONS IN RU"
         6 "6 PERSONS IN RU"
         7 "7 PERSONS IN RU"
         8 "8 PERSONS IN RU"
         9 "9 PERSONS IN RU" ;

label define H381043X
         -1 "-1 INAPPLICABLE"
         1 "1 PERSON IN RU"
         10 "10 PERSONS IN RU"
         11 "11 PERSONS IN RU"
         12 "12 PERSONS IN RU"
         13 "13 PERSONS IN RU"
         14 "14 PERSONS IN RU"
         18 "18 PERSONS IN RU"
         2 "2 PERSONS IN RU"
         3 "3 PERSONS IN RU"
         4 "4 PERSONS IN RU"
         5 "5 PERSONS IN RU"
         6 "6 PERSONS IN RU"
         7 "7 PERSONS IN RU"
         8 "8 PERSONS IN RU"
         9 "9 PERSONS IN RU" ;

label define H381044X
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H381045X
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H381046X
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H381047X
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H381048X
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H381049X
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H381050X
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H381051X
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H381052X
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H381053X
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H381054X
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H381055X
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H381056X
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H381057X
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H381058X
         -1 "-1 INAPPLICABLE"
         -2 "-2 DETERMINED IN PREVIOUS ROUND"
         -3 "-3 NO DATA IN ROUND"
         0 "0" ;

label define H381059X
         1 "1 ORIGINAL RESPONSE USED"
         2 "2 BRACKET CONVERTED"
         6 "6 UNCONDITIONAL HOTDECK" ;

label define H381060X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         99 "99 ASKED, BUT INAPPLICABLE" ;

label define H381061X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES"
         2 "2 NO" ;

label define H381062X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES"
         2 "2 NO" ;

label define H381063X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         99 "99 ASKED, BUT INAPPLICABLE" ;

label define H381064X
         -1 "-1 IN APPLICABLE"
         -3 "-3 NO DATA IN ROUND"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H381065X
         -1 "-1 IN APPLICABLE"
         -3 "-3 NO DATA IN ROUND"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H381066X
         -1 "-1 IN APPLICABLE"
         -3 "-3 NO DATA IN ROUND"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H381067X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES"
         2 "2 NO" ;

label define H381068X
         -1 "-1 INAPPLICABLE"
         -3 "-3 NO DATA IN ROUND"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES"
         2 "2 NO" ;

label define H381069X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES"
         2 "2 NO" ;

label define H381070X
         -1 "-1 INAPPLICABLE"
         -2 "-2 DETERMINED IN PREVIOUS ROUND"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES"
         2 "2 NO" ;

label define H381071X
         -1 "-1 INAPPLICABLE"
         -2 "-2 DETERMINED IN PREVIOUS ROUND"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES"
         2 "2 NO" ;

label define H381072X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 MALE"
         2 "2 FEMALE" ;

label define H381073X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES"
         2 "2 NO" ;

label define H381074X
         -1 "-1 INAPPLICABLE"
         -2 "-2 DETERMINED IN PREVIOUS ROUND"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES"
         2 "2 NO" ;

label define H381075X
         -1 "-1 INAPPLICABLE"
         -2 "-2 DETERMINED IN PREVIOUS ROUND"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES"
         2 "2 NO" ;

label define H381076X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         99 "99 ASKED, BUT INAPPLICABLE" ;

label define H381077X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES"
         2 "2 NO" ;

label define H381078X
         -1 "-1 INAPPLICABLE"
         -2 "-2 DETERMINED IN PREVIOUS ROUND"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES"
         2 "2 NO" ;

label define H381079X
         -1 "-1 INAPPLICABLE"
         -2 "-2 DETERMINED IN PREVIOUS ROUND"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES"
         2 "2 NO" ;

label define H381080X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES"
         2 "2 NO" ;

label define H381081X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES"
         2 "2 NO" ;

label define H381082X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 SET"
         2 "2 NOT SET" ;

label define H381083X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES, SPECIAL PROGRAM"
         2 "2 YES, EARLY INTERVENTION SERVICES"
         3 "3 YES, BOTH"
         4 "4 NO"
         91 "91 OTHER" ;

label define H381084X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES"
         2 "2 NO" ;

label define H381085X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES, ENROLLED IN SPECIAL EDUCATION"
         2 "2 YES, RELATED SERVICES"
         3 "3 YES, BOTH"
         4 "4 NO"
         91 "91 OTHER" ;

label define H381086X
         -1 "-1 INAPPLICABLE"
         995 "995 NO SPOUSE IN HOUSE"
         996 "996 MARITAL STATUS UNKNOWN"
         997 "997 LESS THAN 16 YRS OLD" ;

label define H381087X
         -1 "-1 INAPPLICABLE"
         995 "995 NO SPOUSE IN HOUSE"
         996 "996 MARITAL STATUS UNKNOWN"
         997 "997 LESS THAN 16 YRS OLD" ;

label define H381088X
         -1 "-1 INAPPLICABLE"
         995 "995 NO SPOUSE IN HOUSE"
         996 "996 MARITAL STATUS UNKNOWN"
         997 "997 LESS THAN 16 YRS OLD" ;

label define H381089X
         -1 "-1 INAPPLICABLE"
         995 "995 NO SPOUSE IN HOUSE"
         996 "996 MARITAL STATUS UNKNOWN"
         997 "997 LESS THAN 16 YRS OLD" ;

label define H381090X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 SPOUSE IN THE HOUSE"
         2 "2 NOT MARRIED/NO SPOUSE"
         3 "3 UNDER 16 - INAPPLICABLE" ;

label define H381091X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 SPOUSE IN THE HOUSE"
         2 "2 NOT MARRIED/NO SPOUSE"
         3 "3 UNDER 16 - INAPPLICABLE" ;

label define H381092X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 SPOUSE IN THE HOUSE"
         2 "2 NOT MARRIED/NO SPOUSE"
         3 "3 UNDER 16 - INAPPLICABLE" ;

label define H381093X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 SPOUSE IN THE HOUSE"
         2 "2 NOT MARRIED/NO SPOUSE"
         3 "3 UNDER 16 - INAPPLICABLE" ;

label define H381094X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         99 "99 ASKED, BUT INAPPLICABLE" ;

label define H381095X
         1 "1 ORIGINAL RESPONSE USED"
         2 "2 BRACKET CONVERTED"
         3 "3 MISSING VALUES SET TO 0"
         4 "4 WEEKS WORKED/EARNINGS USED(WAGEIMP ONLY)"
         5 "5 CONDITIONAL HOTDECK"
         6 "6 UNCONDITIONAL HOTDECK"
         7 "7 EDITED USING NHIS DATA" ;

label define H381096X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H381097X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H381098X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 DISABLILITY"
         2 "2 SOME OTHER REASON" ;

label define H381099X
         1 "1 ORIGINAL RESPONSE USED"
         2 "2 BRACKET CONVERTED"
         5 "5 CONDITIONAL HOTDECK"
         6 "6 UNCONDITIONAL HOTDECK" ;

label define H381100X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H381101X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H381102X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H381103X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H381104X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H381105X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H381106X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H381107X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H381108X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H381109X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H381110X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H381111X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H381112X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H381113X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED" ;

label define H381114X
         -1 "-1 INAPPLICABLE"
         -2 "-2 DETERMINED IN PREVIOUS ROUND"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED" ;

label define H381115X
         -1 "-1 INAPPLICABLE"
         -2 "-2 DETERMINED IN PREVIOUS ROUND"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED" ;

label define H381116X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 JANUARY"
         10 "10 OCTOBER"
         11 "11 NOVEMBER"
         12 "12 DECEMBER"
         2 "2 FEBRUARY"
         3 "3 MARCH"
         4 "4 APRIL"
         5 "5 MAY"
         6 "6 JUNE"
         7 "7 JULY"
         8 "8 AUGUST"
         9 "9 SEPTEMBER" ;

label define H381117X
         -1 "-1 INAPPLICABLE"
         -2 "-2 DETERMINED IN PREVIOUS ROUND"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 JANUARY"
         10 "10 OCTOBER"
         11 "11 NOVEMBER"
         12 "12 DECEMBER"
         2 "2 FEBRUARY"
         3 "3 MARCH"
         4 "4 APRIL"
         5 "5 MAY"
         6 "6 JUNE"
         7 "7 JULY"
         8 "8 AUGUST"
         9 "9 SEPTEMBER" ;

label define H381118X
         -1 "-1 INAPPLICABLE"
         -2 "-2 DETERMINED IN PREVIOUS ROUND"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 JANUARY"
         10 "10 OCTOBER"
         11 "11 NOVEMBER"
         12 "12 DECEMBER"
         2 "2 FEBRUARY"
         3 "3 MARCH"
         4 "4 APRIL"
         5 "5 MAY"
         6 "6 JUNE"
         7 "7 JULY"
         8 "8 AUGUST"
         9 "9 SEPTEMBER" ;

label define H381119X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED" ;

label define H381120X
         -1 "-1 INAPPLICABLE"
         -2 "-2 DETERMINED IN PREVIOUS ROUND"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED" ;

label define H381121X
         -1 "-1 INAPPLICABLE"
         -2 "-2 DETERMINED IN PREVIOUS ROUND"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED" ;

label define H381122X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 NO DIFFICULTY"
         2 "2 SOME DIFFICULTY"
         3 "3 A LOT OF DIFFICULTY"
         4 "4 UNABLE TO DO" ;

label define H381123X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 NO DIFFICULTY"
         2 "2 SOME DIFFICULTY"
         3 "3 A LOT OF DIFFICULTY"
         4 "4 UNABLE TO DO" ;

label define H381124X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 NO DIFFICULTY"
         2 "2 SOME DIFFICULTY"
         3 "3 A LOT OF DIFFICULTY"
         4 "4 UNABLE TO DO"
         5 "5 COMPLETLEY UNABLE TO WALK" ;

label define H381125X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 NO DIFFICULTY"
         2 "2 SOME DIFFICULTY"
         3 "3 A LOT OF DIFFICULTY"
         4 "4 UNABLE TO DO"
         5 "5 COMPLETELY UNABLE TO WALK" ;

label define H381126X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 LONG TERM 1040"
         2 "2 SHORT FORM 1040A"
         3 "3 SHORT FORAM 1040EZ"
         91 "91 OTHER" ;

label define H381127X
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H381128X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H381129X
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H381130X
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H381131X
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H381132X
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H381133X
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H381134X
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H381135X
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H381136X
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H381137X
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H381138X
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H381139X
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H381140X
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H381141X
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H381142X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         99 "99 ASKED, BUT INAPPLICABLE" ;

label define H381143X
         -1 "-1 INAPPLICABLE"
         -3 "-3 NO DATA IN ROUND"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES"
         2 "2 NO" ;

label define H381144X
         -1 "-1 INAPPLICABLE"
         -2 "-2 DETERMINED IN PREVIOUS ROUND"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H381145X
         1 "1 ORIGINAL RESPONSE USED"
         2 "2 BRACKET CONVERTED"
         5 "5 CONDITIONAL HOTDECK"
         6 "6 UNCONDITIONAL HOTDECK" ;

label define H381146X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H381147X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 SET"
         2 "2 NOT SET" ;

label define H381148X
         -1 "-1 INAPPLICABLE"
         -3 "-3 NO DATA IN ROUND"
         -9 "-9 NOT ASCERTAINED"
         1 "1 MD-GEN/FAM PRACTICE"
         10 "10 OTHER NON-MD PROVIDR"
         11 "11 UNKNOWN"
         2 "2 MD-INTERNAL MEDICINE"
         3 "3 MD-PEDIATRICS"
         4 "4 MD-OB/GYN"
         5 "5 MD-SURGERY"
         6 "6 MD-OTHER"
         7 "7 CHIROPRACTOR"
         8 "8 NURSE/NURSE PRACTNR"
         9 "9 PHYSICIAN'S ASST" ;

label define H381149X
         -1 "-1 INAPPLICABLE"
         -3 "-3 NO DATA IN ROUND"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 HOSP CLINIC/OUTPUT DEPT"
         2 "2 PRIV OFF IN HOSP"
         3 "3 HOSP ER"
         4 "4 NON-HOSP" ;

label define H381150X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES"
         2 "2 NO" ;

label define H381151X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES"
         2 "2 NO" ;

label define H381152X
         1 "1 ORIGINAL RESPONSE USED"
         2 "2 BRACKET CONVERTED"
         6 "6 UNCONDITIONAL HOTDECK" ;

label define H381153X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H381154X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H381155X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         99 "99 ASKED, BUT INAPPLICABLE" ;

label define H381156X
         -1 "-1 INAPPLICABLE"
         -3 "-3 NO DATA IN ROUND"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES"
         2 "2 NO" ;

label define H381157X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES"
         2 "2 NO" ;

label define H381158X
         -1 "-1 INAPPLICABLE"
         -2 "-2 DETERMINED IN PREVIOUS ROUND"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES"
         2 "2 NO" ;

label define H381159X
         -1 "-1 INAPPLICABLE"
         -2 "-2 DETERMINED IN PREVIOUS ROUND"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES"
         2 "2 NO" ;

label define H381160X
         -1 "-1 INAPPLICABLE"
         -3 "-3 NO DATA IN ROUND"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES"
         2 "2 NO" ;

label define H381161X
         -1 "-1 INAPPLICABLE"
         -3 "-3 NO DATA IN ROUND"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 VERY SATISFIED"
         2 "2 SOMEWHAT SATISFIED"
         3 "3 NOT TOO SATISFIED"
         4 "4 NOT AT ALL SATISFIED" ;

label define H381162X
         1 "1 ORIGINAL RESPONSE USED"
         3 "3 MISSING VALUES SET TO 0"
         6 "6 UNCONDITIONAL HOTDECK" ;

label define H381163X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES - SERVED"
         2 "2 NO - DID NOT SERVE"
         3 "3 UNDER 16 - INAPPLICABLE"
         4 "4 NEVER IN MILITARY" ;

label define H381164X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES - SERVED"
         2 "2 NO - DID NOT SERVE"
         3 "3 UNDER 16 - INAPPLICABLE"
         4 "4 NEVER IN MILITARY" ;

label define H381165X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES - SERVED"
         2 "2 NO - DID NOT SERVE"
         3 "3 UNDER 16 - INAPPLICABLE"
         4 "4 NEVER IN MILITARY" ;

label define H381166X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H381167X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES - SERVED"
         2 "2 NO - DID NOT SERVE"
         3 "3 UNDER 16 - INAPPLICABLE"
         4 "4 NEVER IN MILITARY" ;

label define H381168X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES - SERVED"
         2 "2 NO - DID NOT SERVE"
         3 "3 UNDER 16 - INAPPLICABLE"
         4 "4 NEVER IN MILITARY" ;

label define H381169X
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H381170X
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H381171X
         -1 "-1 INAPPLICABLE"
         -9 "-9 NOT ASCERTAINED"
         1 "1 NO DIFFICULTY"
         2 "2 SOME DIFFICULTY"
         3 "3 IMPAIRED NEAR, BUT NOT FAR"
         4 "4 IMPAIRED BOTH NEAR AND FAR"
         5 "5 BLIND" ;

label define H381172X
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H381173X
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H381174X
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H381175X
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H381176X
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H381177X
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H381178X
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H381179X
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H381180X
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H381181X
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H381182X
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H381183X
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H381184X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 SET"
         2 "2 NOT SET" ;

label define H381185X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H381186X
         1 "1 ORIGINAL RESPONSE USED"
         2 "2 BRACKET CONVERTED"
         3 "3 MISSING VALUES SET TO 0"
         4 "4 WEEKS WORKED/EARNINGS USED"
         5 "5 CONDITIONAL HOTDECK"
         6 "6 UNCONDITIONAL HOTDECK" ;

label define H381187X
         -1 "-1 INAPPLICABLE"
         -3 "-3 NO DATA IN ROUND"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 LESS THAN 5 MIN"
         2 "2 5 TO 15 MINUTES"
         3 "3 16 TO 30 MINUTES"
         4 "4 31 TO 59 MINUTES"
         5 "5 1 TO 2 HOURS"
         6 "6 MORE THAN 2 HOURS" ;

label define H381188X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H381189X
         1 "1 ORIGINAL RESPONSE USED"
         2 "2 BRACKET CONVERTED"
         5 "5 CONDITIONAL HOTDECK"
         6 "6 UNCONDITIONAL HOTDECK" ;

label define H381190X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED" ;

label define H381191X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED" ;

label define H381192X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 RELATIVE"
         2 "2 NON-RELATIVE" ;

label define H381193X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 CHILD'S HOME"
         2 "2 OTHER PRIVATE HOME"
         3 "3 NURSERY, PRESCHOOL"
         4 "4 ORG (BEFORE/AFTER) SCHOOL ACTIVITIES"
         5 "5 DAY CARE CENTER, NOT AT PARENT'S WORK"
         6 "6 DAY CARE CENTER, AT PARENT'S WORKPLACE"
         7 "7 PARENT WATCHES CHILD AT WORK"
         91 "91 SOME OTHER ARRANGEMENT" ;

label define H381194X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES"
         2 "2 NO" ;

label define H381195X
         -1 "-1 IN APPLICABLE"
         -3 "-3 NO DATA IN ROUND"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H381196X
         -1 "-1 IN APPLICABLE"
         -3 "-3 NO DATA IN ROUND"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H381197X
         -1 "-1 IN APPLICABLE"
         -3 "-3 NO DATA IN ROUND"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H381198X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 NO DIFFICULTY"
         2 "2 SOME DIFFICULTY"
         3 "3 A LOT OF DIFFICULTY"
         4 "4 UNABLE TO DO" ;

label define H381199X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 NO DIFFICULTY"
         2 "2 SOME DIFFICULTY"
         3 "3 A LOT OF DIFFICULTY"
         4 "4 UNABLE TO DO" ;

label define H381200X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES"
         2 "2 NO" ;

label define H381201X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES"
         2 "2 NO" ;

label define H381202X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES"
         2 "2 NO" ;

label define H381203X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES"
         2 "2 NO" ;

label define H381204X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES"
         2 "2 NO" ;

label define H381205X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 JOB ENDED"
         10 "10 QUIT TO TAKE ANOTHER JOB"
         11 "11 UNPAID LEAVE"
         2 "2 BUSINESS DISSOLVED OR SOLD"
         3 "3 RETIRED"
         4 "4 ILLNESS OR INJURY"
         5 "5 LAID OFF"
         6 "6 QUIT TO HAVE A BABY"
         7 "7 QUIT TO GO TO SCHOOL"
         8 "8 QUIT TO TAKE CARE OF HOME OR FAMILY"
         9 "9 QUIT BECAUSE WANTED TIME OFF"
         91 "91 OTHER" ;

label define H381206X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 JOB ENDED"
         10 "10 QUIT TO TAKE OTHER JOB"
         11 "11 UNPAID LEAVE"
         2 "2 BUSINESS DISSOLVED OR SOLD"
         3 "3 RETIRED"
         4 "4 ILLNESS OR INJURY"
         5 "5 LAID OFF"
         6 "6 QUIT TO HAVE A BABY"
         7 "7 QUIT TO GO TO SCHOOL"
         8 "8 QUIT TO TAKE CARE OF HOME OR FAMILY"
         9 "9 QUIT BECAUSE WANTED TIME OFF"
         91 "91 OTHER" ;

label define H381207X
         -1 "-1 INAPPLICABLE"
         -3 "-3 NO DATA IN ROUND"
         -8 "-8 DK"
         1 "1 FAM/PERS CHNGD INS PLAN"
         10 "10 JOB RELATED REASON"
         11 "11 NEW DOC REF/RECOM"
         12 "12 OTH COMPLNT OLD DOC"
         13 "13 TRANSPORTATION"
         2 "2 INSUR PLAN CHNG DOCS"
         3 "3 DISSATIS W/QUAL CARE"
         4 "4 HEALTH CARE NEEDS CHNGD"
         5 "5 TOO FAR AWAY"
         6 "6 MOVED TO NEW AREA"
         7 "7 OLD PROV NOT AVAIL"
         8 "8 COST-RELATED REASON"
         9 "9 OTHER INSUR-RELATED REASON"
         91 "91 OTHER REASON" ;

label define H381208X
         -1 "-1 INAPPLICABLE"
         -3 "-3 NO DATA IN ROUND"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 PREFERS/LIKES THIS USC"
         10 "10 INSURANCE RELATED REASON"
         2 "2 DK WHERE ELSE TO GO"
         3 "3 CANT AFFORD GO ELSEWHERE"
         4 "4 OWN DOC HAS OFFICE HERE"
         5 "5 ONLY CARE AVAIL WHEN TIME"
         6 "6 CONVENIENCE"
         7 "7 BEST FOR MY CONDITION"
         8 "8 MILITARY/VA"
         91 "91 OTHER REASON" ;

label define H381209X
         -1 "-1 INAPPLICABLE"
         -3 "-3 NO DATA IN ROUND"
         -8 "-8 DK"
         1 "1 FAM/PERS CHNGD INSUR PLAN"
         10 "10 OTH INSUR-RELATED REASON"
         2 "2 INSURANCE PLAN CHANGED DOCTORS IT COVERS"
         3 "3 DISSATIS W/ QUAL CARE"
         4 "4 HEALTH CARE NEEDS CHANGED"
         5 "5 TOO FAR AWAY"
         6 "6 MOVED TO NEW AREA"
         7 "7 OLD PROV NOT AVAIL"
         8 "8 COST-RELATED REASON"
         9 "9 SELDOM SICK/NO NEED"
         91 "91 OTHER REASON" ;

label define H381210X
         -1 "-1 INAPPLICABLE"
         -3 "-3 NO DATA IN ROUND"
         -8 "-8 DK"
         1 "1 SELDOM OR NEVER SICK"
         10 "10 OTHER INSUR-RELATED REAS"
         2 "2 RECENTLY MOVED TO AREA"
         3 "3 DONT KNOW WHERE TO GO"
         4 "4 USC IN AREA NOT AVAILABLE"
         5 "5 CANT FIND PROV SPEAK LANG"
         6 "6 GOES DIFF PL FOR DIFF NEEDS"
         7 "7 JUST CHANGED INSUR PLANS"
         8 "8 DONT USE DOCS/TREAT SELF"
         9 "9 COST OF MEDICAL CARE"
         91 "91 OTHER REASON" ;

label define H381211X
         -9 "-9 NOT ASCERTAINED"
         0 "0"
         252 "$252" ;

label define H381212X
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H381213X
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H381214X
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H381215X
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H381216X
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H381217X
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H381218X
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H381219X
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H381220X
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H381221X
         -9 "-9 NOT ASCERTAINED"
         0 "0"
         621 "$621" ;

label define H381222X
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H381223X
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H381224X
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H381225X
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H381226X
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H381227X
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H381228X
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H381229X
         -9 "-9 NOT ASCERTAINED"
         0 "0"
         454 "$454" ;

label define H381230X
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H381231X
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H381232X
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H381233X
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H381234X
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H381235X
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H381236X
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H381237X
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H381238X
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

* ASSOCIATE VARIABLES WITH VALUE LABEL DEFINITIONS;
label value ACCELI42 H380001X;
label value ACTDTY31 H380002X;
label value ACTDTY42 H380003X;
label value ACTDTY53 H380004X;
label value ACTLIM31 H380005X;
label value ACTLIM53 H380006X;
label value ADLHLP31 H380007X;
label value ADLHLP42 H380008X;
label value ADLHLP53 H380009X;
label value ADUPRO42 H380010X;
label value AFDC99 H380011X;
label value AFFORD42 H380012X;
label value AIDHLP31 H380013X;
label value AIDHLP53 H380014X;
label value ALIIMP99 H380015X;
label value ALIMP99X H380016X;
label value AMACHM99 H380017X;
label value AMAEXP99 H380018X;
label value AMAMCD99 H380019X;
label value AMAMCR99 H380020X;
label value AMAOFD99 H380021X;
label value AMAOPR99 H380022X;
label value AMAOPU99 H380023X;
label value AMAOSR99 H380024X;
label value AMAPRV99 H380025X;
label value AMASLF99 H380026X;
label value AMASST99 H380027X;
label value AMASTL99 H380028X;
label value AMATCH99 H380029X;
label value AMAVA99 H380030X;
label value AMAWCP99 H380031X;
label value AMCCHM99 H380032X;
label value AMCEXP99 H380033X;
label value AMCHIR99 H380034X;
label value AMCMCD99 H380035X;
label value AMCMCR99 H380036X;
label value AMCOFD99 H380037X;
label value AMCOPR99 H380038X;
label value AMCOPU99 H380039X;
label value AMCOSR99 H380040X;
label value AMCPRV99 H380041X;
label value AMCSLF99 H380042X;
label value AMCSTL99 H380043X;
label value AMCTCH99 H380044X;
label value AMCVA99 H380045X;
label value AMCWCP99 H380046X;
label value AMDRC99 H380047X;
label value AMECHM99 H380048X;
label value AMEEXP99 H380049X;
label value AMEMCD99 H380050X;
label value AMEMCR99 H380051X;
label value AMEOFD99 H380052X;
label value AMEOPR99 H380053X;
label value AMEOPU99 H380054X;
label value AMEOSR99 H380055X;
label value AMEPRV99 H380056X;
label value AMESLF99 H380057X;
label value AMESTL99 H380058X;
label value AMETCH99 H380059X;
label value AMEVA99 H380060X;
label value AMEWCP99 H380061X;
label value AMNCHM99 H380062X;
label value AMNEXP99 H380063X;
label value AMNMCD99 H380064X;
label value AMNMCR99 H380065X;
label value AMNOFD99 H380066X;
label value AMNOPR99 H380067X;
label value AMNOPU99 H380068X;
label value AMNOSR99 H380069X;
label value AMNPRV99 H380070X;
label value AMNSLF99 H380071X;
label value AMNSTL99 H380072X;
label value AMNTCH99 H380073X;
label value AMNURS99 H380074X;
label value AMNVA99 H380075X;
label value AMNWCP99 H380076X;
label value AMOPTO99 H380077X;
label value AMTCHM99 H380078X;
label value AMTEXP99 H380079X;
label value AMTHER99 H380080X;
label value AMTMCD99 H380081X;
label value AMTMCR99 H380082X;
label value AMTOFD99 H380083X;
label value AMTOPR99 H380084X;
label value AMTOPU99 H380085X;
label value AMTOSR99 H380086X;
label value AMTOTC99 H380087X;
label value AMTPRV99 H380088X;
label value AMTSLF99 H380089X;
label value AMTSTL99 H380090X;
label value AMTTCH99 H380091X;
label value AMTVA99 H380092X;
label value AMTWCP99 H380093X;
label value ANYLIM99 H380094X;
label value ANYUSC42 H380095X;
label value APPDIF42 H380096X;
label value APPTWL42 H380097X;
label value AVAILT42 H380098X;
label value BEGRFD31 H380099X;
label value BEGRFD42 H380100X;
label value BEGRFD53 H380101X;
label value BEGRFM31 H380102X;
label value BEGRFM42 H380103X;
label value BEGRFM53 H380104X;
label value BEGRFY31 H380105X;
label value BEGRFY42 H380106X;
label value BEGRFY53 H380107X;
label value BENDIF31 H380108X;
label value BENDIF53 H380109X;
label value BGNWK31 H380110X;
label value BGNWK42 H380111X;
label value BGNWK53 H380112X;
label value BLIND42 H380113X;
label value BSNTY31 H380114X;
label value BSNTY42 H380115X;
label value BSNTY53 H380116X;
label value BSTPLA42 H380117X;
label value BUSIMP99 H380118X;
label value BUSNP99X H380119X;
label value CANTPL42 H380120X;
label value CANTSC42 H380121X;
label value CARECO42 H380122X;
label value CASHP99X H380123X;
label value CHAP99X H380124X;
label value CHAU99X H380125X;
label value CHDE99X H380126X;
label value CHFE99X H380127X;
label value CHGJ3142 H380128X;
label value CHGJ4253 H380129X;
label value CHJA99X H380130X;
label value CHJL99X H380131X;
label value CHJU99X H380132X;
label value CHLDCA42 H380133X;
label value CHLDP99X H380134X;
label value CHLIM42 H380135X;
label value CHLIMP99 H380136X;
label value CHMA99X H380137X;
label value CHMY99X H380138X;
label value CHNGUS42 H380139X;
label value CHNO99X H380140X;
label value CHOC99X H380141X;
label value CHOIC31 H380142X;
label value CHOIC42 H380143X;
label value CHOIC53 H380144X;
label value CHPEV99 H380145X;
label value CHSE99X H380146X;
label value CIND31 H380147X;
label value CIND42 H380148X;
label value CIND53 H380149X;
label value CLMDEP99 H380150X;
label value CLMHIP99 H380151X;
label value COCCP31 H380152X;
label value COCCP42 H380153X;
label value COCCP53 H380154X;
label value COGLIM31 H380155X;
label value COGLIM53 H380156X;
label value CONFID42 H380157X;
label value CONVEN42 H380158X;
label value CSHIMP99 H380159X;
label value DADPRO42 H380160X;
label value DAPID31X H380161X;
label value DAPID42X H380162X;
label value DAPID53X H380163X;
label value DAYCAR99 H380164X;
label value DDBDYS31 H380165X;
label value DDBDYS42 H380166X;
label value DDBDYS53 H380167X;
label value DDNSCL31 H380168X;
label value DDNSCL42 H380169X;
label value DDNSCL53 H380170X;
label value DDNWRK31 H380171X;
label value DDNWRK42 H380172X;
label value DDNWRK53 H380173X;
label value DEAF42 H380174X;
label value DEDUCT99 H380175X;
label value DENTIN31 H380176X;
label value DENTIN42 H380177X;
label value DENTIN53 H380178X;
label value DEPDNT99 H380179X;
label value DIDSERVE H380180X;
label value DIFFPL42 H380181X;
label value DISTAN42 H380182X;
label value DISVW31X H380183X;
label value DISVW42X H380184X;
label value DISVW53X H380185X;
label value DIVDP99X H380186X;
label value DIVIMP99 H380187X;
label value DKELSE42 H380188X;
label value DKWHER42 H380189X;
label value DKWHRU42 H380190X;
label value DOBMM H380191X;
label value DOBYY H380192X;
label value DPINRU99 H380193X;
label value DPOTSD99 H380194X;
label value DPTSHT42 H380195X;
label value DVOMCR99 H380196X;
label value DVOSTL99 H380197X;
label value EDUCYEAR H380198X;
label value EICRDT99 H380199X;
label value ELDISC99 H380200X;
label value ELGRND31 H380201X;
label value ELGRND42 H380202X;
label value ELGRND53 H380203X;
label value ELGRND99 H380204X;
label value ELIGIBLE H380205X;
label value EMPST31 H380206X;
label value EMPST42 H380207X;
label value EMPST53 H380208X;
label value ENDRFD31 H380209X;
label value ENDRFD42 H380210X;
label value ENDRFD53 H380211X;
label value ENDRFD99 H380212X;
label value ENDRFM31 H380213X;
label value ENDRFM42 H380214X;
label value ENDRFM53 H380215X;
label value ENDRFM99 H380216X;
label value ENDRFY31 H380217X;
label value ENDRFY42 H380218X;
label value ENDRFY53 H380219X;
label value ENDRFY99 H380220X;
label value ENDWK31 H380221X;
label value ENDWK42 H380222X;
label value ENDWK53 H380223X;
label value EQUIPM42 H380224X;
label value ERDCHM99 H380225X;
label value ERDEXP99 H380226X;
label value ERDMCD99 H380227X;
label value ERDMCR99 H380228X;
label value ERDOFD99 H380229X;
label value ERDOPR99 H380230X;
label value ERDOPU99 H380231X;
label value ERDOSR99 H380232X;
label value ERDPRV99 H380233X;
label value ERDSLF99 H380234X;
label value ERDSTL99 H380235X;
label value ERDTCH99 H380236X;
label value ERDVA99 H380237X;
label value ERDWCP99 H380238X;
label value ERFCHM99 H380239X;
label value ERFEXP99 H380240X;
label value ERFMCD99 H380241X;
label value ERFMCR99 H380242X;
label value ERFOFD99 H380243X;
label value ERFOPR99 H380244X;
label value ERFOPU99 H380245X;
label value ERFOSR99 H380246X;
label value ERFPRV99 H380247X;
label value ERFSLF99 H380248X;
label value ERFSTL99 H380249X;
label value ERFTCH99 H380250X;
label value ERFVA99 H380251X;
label value ERFWCP99 H380252X;
label value ERTOT99 H380253X;
label value EVRETIRE H380254X;
label value EVRWRK H380255X;
label value EXPENS42 H380256X;
label value FAMCNS42 H380257X;
label value FAMRFPYR H380258X;
label value FAMSZE31 H380259X;
label value FAMSZE42 H380260X;
label value FAMSZE53 H380261X;
label value FAMSZE99 H380262X;
label value FARIMP99 H380263X;
label value FARMP99X H380264X;
label value FCRP1231 H380265X;
label value FILEDR99 H380266X;
label value FILER99 H380267X;
label value FLSTAT99 H380268X;
label value FMRS1231 H380269X;
label value FNGRDF31 H380270X;
label value FNGRDF53 H380271X;
label value FOODCT99 H380272X;
label value FOODMN99 H380273X;
label value FOODST99 H380274X;
label value FOODVL99 H380275X;
label value FTSTU31X H380276X;
label value FTSTU42X H380277X;
label value FTSTU53X H380278X;
label value FTSTU99X H380279X;
label value FYFAMTYP H380280X;
label value GETSIC42 H380281X;
label value GETTOU42 H380282X;
label value HAVEUS42 H380283X;
label value HAVFUN42 H380284X;
label value HCNEED42 H380285X;
label value HEARAD42 H380286X;
label value HEARDI42 H380287X;
label value HEARMO42 H380288X;
label value HEARNG42 H380289X;
label value HEARPR42 H380290X;
label value HEARSM42 H380291X;
label value HELD31X H380292X;
label value HELD42X H380293X;
label value HELD53X H380294X;
label value HEPSHT42 H380295X;
label value HGTFT42 H380296X;
label value HGTIN42 H380297X;
label value HHACHM99 H380298X;
label value HHAEXP99 H380299X;
label value HHAGD99 H380300X;
label value HHAMCD99 H380301X;
label value HHAMCR99 H380302X;
label value HHAOFD99 H380303X;
label value HHAOPR99 H380304X;
label value HHAOPU99 H380305X;
label value HHAOSR99 H380306X;
label value HHAPRV99 H380307X;
label value HHASLF99 H380308X;
label value HHASTL99 H380309X;
label value HHATCH99 H380310X;
label value HHAVA99 H380311X;
label value HHAWCP99 H380312X;
label value HHINDD99 H380313X;
label value HHINFD99 H380314X;
label value HHNCHM99 H380315X;
label value HHNEXP99 H380316X;
label value HHNMCD99 H380317X;
label value HHNMCR99 H380318X;
label value HHNOFD99 H380319X;
label value HHNOPR99 H380320X;
label value HHNOPU99 H380321X;
label value HHNOSR99 H380322X;
label value HHNPRV99 H380323X;
label value HHNSLF99 H380324X;
label value HHNSTL99 H380325X;
label value HHNTCH99 H380326X;
label value HHNVA99 H380327X;
label value HHNWCP99 H380328X;
label value HHTOTD99 H380329X;
label value HIDEGYR H380330X;
label value HISPANX H380331X;
label value HISPCAT H380332X;
label value HLTHY42 H380333X;
label value HOMEBH42 H380334X;
label value HOUR31 H380335X;
label value HOUR42 H380336X;
label value HOUR53 H380337X;
label value HPDAP99 H380338X;
label value HPDAU99 H380339X;
label value HPDDE99 H380340X;
label value HPDFE99 H380341X;
label value HPDJA99 H380342X;
label value HPDJL99 H380343X;
label value HPDJU99 H380344X;
label value HPDMA99 H380345X;
label value HPDMY99 H380346X;
label value HPDNO99 H380347X;
label value HPDOC99 H380348X;
label value HPDSE99 H380349X;
label value HPEAP99 H380350X;
label value HPEAU99 H380351X;
label value HPEDE99 H380352X;
label value HPEFE99 H380353X;
label value HPEJA99 H380354X;
label value HPEJL99 H380355X;
label value HPEJU99 H380356X;
label value HPEMA99 H380357X;
label value HPEMY99 H380358X;
label value HPENO99 H380359X;
label value HPEOC99 H380360X;
label value HPESE99 H380361X;
label value HPNAP99 H380362X;
label value HPNAU99 H380363X;
label value HPNDE99 H380364X;
label value HPNFE99 H380365X;
label value HPNJA99 H380366X;
label value HPNJL99 H380367X;
label value HPNJU99 H380368X;
label value HPNMA99 H380369X;
label value HPNMY99 H380370X;
label value HPNNO99 H380371X;
label value HPNOC99 H380372X;
label value HPNSE99 H380373X;
label value HPOAP99 H380374X;
label value HPOAU99 H380375X;
label value HPODE99 H380376X;
label value HPOFE99 H380377X;
label value HPOJA99 H380378X;
label value HPOJL99 H380379X;
label value HPOJU99 H380380X;
label value HPOMA99 H380381X;
label value HPOMY99 H380382X;
label value HPONO99 H380383X;
label value HPOOC99 H380384X;
label value HPOSE99 H380385X;
label value HPRAP99 H380386X;
label value HPRAU99 H380387X;
label value HPRDE99 H380388X;
label value HPRFE99 H380389X;
label value HPRJA99 H380390X;
label value HPRJL99 H380391X;
label value HPRJU99 H380392X;
label value HPRMA99 H380393X;
label value HPRMY99 H380394X;
label value HPRNO99 H380395X;
label value HPROC99 H380396X;
label value HPRSE99 H380397X;
label value HPSAP99 H380398X;
label value HPSAU99 H380399X;
label value HPSDE99 H380400X;
label value HPSFE99 H380401X;
label value HPSJA99 H380402X;
label value HPSJL99 H380403X;
label value HPSJU99 H380404X;
label value HPSMA99 H380405X;
label value HPSMY99 H380406X;
label value HPSNO99 H380407X;
label value HPSOC99 H380408X;
label value HPSSE99 H380409X;
label value HRHOW31 H380410X;
label value HRHOW42 H380411X;
label value HRHOW53 H380412X;
label value HRWG31X H380413X;
label value HRWG42X H380414X;
label value HRWG53X H380415X;
label value HRWGIM31 H380416X;
label value HRWGIM42 H380417X;
label value HRWGIM53 H380418X;
label value HSELIM31 H380419X;
label value HSELIM53 H380420X;
label value IADLHP31 H380421X;
label value IADLHP42 H380422X;
label value IADLHP53 H380423X;
label value INRU1231 H380424X;
label value INSAP99X H380425X;
label value INSAU99X H380426X;
label value INSC1231 H380427X;
label value INSCOP31 H380428X;
label value INSCOP42 H380429X;
label value INSCOP53 H380430X;
label value INSCOP99 H380431X;
label value INSCOPE H380432X;
label value INSCOV99 H380433X;
label value INSDE99X H380434X;
label value INSFE99X H380435X;
label value INSIDE42 H380436X;
label value INSJA99X H380437X;
label value INSJL99X H380438X;
label value INSJU99X H380439X;
label value INSMA99X H380440X;
label value INSMY99X H380441X;
label value INSNO99X H380442X;
label value INSNOP42 H380443X;
label value INSOC99X H380444X;
label value INSREA42 H380445X;
label value INSRPL42 H380446X;
label value INSRQR42 H380447X;
label value INSSE99X H380448X;
label value INTIMP99 H380449X;
label value INTOBL42 H380450X;
label value INTRP99X H380451X;
label value INTRTX99 H380452X;
label value INTVLANG H380453X;
label value IPDCHM99 H380454X;
label value IPDEXP99 H380455X;
label value IPDIS99 H380456X;
label value IPDMCD99 H380457X;
label value IPDMCR99 H380458X;
label value IPDOFD99 H380459X;
label value IPDOPR99 H380460X;
label value IPDOPU99 H380461X;
label value IPDOSR99 H380462X;
label value IPDPRV99 H380463X;
label value IPDSLF99 H380464X;
label value IPDSTL99 H380465X;
label value IPDTCH99 H380466X;
label value IPDVA99 H380467X;
label value IPDWCP99 H380468X;
label value IPFCHM99 H380469X;
label value IPFEXP99 H380470X;
label value IPFMCD99 H380471X;
label value IPFMCR99 H380472X;
label value IPFOFD99 H380473X;
label value IPFOPR99 H380474X;
label value IPFOPU99 H380475X;
label value IPFOSR99 H380476X;
label value IPFPRV99 H380477X;
label value IPFSLF99 H380478X;
label value IPFSTL99 H380479X;
label value IPFTCH99 H380480X;
label value IPFVA99 H380481X;
label value IPFWCP99 H380482X;
label value IPNGTD99 H380483X;
label value IPZERO99 H380484X;
label value IRAIMP99 H380485X;
label value IRASP99X H380486X;
label value IRATAX99 H380487X;
label value ITMEXP99 H380488X;
label value JNTPID99 H380489X;
label value JOBORG31 H380490X;
label value JOBORG42 H380491X;
label value JOBORG53 H380492X;
label value JTINRU99 H380493X;
label value KEYNESS H380494X;
label value KIDPRO42 H380495X;
label value LANGBA42 H380496X;
label value LFTDIF31 H380497X;
label value LFTDIF53 H380498X;
label value LIFSKL42 H380499X;
label value LIKESU42 H380500X;
label value LIMACT42 H380501X;
label value LMOACT42 H380502X;
label value LOCATI42 H380503X;
label value MAINPR42 H380504X;
label value MARRY31X H380505X;
label value MARRY42X H380506X;
label value MARRY53X H380507X;
label value MARRY99X H380508X;
label value MCDAP99 H380509X;
label value MCDAP99X H380510X;
label value MCDAU99 H380511X;
label value MCDAU99X H380512X;
label value MCDDE99 H380513X;
label value MCDDE99X H380514X;
label value MCDEV99 H380515X;
label value MCDFE99 H380516X;
label value MCDFE99X H380517X;
label value MCDJA99 H380518X;
label value MCDJA99X H380519X;
label value MCDJL99 H380520X;
label value MCDJL99X H380521X;
label value MCDJU99 H380522X;
label value MCDJU99X H380523X;
label value MCDMA99 H380524X;
label value MCDMA99X H380525X;
label value MCDMY99 H380526X;
label value MCDMY99X H380527X;
label value MCDNO99 H380528X;
label value MCDNO99X H380529X;
label value MCDOC99 H380530X;
label value MCDOC99X H380531X;
label value MCDSE99 H380532X;
label value MCDSE99X H380533X;
label value MCRAP99 H380534X;
label value MCRAP99X H380535X;
label value MCRAU99 H380536X;
label value MCRAU99X H380537X;
label value MCRDE99 H380538X;
label value MCRDE99X H380539X;
label value MCREV99 H380540X;
label value MCRFE99 H380541X;
label value MCRFE99X H380542X;
label value MCRJA99 H380543X;
label value MCRJA99X H380544X;
label value MCRJL99 H380545X;
label value MCRJL99X H380546X;
label value MCRJU99 H380547X;
label value MCRJU99X H380548X;
label value MCRMA99 H380549X;
label value MCRMA99X H380550X;
label value MCRMY99 H380551X;
label value MCRMY99X H380552X;
label value MCRNO99 H380553X;
label value MCRNO99X H380554X;
label value MCROC99 H380555X;
label value MCROC99X H380556X;
label value MCRSE99 H380557X;
label value MCRSE99X H380558X;
label value MEXAMT99 H380559X;
label value MILDIF31 H380560X;
label value MILDIF53 H380561X;
label value MINORP42 H380562X;
label value MMRSHT42 H380563X;
label value MNHLTH31 H380564X;
label value MNHLTH42 H380565X;
label value MNHLTH53 H380566X;
label value MNPROX31 H380567X;
label value MNPROX42 H380568X;
label value MNPROX53 H380569X;
label value MOMPRO42 H380570X;
label value MOPID31X H380571X;
label value MOPID42X H380572X;
label value MOPID53X H380573X;
label value MORE31 H380574X;
label value MORE42 H380575X;
label value MORE53 H380576X;
label value MORJOB31 H380577X;
label value MORJOB42 H380578X;
label value MORJOB53 H380579X;
label value MSA53 H380580X;
label value MSA99 H380581X;
label value MYSELF42 H380582X;
label value NERVAF42 H380583X;
label value NEWARE42 H380584X;
label value NOAFFO42 H380585X;
label value NOCARE42 H380586X;
label value NOOTHP42 H380587X;
label value NOREA942 H380588X;
label value NOREAS42 H380589X;
label value NOTIME42 H380590X;
label value NTHLTH42 H380591X;
label value NTMDED99 H380592X;
label value NUMDPT42 H380593X;
label value NUMEMP31 H380594X;
label value NUMEMP42 H380595X;
label value NUMEMP53 H380596X;
label value NUMPOL42 H380597X;
label value NWK31 H380598X;
label value NWK42 H380599X;
label value NWK53 H380600X;
label value OBACHM99 H380601X;
label value OBAEXP99 H380602X;
label value OBAMCD99 H380603X;
label value OBAMCR99 H380604X;
label value OBAOFD99 H380605X;
label value OBAOPR99 H380606X;
label value OBAOPU99 H380607X;
label value OBAOSR99 H380608X;
label value OBAPRV99 H380609X;
label value OBASLF99 H380610X;
label value OBASST99 H380611X;
label value OBASTL99 H380612X;
label value OBATCH99 H380613X;
label value OBAVA99 H380614X;
label value OBAWCP99 H380615X;
label value OBCCHM99 H380616X;
label value OBCEXP99 H380617X;
label value OBCHIR99 H380618X;
label value OBCMCD99 H380619X;
label value OBCMCR99 H380620X;
label value OBCOFD99 H380621X;
label value OBCOPR99 H380622X;
label value OBCOPU99 H380623X;
label value OBCOSR99 H380624X;
label value OBCPRV99 H380625X;
label value OBCSLF99 H380626X;
label value OBCSTL99 H380627X;
label value OBCTCH99 H380628X;
label value OBCVA99 H380629X;
label value OBCWCP99 H380630X;
label value OBDCHM99 H380631X;
label value OBDEXP99 H380632X;
label value OBDMCD99 H380633X;
label value OBDMCR99 H380634X;
label value OBDOFD99 H380635X;
label value OBDOPR99 H380636X;
label value OBDOPU99 H380637X;
label value OBDOSR99 H380638X;
label value OBDPRV99 H380639X;
label value OBDRV99 H380640X;
label value OBDSLF99 H380641X;
label value OBDSTL99 H380642X;
label value OBDTCH99 H380643X;
label value OBDVA99 H380644X;
label value OBDWCP99 H380645X;
label value OBECHM99 H380646X;
label value OBEEXP99 H380647X;
label value OBEMCD99 H380648X;
label value OBEMCR99 H380649X;
label value OBEOFD99 H380650X;
label value OBEOPR99 H380651X;
label value OBEOPU99 H380652X;
label value OBEOSR99 H380653X;
label value OBEPRV99 H380654X;
label value OBESLF99 H380655X;
label value OBESTL99 H380656X;
label value OBETCH99 H380657X;
label value OBEVA99 H380658X;
label value OBEWCP99 H380659X;
label value OBNCHM99 H380660X;
label value OBNEXP99 H380661X;
label value OBNMCD99 H380662X;
label value OBNMCR99 H380663X;
label value OBNOFD99 H380664X;
label value OBNOPR99 H380665X;
label value OBNOPU99 H380666X;
label value OBNOSR99 H380667X;
label value OBNPRV99 H380668X;
label value OBNSLF99 H380669X;
label value OBNSTL99 H380670X;
label value OBNTCH99 H380671X;
label value OBNURS99 H380672X;
label value OBNVA99 H380673X;
label value OBNWCP99 H380674X;
label value OBOCHM99 H380675X;
label value OBOEXP99 H380676X;
label value OBOMCD99 H380677X;
label value OBOMCR99 H380678X;
label value OBOOFD99 H380679X;
label value OBOOPR99 H380680X;
label value OBOOPU99 H380681X;
label value OBOOSR99 H380682X;
label value OBOPRV99 H380683X;
label value OBOPTO99 H380684X;
label value OBOSLF99 H380685X;
label value OBOSTL99 H380686X;
label value OBOTCH99 H380687X;
label value OBOTHV99 H380688X;
label value OBOVA99 H380689X;
label value OBOWCP99 H380690X;
label value OBTAIN42 H380691X;
label value OBTCHM99 H380692X;
label value OBTEXP99 H380693X;
label value OBTHER99 H380694X;
label value OBTMCD99 H380695X;
label value OBTMCR99 H380696X;
label value OBTOFD99 H380697X;
label value OBTOPR99 H380698X;
label value OBTOPU99 H380699X;
label value OBTOSR99 H380700X;
label value OBTOTV99 H380701X;
label value OBTPRV99 H380702X;
label value OBTSLF99 H380703X;
label value OBTSTL99 H380704X;
label value OBTTCH99 H380705X;
label value OBTVA99 H380706X;
label value OBTWCP99 H380707X;
label value OBVCHM99 H380708X;
label value OBVEXP99 H380709X;
label value OBVMCD99 H380710X;
label value OBVMCR99 H380711X;
label value OBVOFD99 H380712X;
label value OBVOPR99 H380713X;
label value OBVOPU99 H380714X;
label value OBVOSR99 H380715X;
label value OBVPRV99 H380716X;
label value OBVSLF99 H380717X;
label value OBVSTL99 H380718X;
label value OBVTCH99 H380719X;
label value OBVVA99 H380720X;
label value OBVWCP99 H380721X;
label value OCUPTH42 H380722X;
label value OFFER31X H380723X;
label value OFFER42X H380724X;
label value OFFER53X H380725X;
label value OFFHOU42 H380726X;
label value OFFICE42 H380727X;
label value OFFWOR42 H380728X;
label value OPAAP99 H380729X;
label value OPAAU99 H380730X;
label value OPADE99 H380731X;
label value OPAEV99 H380732X;
label value OPAFE99 H380733X;
label value OPAJA99 H380734X;
label value OPAJL99 H380735X;
label value OPAJU99 H380736X;
label value OPAMA99 H380737X;
label value OPAMY99 H380738X;
label value OPANO99 H380739X;
label value OPAOC99 H380740X;
label value OPASE99 H380741X;
label value OPBAP99 H380742X;
label value OPBAU99 H380743X;
label value OPBDE99 H380744X;
label value OPBEV99 H380745X;
label value OPBFE99 H380746X;
label value OPBJA99 H380747X;
label value OPBJL99 H380748X;
label value OPBJU99 H380749X;
label value OPBMA99 H380750X;
label value OPBMY99 H380751X;
label value OPBNO99 H380752X;
label value OPBOC99 H380753X;
label value OPBSE99 H380754X;
label value OPDCHM99 H380755X;
label value OPDEXP99 H380756X;
label value OPDMCD99 H380757X;
label value OPDMCR99 H380758X;
label value OPDOFD99 H380759X;
label value OPDOPR99 H380760X;
label value OPDOPU99 H380761X;
label value OPDOSR99 H380762X;
label value OPDPRV99 H380763X;
label value OPDRV99 H380764X;
label value OPDSLF99 H380765X;
label value OPDSTL99 H380766X;
label value OPDTCH99 H380767X;
label value OPDVA99 H380768X;
label value OPDWCP99 H380769X;
label value OPFCHM99 H380770X;
label value OPFEXP99 H380771X;
label value OPFMCD99 H380772X;
label value OPFMCR99 H380773X;
label value OPFOFD99 H380774X;
label value OPFOPR99 H380775X;
label value OPFOPU99 H380776X;
label value OPFOSR99 H380777X;
label value OPFPRV99 H380778X;
label value OPFSLF99 H380779X;
label value OPFSTL99 H380780X;
label value OPFTCH99 H380781X;
label value OPFVA99 H380782X;
label value OPFWCP99 H380783X;
label value OPOCHM99 H380784X;
label value OPOEXP99 H380785X;
label value OPOMCD99 H380786X;
label value OPOMCR99 H380787X;
label value OPOOFD99 H380788X;
label value OPOOPR99 H380789X;
label value OPOOPU99 H380790X;
label value OPOOSR99 H380791X;
label value OPOPRV99 H380792X;
label value OPOSLF99 H380793X;
label value OPOSTL99 H380794X;
label value OPOTCH99 H380795X;
label value OPOTHV99 H380796X;
label value OPOVA99 H380797X;
label value OPOWCP99 H380798X;
label value OPPCHM99 H380799X;
label value OPPEXP99 H380800X;
label value OPPMCD99 H380801X;
label value OPPMCR99 H380802X;
label value OPPOFD99 H380803X;
label value OPPOPR99 H380804X;
label value OPPOPU99 H380805X;
label value OPPOSR99 H380806X;
label value OPPPRV99 H380807X;
label value OPPSLF99 H380808X;
label value OPPSTL99 H380809X;
label value OPPTCH99 H380810X;
label value OPPVA99 H380811X;
label value OPPWCP99 H380812X;
label value OPSCHM99 H380813X;
label value OPSEXP99 H380814X;
label value OPSMCD99 H380815X;
label value OPSMCR99 H380816X;
label value OPSOFD99 H380817X;
label value OPSOPR99 H380818X;
label value OPSOPU99 H380819X;
label value OPSOSR99 H380820X;
label value OPSPRV99 H380821X;
label value OPSSLF99 H380822X;
label value OPSSTL99 H380823X;
label value OPSTCH99 H380824X;
label value OPSVA99 H380825X;
label value OPSWCP99 H380826X;
label value OPTOTV99 H380827X;
label value OPVCHM99 H380828X;
label value OPVEXP99 H380829X;
label value OPVMCD99 H380830X;
label value OPVMCR99 H380831X;
label value OPVOFD99 H380832X;
label value OPVOPR99 H380833X;
label value OPVOPU99 H380834X;
label value OPVOSR99 H380835X;
label value OPVPRV99 H380836X;
label value OPVSLF99 H380837X;
label value OPVSTL99 H380838X;
label value OPVTCH99 H380839X;
label value OPVVA99 H380840X;
label value OPVWCP99 H380841X;
label value OTHCHM99 H380842X;
label value OTHDYS31 H380843X;
label value OTHDYS42 H380844X;
label value OTHDYS53 H380845X;
label value OTHEXP99 H380846X;
label value OTHIMP99 H380847X;
label value OTHINS42 H380848X;
label value OTHMCD99 H380849X;
label value OTHMCR99 H380850X;
label value OTHNDD31 H380851X;
label value OTHNDD42 H380852X;
label value OTHNDD53 H380853X;
label value OTHOFD99 H380854X;
label value OTHOPR99 H380855X;
label value OTHOPU99 H380856X;
label value OTHOSR99 H380857X;
label value OTHPRV99 H380858X;
label value OTHRE942 H380859X;
label value OTHREA42 H380860X;
label value OTHRP99X H380861X;
label value OTHRPR42 H380862X;
label value OTHSLF99 H380863X;
label value OTHSTL99 H380864X;
label value OTHSVC42 H380865X;
label value OTHTCH99 H380866X;
label value OTHVA99 H380867X;
label value OTHWCP99 H380868X;
label value PANEL99 H380869X;
label value PAYDR31 H380870X;
label value PAYDR42 H380871X;
label value PAYDR53 H380872X;
label value PAYVAC31 H380873X;
label value PAYVAC42 H380874X;
label value PAYVAC53 H380875X;
label value PDKAP99 H380876X;
label value PDKAU99 H380877X;
label value PDKDE99 H380878X;
label value PDKFE99 H380879X;
label value PDKJA99 H380880X;
label value PDKJL99 H380881X;
label value PDKJU99 H380882X;
label value PDKMA99 H380883X;
label value PDKMY99 H380884X;
label value PDKNO99 H380885X;
label value PDKOC99 H380886X;
label value PDKSE99 H380887X;
label value PEGAP99 H380888X;
label value PEGAU99 H380889X;
label value PEGDE99 H380890X;
label value PEGFE99 H380891X;
label value PEGJA99 H380892X;
label value PEGJL99 H380893X;
label value PEGJU99 H380894X;
label value PEGMA99 H380895X;
label value PEGMY99 H380896X;
label value PEGNO99 H380897X;
label value PEGOC99 H380898X;
label value PEGSE99 H380899X;
label value PENIMP99 H380900X;
label value PENSP99X H380901X;
label value PERSLA42 H380902X;
label value PHONED42 H380903X;
label value PHYTHR42 H380904X;
label value PLYLIM42 H380905X;
label value PMEDIN31 H380906X;
label value PMEDIN42 H380907X;
label value PMEDIN53 H380908X;
label value PNGAP99 H380909X;
label value PNGAU99 H380910X;
label value PNGDE99 H380911X;
label value PNGFE99 H380912X;
label value PNGJA99 H380913X;
label value PNGJL99 H380914X;
label value PNGJU99 H380915X;
label value PNGMA99 H380916X;
label value PNGMY99 H380917X;
label value PNGNO99 H380918X;
label value PNGOC99 H380919X;
label value PNGSE99 H380920X;
label value POGAP99 H380921X;
label value POGAU99 H380922X;
label value POGDE99 H380923X;
label value POGFE99 H380924X;
label value POGJA99 H380925X;
label value POGJL99 H380926X;
label value POGJU99 H380927X;
label value POGMA99 H380928X;
label value POGMY99 H380929X;
label value POGNO99 H380930X;
label value POGOC99 H380931X;
label value POGSE99 H380932X;
label value POLSHT42 H380933X;
label value POUAP99 H380934X;
label value POUAU99 H380935X;
label value POUDE99 H380936X;
label value POUFE99 H380937X;
label value POUJA99 H380938X;
label value POUJL99 H380939X;
label value POUJU99 H380940X;
label value POUMA99 H380941X;
label value POUMY99 H380942X;
label value POUNO99 H380943X;
label value POUOC99 H380944X;
label value POUSE99 H380945X;
label value POVCAT99 H380946X;
label value PREEXC42 H380947X;
label value PREVEN42 H380948X;
label value PRIAP99 H380949X;
label value PRIAU99 H380950X;
label value PRIDE99 H380951X;
label value PRIFE99 H380952X;
label value PRIJA99 H380953X;
label value PRIJL99 H380954X;
label value PRIJU99 H380955X;
label value PRIMA99 H380956X;
label value PRIMY99 H380957X;
label value PRINO99 H380958X;
label value PRIOC99 H380959X;
label value PRISE99 H380960X;
label value PRLIST42 H380961X;
label value PROVST42 H380962X;
label value PROVTY42 H380963X;
label value PROXY31 H380964X;
label value PROXY42 H380965X;
label value PROXY53 H380966X;
label value PROXY99 H380967X;
label value PRSAP99 H380968X;
label value PRSAU99 H380969X;
label value PRSDE99 H380970X;
label value PRSFE99 H380971X;
label value PRSJA99 H380972X;
label value PRSJL99 H380973X;
label value PRSJU99 H380974X;
label value PRSMA99 H380975X;
label value PRSMY99 H380976X;
label value PRSNO99 H380977X;
label value PRSOC99 H380978X;
label value PRSSE99 H380979X;
label value PRVEV99 H380980X;
label value PSTATS31 H380981X;
label value PSTATS42 H380982X;
label value PSTATS53 H380983X;
label value PSYCNS42 H380984X;
label value PUBAP99X H380985X;
label value PUBAU99X H380986X;
label value PUBDE99X H380987X;
label value PUBFE99X H380988X;
label value PUBIMP99 H380989X;
label value PUBJA99X H380990X;
label value PUBJL99X H380991X;
label value PUBJU99X H380992X;
label value PUBMA99X H380993X;
label value PUBMY99X H380994X;
label value PUBNO99X H380995X;
label value PUBOC99X H380996X;
label value PUBP99X H380997X;
label value PUBSE99X H380998X;
label value PUBTRA42 H380999X;
label value R2FLAG H381000X;
label value RACETHNX H381001X;
label value RACEX H381002X;
label value RCHDIF31 H381003X;
label value RCHDIF53 H381004X;
label value READIN42 H381005X;
label value READNW42 H381006X;
label value RECPEP42 H381007X;
label value RECTHR42 H381008X;
label value REFDP99X H381009X;
label value REFFRL42 H381010X;
label value REFIMP99 H381011X;
label value REFUSE42 H381012X;
label value REFUSI42 H381013X;
label value REGION31 H381014X;
label value REGION42 H381015X;
label value REGION53 H381016X;
label value REGION99 H381017X;
label value RESP31 H381018X;
label value RESP42 H381019X;
label value RESP53 H381020X;
label value RESP99 H381021X;
label value RETPLN31 H381022X;
label value RETPLN42 H381023X;
label value RETPLN53 H381024X;
label value RFREL31X H381025X;
label value RFREL42X H381026X;
label value RFREL53X H381027X;
label value RFREL99X H381028X;
label value RNDFLG31 H381029X;
label value RTHLTH31 H381030X;
label value RTHLTH42 H381031X;
label value RTHLTH53 H381032X;
label value RTPROX31 H381033X;
label value RTPROX42 H381034X;
label value RTPROX53 H381035X;
label value RUCLAS31 H381036X;
label value RUCLAS42 H381037X;
label value RUCLAS53 H381038X;
label value RUCLAS99 H381039X;
label value RUSIZE31 H381040X;
label value RUSIZE42 H381041X;
label value RUSIZE53 H381042X;
label value RUSIZE99 H381043X;
label value RXCHM99 H381044X;
label value RXEXP99 H381045X;
label value RXMCD99 H381046X;
label value RXMCR99 H381047X;
label value RXOFD99 H381048X;
label value RXOPR99 H381049X;
label value RXOPU99 H381050X;
label value RXOSR99 H381051X;
label value RXPRV99 H381052X;
label value RXSLF99 H381053X;
label value RXSTL99 H381054X;
label value RXTOT99 H381055X;
label value RXVA99 H381056X;
label value RXWCP99 H381057X;
label value SALEP99X H381058X;
label value SALIMP99 H381059X;
label value SCHLBH42 H381060X;
label value SCHLIM31 H381061X;
label value SCHLIM53 H381062X;
label value SCHPRO42 H381063X;
label value SCLNBD31 H381064X;
label value SCLNBD42 H381065X;
label value SCLNBD53 H381066X;
label value SEEDIF42 H381067X;
label value SELDSI42 H381068X;
label value SELFCM31 H381069X;
label value SELFCM42 H381070X;
label value SELFCM53 H381071X;
label value SEX H381072X;
label value SHFTWK31 H381073X;
label value SHFTWK42 H381074X;
label value SHFTWK53 H381075X;
label value SIBPRO42 H381076X;
label value SICPAY31 H381077X;
label value SICPAY42 H381078X;
label value SICPAY53 H381079X;
label value SOCLIM31 H381080X;
label value SOCLIM53 H381081X;
label value SPCHTH42 H381082X;
label value SPCPRO42 H381083X;
label value SPCSCH42 H381084X;
label value SPECED42 H381085X;
label value SPOUID31 H381086X;
label value SPOUID42 H381087X;
label value SPOUID53 H381088X;
label value SPOUID99 H381089X;
label value SPOUIN31 H381090X;
label value SPOUIN42 H381091X;
label value SPOUIN53 H381092X;
label value SPOUIN99 H381093X;
label value SPRPRO42 H381094X;
label value SSCIMP99 H381095X;
label value SSECP99X H381096X;
label value SSECTX99 H381097X;
label value SSIDIS99 H381098X;
label value SSIIMP99 H381099X;
label value SSIP99X H381100X;
label value STAAP99 H381101X;
label value STAAU99 H381102X;
label value STADE99 H381103X;
label value STAFE99 H381104X;
label value STAJA99 H381105X;
label value STAJL99 H381106X;
label value STAJU99 H381107X;
label value STAMA99 H381108X;
label value STAMY99 H381109X;
label value STANO99 H381110X;
label value STAOC99 H381111X;
label value STASE99 H381112X;
label value STJBDD31 H381113X;
label value STJBDD42 H381114X;
label value STJBDD53 H381115X;
label value STJBMM31 H381116X;
label value STJBMM42 H381117X;
label value STJBMM53 H381118X;
label value STJBYY31 H381119X;
label value STJBYY42 H381120X;
label value STJBYY53 H381121X;
label value STNDIF31 H381122X;
label value STNDIF53 H381123X;
label value STPDIF31 H381124X;
label value STPDIF53 H381125X;
label value TAXFRM99 H381126X;
label value TOTCHM99 H381127X;
label value TOTDED99 H381128X;
label value TOTEXP99 H381129X;
label value TOTMCD99 H381130X;
label value TOTMCR99 H381131X;
label value TOTOFD99 H381132X;
label value TOTOPR99 H381133X;
label value TOTOPU99 H381134X;
label value TOTOSR99 H381135X;
label value TOTPRV99 H381136X;
label value TOTSLF99 H381137X;
label value TOTSTL99 H381138X;
label value TOTTCH99 H381139X;
label value TOTVA99 H381140X;
label value TOTWCP99 H381141X;
label value TRBLE42 H381142X;
label value TREATM42 H381143X;
label value TRSTP99X H381144X;
label value TRTIMP99 H381145X;
label value TTLP99X H381146X;
label value TUTOR42 H381147X;
label value TYPEPE42 H381148X;
label value TYPEPL42 H381149X;
label value UNABLE31 H381150X;
label value UNABLE53 H381151X;
label value UNEIMP99 H381152X;
label value UNEMP99X H381153X;
label value UNEMTX99 H381154X;
label value UNHAP42 H381155X;
label value UNINS99 H381156X;
label value UNION31 H381157X;
label value UNION42 H381158X;
label value UNION53 H381159X;
label value USCNOT42 H381160X;
label value USCQUA42 H381161X;
label value VETIMP99 H381162X;
label value VETKOR H381163X;
label value VETOTH H381164X;
label value VETPVIET H381165X;
label value VETSP99X H381166X;
label value VETVIET H381167X;
label value VETWW H381168X;
label value VISCHM99 H381169X;
label value VISEXP99 H381170X;
label value VISION42 H381171X;
label value VISMCD99 H381172X;
label value VISMCR99 H381173X;
label value VISOFD99 H381174X;
label value VISOPR99 H381175X;
label value VISOPU99 H381176X;
label value VISOSR99 H381177X;
label value VISPRV99 H381178X;
label value VISSLF99 H381179X;
label value VISSTL99 H381180X;
label value VISTCH99 H381181X;
label value VISVA99 H381182X;
label value VISWCP99 H381183X;
label value VOCSVC42 H381184X;
label value WAGEP99X H381185X;
label value WAGIMP99 H381186X;
label value WAITTI42 H381187X;
label value WCMPP99X H381188X;
label value WCPIMP99 H381189X;
label value WGTLB42 H381190X;
label value WGTOZ42 H381191X;
label value WHOCAR99 H381192X;
label value WHRCAR99 H381193X;
label value WILFIL99 H381194X;
label value WKINBD31 H381195X;
label value WKINBD42 H381196X;
label value WKINBD53 H381197X;
label value WLKDIF31 H381198X;
label value WLKDIF53 H381199X;
label value WLKLIM31 H381200X;
label value WLKLIM53 H381201X;
label value WRGLAS42 H381202X;
label value WRKLIM31 H381203X;
label value WRKLIM53 H381204X;
label value YCHJ3142 H381205X;
label value YCHJ4253 H381206X;
label value YCHNGU42 H381207X;
label value YGOTOU42 H381208X;
label value YNOMOR42 H381209X;
label value YNOUSC42 H381210X;
label value ZIDCHM99 H381211X;
label value ZIDEXP99 H381212X;
label value ZIDMCD99 H381213X;
label value ZIDMCR99 H381214X;
label value ZIDOFD99 H381215X;
label value ZIDOPR99 H381216X;
label value ZIDOPU99 H381217X;
label value ZIDOSR99 H381218X;
label value ZIDPRV99 H381219X;
label value ZIDSLF99 H381220X;
label value ZIDSTL99 H381221X;
label value ZIDTCH99 H381222X;
label value ZIDVA99 H381223X;
label value ZIDWCP99 H381224X;
label value ZIFCHM99 H381225X;
label value ZIFEXP99 H381226X;
label value ZIFMCD99 H381227X;
label value ZIFMCR99 H381228X;
label value ZIFOFD99 H381229X;
label value ZIFOPR99 H381230X;
label value ZIFOPU99 H381231X;
label value ZIFOSR99 H381232X;
label value ZIFPRV99 H381233X;
label value ZIFSLF99 H381234X;
label value ZIFSTL99 H381235X;
label value ZIFTCH99 H381236X;
label value ZIFVA99 H381237X;
label value ZIFWCP99 H381238X;

*DISPLAY A DESCRIPTION OF STATA FILE;
describe;

*LIST FIRST 20 OBSERVATIONS IN THE FILE;
list in 1/20;


#delimit cr


/************************************************************************************************
 NOTES:                                                                                          
                                                                                                 
 1. This program has been tested on Stata Version 10 (for Windows).                              
                                                                                                 
 2. This program will create a permanent Stata dataset.  All additional analyses                 
    can be run using this dataset.  In addition to the dataset, this program creates             
    a log file named H38.LOG and a data file named H38.DTA.  If these files (H38.DTA and H38.LOG)
    already exist in the working directory, they will be replaced when this program is executed. 
                                                                                                 
 3. If the program ends prematurely, the log file will remain open.  Before running this         
    program again, the user should enter the following Stata command: log close                  
                                                                                                 
 4. The cd command assigns C:\MEPS\DATA as the working directory and location of the input       
    ASCII and output .DTA and .LOG files and can be modified by the user as necessary.           
                                                                                                 
 5. Stata commands end with a carriage return by default. The command                            
    #delimit ;                                                                                   
    temporarily changes the command ending delimiter from a carriage return to a semicolon.      
                                                                                                 
 6. The infix command assumes that the input variables are numeric unless the variable name      
    is prefaced by str.  For example, DUPERSID is the a string (or character) variable.          
                                                                                                 
************************************************************************************************/

